/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.popup.UIForumForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIForumForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UIForumForm
extends UIForm
implements UIPopupComponent,
UISelector {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private boolean isCategoriesUpdate = true;
    private boolean isForumUpdate = false;
    private boolean isMode = false;
    private String forumId = "";
    private int id = 0;
    public static final String FIELD_NEWFORUM_FORM = "newForum";
    public static final String FIELD_MODERATOROPTION_FORM = "moderationOptions";
    public static final String FIELD_FORUMPERMISSION_FORM = "forumPermission";
    public static final String FIELD_CATEGORY_SELECTBOX = "Category";
    public static final String FIELD_FORUMTITLE_INPUT = "ForumTitle";
    public static final String FIELD_FORUMORDER_INPUT = "ForumOrder";
    public static final String FIELD_FORUMSTATUS_SELECTBOX = "ForumStatus";
    public static final String FIELD_FORUMSTATE_SELECTBOX = "ForumState";
    public static final String FIELD_DESCRIPTION_TEXTAREA = "Description";
    public static final String FIELD_NOTIFYWHENADDTOPIC_MULTIVALUE = "NotifyWhenAddTopic";
    public static final String FIELD_NOTIFYWHENADDPOST_MULTIVALUE = "NotifyWhenAddPost";
    public static final String FIELD_MODERATETHREAD_CHECKBOX = "ModerateThread";
    public static final String FIELD_MODERATEPOST_CHECKBOX = "ModeratePost";
    public static final String FIELD_MODERATOR_MULTIVALUE = "Moderator";
    public static final String FIELD_VIEWER_MULTIVALUE = "Viewer";
    public static final String FIELD_POSTABLE_MULTIVALUE = "Postable";
    public static final String FIELD_TOPICABLE_MULTIVALUE = "Topicable";

    public boolean isMode() {
        return this.isMode;
    }

    public void setMode(boolean isMode) {
        this.isMode = isMode;
    }

    public void initForm() throws Exception {
        List categorys = this.forumService.getCategories(ForumSessionUtils.getSystemProvider());
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        for (Category category : categorys) {
            list.add(new SelectItemOption(category.getCategoryName(), (Object)category.getId()));
        }
        UIFormSelectBox categoryId = new UIFormSelectBox(FIELD_CATEGORY_SELECTBOX, FIELD_CATEGORY_SELECTBOX, list);
        categoryId.setDefaultValue((Object)((Category)categorys.get(0)).getId());
        UIFormStringInput forumTitle = new UIFormStringInput(FIELD_FORUMTITLE_INPUT, FIELD_FORUMTITLE_INPUT, null);
        forumTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput forumOrder = new UIFormStringInput(FIELD_FORUMORDER_INPUT, FIELD_FORUMORDER_INPUT, "0");
        forumOrder.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption("Open", (Object)"open"));
        ls.add(new SelectItemOption("Closed", (Object)"closed"));
        UIFormSelectBox forumState = new UIFormSelectBox(FIELD_FORUMSTATE_SELECTBOX, FIELD_FORUMSTATE_SELECTBOX, ls);
        forumState.setDefaultValue((Object)"open");
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("UnLock"), (Object)"unlock"));
        ls.add(new SelectItemOption(this.getLabel("Locked"), (Object)"locked"));
        UIFormSelectBox forumStatus = new UIFormSelectBox(FIELD_FORUMSTATUS_SELECTBOX, FIELD_FORUMSTATUS_SELECTBOX, ls);
        forumStatus.setDefaultValue((Object)"unlock");
        UIFormTextAreaInput description = new UIFormTextAreaInput(FIELD_DESCRIPTION_TEXTAREA, FIELD_DESCRIPTION_TEXTAREA, null);
        UIFormTextAreaInput notifyWhenAddPost = new UIFormTextAreaInput(FIELD_NOTIFYWHENADDPOST_MULTIVALUE, FIELD_NOTIFYWHENADDPOST_MULTIVALUE, null);
        UIFormTextAreaInput notifyWhenAddTopic = new UIFormTextAreaInput(FIELD_NOTIFYWHENADDTOPIC_MULTIVALUE, FIELD_NOTIFYWHENADDTOPIC_MULTIVALUE, null);
        UIFormTextAreaInput moderator = new UIFormTextAreaInput(FIELD_MODERATOR_MULTIVALUE, FIELD_MODERATOR_MULTIVALUE, null);
        UIFormTextAreaInput viewer = new UIFormTextAreaInput(FIELD_VIEWER_MULTIVALUE, FIELD_VIEWER_MULTIVALUE, null);
        UIFormTextAreaInput postable = new UIFormTextAreaInput(FIELD_POSTABLE_MULTIVALUE, FIELD_POSTABLE_MULTIVALUE, null);
        UIFormTextAreaInput topicable = new UIFormTextAreaInput(FIELD_TOPICABLE_MULTIVALUE, FIELD_TOPICABLE_MULTIVALUE, null);
        UIFormCheckBoxInput checkWhenAddTopic = new UIFormCheckBoxInput(FIELD_MODERATETHREAD_CHECKBOX, FIELD_MODERATETHREAD_CHECKBOX, (Object)false);
        this.addUIFormInput((UIFormInput)categoryId);
        UIFormInputWithActions newForum = new UIFormInputWithActions(FIELD_NEWFORUM_FORM);
        newForum.addUIFormInput((UIFormInput)forumTitle);
        newForum.addUIFormInput((UIFormInput)forumOrder);
        newForum.addUIFormInput((UIFormInput)forumState);
        newForum.addUIFormInput((UIFormInput)forumStatus);
        newForum.addUIFormInput((UIFormInput)description);
        UIFormInputWithActions moderationOptions = new UIFormInputWithActions(FIELD_MODERATOROPTION_FORM);
        moderationOptions.addUIFormInput((UIFormInput)notifyWhenAddPost);
        moderationOptions.addUIFormInput((UIFormInput)notifyWhenAddTopic);
        moderationOptions.addUIFormInput((UIFormInput)checkWhenAddTopic);
        UIFormInputWithActions forumPermission = new UIFormInputWithActions(FIELD_FORUMPERMISSION_FORM);
        forumPermission.addUIFormInput((UIFormInput)moderator);
        forumPermission.addUIFormInput((UIFormInput)topicable);
        forumPermission.addUIFormInput((UIFormInput)postable);
        forumPermission.addUIFormInput((UIFormInput)viewer);
        String[] fieldPermissions = this.getChildIds();
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        for (String fieldPermission : fieldPermissions) {
            if (this.isMode && fieldPermission.equals(FIELD_MODERATOR_MULTIVALUE)) continue;
            ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
            int i = 0;
            for (String string : strings) {
                UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
                ad.setActionListener("AddValuesUser");
                ad.setActionParameter(fieldPermission + "/" + String.valueOf(i));
                ad.setCssIconClass(string + "Icon");
                ad.setActionName(string);
                actions.add(ad);
                ++i;
            }
            forumPermission.setActionField(fieldPermission, actions);
        }
        this.addUIFormInput((UIFormInputSet)newForum);
        this.addUIFormInput((UIFormInputSet)moderationOptions);
        this.addUIFormInput((UIFormInputSet)forumPermission);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    public void setForumValue(Forum forum, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.forumId = forum.getId();
            UIFormInputWithActions newForum = (UIFormInputWithActions)this.getChildById(FIELD_NEWFORUM_FORM);
            newForum.getUIStringInput(FIELD_FORUMTITLE_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)forum.getForumName()));
            newForum.getUIStringInput(FIELD_FORUMORDER_INPUT).setValue((Object)String.valueOf(forum.getForumOrder()));
            String stat = "open";
            if (forum.getIsClosed()) {
                stat = "closed";
            }
            newForum.getUIFormSelectBox(FIELD_FORUMSTATE_SELECTBOX).setValue(stat);
            stat = forum.getIsLock() ? "locked" : "unlock";
            newForum.getUIFormSelectBox(FIELD_FORUMSTATUS_SELECTBOX).setValue(stat);
            newForum.getUIFormTextAreaInput(FIELD_DESCRIPTION_TEXTAREA).setDefaultValue((Object)ForumTransformHTML.unCodeHTML((String)forum.getDescription()));
            UIFormInputWithActions moderationOptions = (UIFormInputWithActions)this.getChildById(FIELD_MODERATOROPTION_FORM);
            moderationOptions.getUIFormTextAreaInput(FIELD_NOTIFYWHENADDPOST_MULTIVALUE).setDefaultValue((Object)ForumUtils.unSplitForForum((String[])forum.getNotifyWhenAddPost()));
            moderationOptions.getUIFormTextAreaInput(FIELD_NOTIFYWHENADDTOPIC_MULTIVALUE).setDefaultValue((Object)ForumUtils.unSplitForForum((String[])forum.getNotifyWhenAddTopic()));
            moderationOptions.getUIFormCheckBoxInput(FIELD_MODERATETHREAD_CHECKBOX).setChecked(forum.getIsModerateTopic());
            UIFormInputWithActions forumPermission = (UIFormInputWithActions)this.getChildById(FIELD_FORUMPERMISSION_FORM);
            UIFormTextAreaInput areaInput = forumPermission.getUIFormTextAreaInput(FIELD_MODERATOR_MULTIVALUE);
            areaInput.setValue((Object)ForumUtils.unSplitForForum((String[])forum.getModerators()));
            areaInput.setEditable(!this.isMode);
            areaInput.setEnable(!this.isMode);
            forumPermission.getUIFormTextAreaInput(FIELD_VIEWER_MULTIVALUE).setValue((Object)ForumUtils.unSplitForForum((String[])forum.getViewer()));
            forumPermission.getUIFormTextAreaInput(FIELD_TOPICABLE_MULTIVALUE).setValue((Object)ForumUtils.unSplitForForum((String[])forum.getCreateTopicRole()));
            forumPermission.getUIFormTextAreaInput(FIELD_POSTABLE_MULTIVALUE).setValue((Object)ForumUtils.unSplitForForum((String[])forum.getPoster()));
        }
    }

    public void setCategoryValue(String categoryId, boolean isEditable) throws Exception {
        if (!isEditable) {
            this.getUIFormSelectBox(FIELD_CATEGORY_SELECTBOX).setValue(categoryId);
        }
        this.getUIFormSelectBox(FIELD_CATEGORY_SELECTBOX).setEnable(isEditable);
        this.isCategoriesUpdate = isEditable;
    }

    public void setForumUpdate(boolean isForumUpdate) {
        this.isForumUpdate = isForumUpdate;
    }

    private String[] getChildIds() {
        return new String[]{FIELD_MODERATOR_MULTIVALUE, FIELD_TOPICABLE_MULTIVALUE, FIELD_POSTABLE_MULTIVALUE, FIELD_VIEWER_MULTIVALUE};
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        if (selectField.indexOf("Notify") >= 0) {
            fieldInput.setValue((Object)value);
        } else {
            String values = (String)fieldInput.getValue();
            if (!ForumUtils.isEmpty((String)values)) {
                if (!ForumUtils.isStringInStrings((String[])(values = ForumUtils.removeSpaceInString((String)values)).split(","), (String)value)) {
                    if (values.lastIndexOf(",") != values.length() - 1) {
                        values = values + ",";
                    }
                    values = values + value;
                }
            } else {
                values = value;
            }
            fieldInput.setValue((Object)values);
        }
    }

    static /* synthetic */ String access$000(UIForumForm x0) {
        return x0.forumId;
    }

    static /* synthetic */ boolean access$100(UIForumForm x0) {
        return x0.isForumUpdate;
    }

    static /* synthetic */ boolean access$200(UIForumForm x0) {
        return x0.isCategoriesUpdate;
    }

    static /* synthetic */ int access$302(UIForumForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }
}

