/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumListSearch;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UICategories.gtmpl", events={@EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={OpenForumLinkActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={OpenLastTopicLinkActionListener.class})})
public class UICategories
extends UIContainer {
    protected ForumService forumService;
    private Map<String, List<Forum>> mapListForum = new HashMap();
    private Map<String, Topic> maptopicLast = new HashMap();
    private List<Category> categoryList = new ArrayList();
    private Map<String, Forum> AllForum = new HashMap();
    public final String FORUM_LIST_SEARCH = "forumListSearch";
    private boolean isGetForumList = false;
    private boolean isRenderChild = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private UserProfile userProfile;

    public UICategories() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        ((UIForumListSearch)this.addChild(UIForumListSearch.class, null, null)).setRendered(this.isRenderChild);
    }

    public void setIsRenderChild(boolean isRenderChild) {
        ((UIForumListSearch)this.getChild(UIForumListSearch.class)).setRendered(isRenderChild);
        this.isRenderChild = isRenderChild;
    }

    public boolean getIsRendered() throws Exception {
        return this.isRenderChild;
    }

    private UserProfile getUserProfile() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.useAjax = forumPortlet.isUseAjax();
        this.dayForumNewPost = forumPortlet.getDayForumNewPost();
        this.userProfile = forumPortlet.getUserProfile();
        return this.userProfile;
    }

    private int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public boolean getUseAjax() {
        return this.useAjax;
    }

    public List<Category> getCategorys() {
        return this.categoryList;
    }

    public List<Category> getPrivateCategories() {
        ArrayList<Category> list = new ArrayList<Category>();
        for (Category cate : this.categoryList) {
            if (cate.getUserPrivate() == null || cate.getUserPrivate().length <= 0) continue;
            list.add(cate);
        }
        return list;
    }

    public List<Forum> getForums(String categoryId) {
        return (List)this.mapListForum.get(categoryId);
    }

    public Map<String, Forum> getAllForum() {
        return this.AllForum;
    }

    private boolean isShowCategory(String id) {
        ArrayList list = new ArrayList();
        list.addAll(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleCategories());
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(id);
    }

    private boolean isShowForum(String id) {
        ArrayList list = new ArrayList();
        list.addAll(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleForums());
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Category> getCategoryList() throws Exception {
        ((UIBreadcumbs)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getChild(UIBreadcumbs.class)).setUpdataPath(Utils.FORUM_SERVICE);
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            this.categoryList = this.forumService.getCategories(sProvider);
        }
        catch (Exception e) {
            this.categoryList = new ArrayList();
        }
        finally {
            sProvider.close();
        }
        if (this.categoryList.size() > 0) {
            ((UIForumActionBar)((UICategoryContainer)this.getParent()).getChild(UIForumActionBar.class)).setHasCategory(true);
        } else {
            ((UIForumActionBar)((UICategoryContainer)this.getParent()).getChild(UIForumActionBar.class)).setHasCategory(false);
        }
        return this.categoryList;
    }

    public void setIsgetForumList(boolean isGetForumList) {
        this.isGetForumList = isGetForumList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Forum> getForumList(String categoryId) throws Exception {
        ArrayList forumList = null;
        String strQuery = "";
        if (this.userProfile.getUserRole() > 0L) {
            strQuery = "(@exo:isClosed='false') or (exo:moderators='" + this.userProfile.getUserId() + "')";
        }
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            forumList = this.forumService.getForums(sProvider, categoryId, strQuery);
        }
        catch (Exception e) {
            forumList = new ArrayList();
        }
        finally {
            sProvider.close();
        }
        if (this.mapListForum.containsKey(categoryId)) {
            this.mapListForum.remove(categoryId);
        }
        this.mapListForum.put(categoryId, forumList);
        ArrayList<Forum> listForum = new ArrayList<Forum>();
        for (Forum forum : forumList) {
            String forumId = forum.getId();
            if (this.AllForum.containsKey(forumId)) {
                this.AllForum.remove(forumId);
            }
            this.AllForum.put(forumId, forum);
            if (!this.isShowForum(forumId)) continue;
            listForum.add(forum);
        }
        return listForum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Forum getForumById(String categoryId, String forumId) throws Exception {
        Forum forum_ = new Forum();
        if (!this.mapListForum.isEmpty() && !this.isGetForumList) {
            for (Forum forum : (List)this.mapListForum.get(categoryId)) {
                if (!forum.getId().equals(forumId)) continue;
                forum_ = forum;
                break;
            }
        }
        if (forum_ == null) {
            SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
            try {
                forum_ = this.forumService.getForum(sProvider, categoryId, forumId);
            }
            finally {
                sProvider.close();
            }
        }
        return forum_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic getLastTopic(String topicPath) throws Exception {
        Topic topic = null;
        if (!ForumUtils.isEmpty((String)topicPath)) {
            String topicId = topicPath;
            if (topicId.indexOf("/") >= 0) {
                topicId = topicId.substring(topicPath.lastIndexOf("/") + 1);
            }
            if ((topic = (Topic)this.maptopicLast.get(topicId)) == null) {
                SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
                if (topicPath.indexOf("ForumService") < 0) {
                    topicPath = this.forumService.getForumHomePath(sProvider) + "/" + topicPath;
                }
                try {
                    topic = this.forumService.getTopicByPath(sProvider, topicPath, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    sProvider.close();
                }
                if (topic != null) {
                    this.maptopicLast.put(topic.getId(), topic);
                }
            }
        }
        return topic;
    }

    private Category getCategory(String categoryId) throws Exception {
        for (Category category : this.getCategoryList()) {
            if (!category.getId().equals(categoryId)) continue;
            return category;
        }
        return null;
    }

    private boolean getIsPrivate(String[] uesrs) throws Exception {
        if (uesrs != null && uesrs.length > 0 && !uesrs[0].equals(" ")) {
            return ForumServiceUtils.hasPermission((String[])uesrs, (String)this.userProfile.getUserId());
        }
        return true;
    }

    static /* synthetic */ Category access$000(UICategories x0, String x1) throws Exception {
        return x0.getCategory(x1);
    }

    static /* synthetic */ List access$100(UICategories x0, String x1) throws Exception {
        return x0.getForumList(x1);
    }

    static /* synthetic */ Map access$200(UICategories x0) {
        return x0.maptopicLast;
    }

    static /* synthetic */ Forum access$300(UICategories x0, String x1, String x2) throws Exception {
        return x0.getForumById(x1, x2);
    }

    static /* synthetic */ Topic access$400(UICategories x0, String x1) throws Exception {
        return x0.getLastTopic(x1);
    }

    static /* synthetic */ UserProfile access$500(UICategories x0) {
        return x0.userProfile;
    }
}

