/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UICategory;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UICategory.gtmpl", events={@EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={ExportCategoryActionListener.class}), @EventConfig(listeners={ImportForumActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UICategory.confirm.DeleteCategory"), @EventConfig(listeners={AddForumActionListener.class}), @EventConfig(listeners={EditForumActionListener.class}), @EventConfig(listeners={SetLockedActionListener.class}), @EventConfig(listeners={SetUnLockActionListener.class}), @EventConfig(listeners={SetOpenActionListener.class}), @EventConfig(listeners={SetCloseActionListener.class}), @EventConfig(listeners={MoveForumActionListener.class}), @EventConfig(listeners={RemoveForumActionListener.class}), @EventConfig(listeners={OpenForumLinkActionListener.class}), @EventConfig(listeners={OpenLastTopicLinkActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UICategory
extends UIForm {
    private UserProfile userProfile = null;
    private String categoryId;
    private Category category;
    private boolean isEditCategory = false;
    private boolean isEditForum = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private ForumService forumService;
    private List<Forum> forums = new ArrayList();
    private Map<String, Topic> MaptopicLast = new HashMap();

    public UICategory() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        this.setActions(new String[]{"EditCategory", "ExportCategory", "ImportForum", "DeleteCategory", "WatchOption", "AddForum", "EditForum", "SetLocked", "SetUnLock", "SetOpen", "SetClose", "MoveForum", "RemoveForum"});
    }

    private UserProfile getUserProfile() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.useAjax = forumPortlet.isUseAjax();
        this.dayForumNewPost = forumPortlet.getDayForumNewPost();
        this.userProfile = forumPortlet.getUserProfile();
        return this.userProfile;
    }

    private int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public void update(Category category, List<Forum> forums) throws Exception {
        this.category = category;
        if (forums == null) {
            this.isEditForum = true;
        } else {
            this.forums = forums;
        }
        this.categoryId = category.getId();
        ((UIBreadcumbs)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getChild(UIBreadcumbs.class)).setUpdataPath(this.categoryId);
    }

    public void updateByBreadcumbs(String categoryId) {
        this.categoryId = categoryId;
        this.isEditCategory = true;
        this.isEditForum = true;
    }

    public void updateByLink(Category category) {
        this.categoryId = category.getId();
        this.isEditCategory = false;
        this.isEditForum = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Category getCategory() throws Exception {
        if (this.isEditCategory || this.category == null) {
            SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
            try {
                this.category = this.forumService.getCategory(sProvider, this.categoryId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sProvider.close();
            }
            this.isEditCategory = true;
        }
        return this.category;
    }

    private boolean isShowForum(String id) {
        ArrayList list = new ArrayList();
        list.addAll(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleForums());
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Forum> getForumList() throws Exception {
        if (this.isEditForum) {
            String strQuery = "";
            if (this.userProfile.getUserRole() > 0L) {
                strQuery = "(@exo:isClosed='false') or (exo:moderators='" + this.userProfile.getUserId() + "')";
            }
            SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
            try {
                this.forums = this.forumService.getForums(sProvider, this.categoryId, strQuery);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sProvider.close();
            }
            this.isEditForum = false;
            ((UICategories)((UICategoryContainer)this.getAncestorOfType(UICategoryContainer.class)).getChild(UICategories.class)).setIsgetForumList(true);
        }
        ArrayList<Forum> listForum = new ArrayList<Forum>();
        for (Forum forum : this.forums) {
            String forumId = forum.getId();
            if (this.getUIFormCheckBoxInput(forumId) != null) {
                this.getUIFormCheckBoxInput(forumId).setChecked(false);
            } else {
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(forumId, forumId, (Object)false));
            }
            if (!this.isShowForum(forumId)) continue;
            listForum.add(forum);
        }
        return listForum;
    }

    public void setIsEditCategory(boolean isEdit) {
        this.isEditCategory = isEdit;
    }

    public void setIsEditForum(boolean isEdit) {
        this.isEditForum = isEdit;
    }

    private Forum getForum(String forumId) throws Exception {
        for (Forum forum : this.forums) {
            if (!forum.getId().equals(forumId)) continue;
            return forum;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic getLastTopic(String topicPath) throws Exception {
        Topic topic;
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            topic = this.forumService.getTopicByPath(ForumSessionUtils.getSystemProvider(), topicPath, true);
        }
        catch (Exception e) {
            topic = null;
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        if (topic != null) {
            String topicId = topic.getId();
            if (this.MaptopicLast.containsKey(topicId)) {
                this.MaptopicLast.remove(topicId);
            }
            this.MaptopicLast.put(topicId, topic);
        }
        return topic;
    }

    private Topic getTopic(String topicId) throws Exception {
        if (this.MaptopicLast.containsKey(topicId)) {
            return (Topic)this.MaptopicLast.get(topicId);
        }
        return null;
    }

    static /* synthetic */ Category access$000(UICategory x0) throws Exception {
        return x0.getCategory();
    }

    static /* synthetic */ boolean access$102(UICategory x0, boolean x1) {
        x0.isEditCategory = x1;
        return x0.isEditCategory;
    }

    static /* synthetic */ String access$200(UICategory x0) {
        return x0.categoryId;
    }

    static /* synthetic */ ForumService access$300(UICategory x0) {
        return x0.forumService;
    }

    static /* synthetic */ boolean access$402(UICategory x0, boolean x1) {
        x0.isEditForum = x1;
        return x0.isEditForum;
    }

    static /* synthetic */ Forum access$500(UICategory x0, String x1) throws Exception {
        return x0.getForum(x1);
    }

    static /* synthetic */ Topic access$600(UICategory x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ Category access$700(UICategory x0) {
        return x0.category;
    }

    static /* synthetic */ UserProfile access$800(UICategory x0) {
        return x0.userProfile;
    }
}

