/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.user.ForumContact;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UIPostRules;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicDetail.gtmpl", events={@EventConfig(listeners={AddPostActionListener.class}), @EventConfig(listeners={RatingTopicActionListener.class}), @EventConfig(listeners={AddTagTopicActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class}), @EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisPost"), @EventConfig(listeners={PrivatePostActionListener.class}), @EventConfig(listeners={QuoteActionListener.class}), @EventConfig(listeners={EditTopicActionListener.class}), @EventConfig(listeners={PrintPageActionListener.class}), @EventConfig(listeners={AddPollActionListener.class}), @EventConfig(listeners={SetOpenTopicActionListener.class}), @EventConfig(listeners={SetCloseTopicActionListener.class}), @EventConfig(listeners={SetLockedTopicActionListener.class}), @EventConfig(listeners={SetUnLockTopicActionListener.class}), @EventConfig(listeners={SetMoveTopicActionListener.class}), @EventConfig(listeners={SetStickTopicActionListener.class}), @EventConfig(listeners={SetUnStickTopicActionListener.class}), @EventConfig(listeners={SplitTopicActionListener.class}), @EventConfig(listeners={SetApproveTopicActionListener.class}), @EventConfig(listeners={SetUnApproveTopicActionListener.class}), @EventConfig(listeners={SetDeleteTopicActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisTopic"), @EventConfig(listeners={MergePostActionListener.class}), @EventConfig(listeners={MovePostActionListener.class}), @EventConfig(listeners={SetApprovePostActionListener.class}), @EventConfig(listeners={SetHiddenPostActionListener.class}), @EventConfig(listeners={SetUnHiddenPostActionListener.class}), @EventConfig(listeners={DeletePostActionListener.class}), @EventConfig(listeners={QuickReplyActionListener.class}), @EventConfig(listeners={PreviewReplyActionListener.class}), @EventConfig(listeners={ViewPostedByUserActionListener.class}), @EventConfig(listeners={ViewPublicUserInfoActionListener.class}), @EventConfig(listeners={ViewThreadByUserActionListener.class}), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class}), @EventConfig(listeners={BanIPAllForumActionListener.class}), @EventConfig(listeners={BanIPThisForumActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class})})
public class UITopicDetail
extends UIForumKeepStickPageIterator {
    private ForumService forumService;
    private String categoryId;
    private String forumId;
    private String topicId = "";
    private String link = "";
    private Forum forum;
    private Topic topic = new Topic();
    private boolean isEditTopic = false;
    private String IdPostView = "false";
    private String IdLastPost = "false";
    private UserProfile userProfile = null;
    private String userName = " ";
    private boolean isModeratePost = false;
    private boolean isMod = false;
    private boolean enableIPLogging = true;
    private Map<String, UserProfile> mapUserProfile = new HashMap();
    private Map<String, ForumContact> mapContact = new HashMap();
    public static final String FIELD_MESSAGE_TEXTAREA = "Message";

    public UITopicDetail() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_T, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_B, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MESSAGE_TEXTAREA, FIELD_MESSAGE_TEXTAREA, null));
        this.addChild(UIPostRules.class, null, null);
        this.setSubmitAction("GoNumberPage");
        this.setActions(new String[]{"PreviewReply", "QuickReply"});
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public boolean getHasEnableIPLogging() {
        return this.enableIPLogging;
    }

    private boolean isIPBaned(String ip) {
        List ipBaneds = this.forum.getBanIP();
        return ipBaneds != null && ipBaneds.size() > 0 && ipBaneds.contains(ip);
    }

    private boolean isOnline(String userId) throws Exception {
        return this.forumService.isOnline(userId);
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setUpdateTopic(String categoryId, String forumId, String topicId) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        forumPortlet.updateAccessTopic(topicId);
        this.userProfile = forumPortlet.getUserProfile();
        this.userName = this.userProfile.getUserId();
        this.cleanCheckedList();
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId + "/" + topicId);
        this.topic = this.forumService.getTopic(ForumSessionUtils.getSystemProvider(), categoryId, forumId, topicId, this.userName);
    }

    public void setTopicFromCate(String categoryId, String forumId, Topic topic) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topic.getId();
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        this.cleanCheckedList();
        this.topic = this.forumService.getTopic(ForumSessionUtils.getSystemProvider(), categoryId, forumId, topic.getId(), this.userName);
        forumPortlet.updateAccessTopic(this.topicId);
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId + "/" + this.topicId);
        this.userProfile = forumPortlet.getUserProfile();
        this.userName = this.userProfile.getUserId();
    }

    public void hasPoll(boolean hasPoll) {
        this.topic.setIsPoll(hasPoll);
    }

    public void setUpdateContainer(String categoryId, String forumId, Topic topic, long numberPage) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topic.getId();
        this.pageSelect = numberPage;
        this.isEditTopic = false;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        this.cleanCheckedList();
        this.topic = this.forumService.getTopic(ForumSessionUtils.getSystemProvider(), categoryId, forumId, topic.getId(), this.userName);
        forumPortlet.getUserProfile().setLastTimeAccessTopic(topic.getId(), ForumUtils.getInstanceTempCalendar().getTimeInMillis());
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId + "/" + this.topicId);
        this.userProfile = forumPortlet.getUserProfile();
        this.userName = this.userProfile.getUserId();
    }

    public void setUpdateForum(Forum forum) throws Exception {
        this.forum = forum;
    }

    private boolean isCanPostReply() throws Exception {
        if (this.userProfile.getUserRole() == 3L) {
            return false;
        }
        if (this.forum.getIsClosed() || this.forum.getIsLock() || this.topic.getIsClosed() || this.topic.getIsLock()) {
            return false;
        }
        if (this.userProfile.getIsBanned()) {
            return false;
        }
        if (this.isMod) {
            return true;
        }
        if (this.isIPBaned(this.getIPRemoter())) {
            return false;
        }
        if (!this.topic.getIsActive() || !this.topic.getIsActiveByForum() || this.topic.getIsWaiting()) {
            return false;
        }
        ArrayList<String> listUser = new ArrayList<String>();
        String[] canPost = this.topic.getCanPost();
        if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
            listUser.addAll(Arrays.asList(canPost));
            canPost = this.forum.getPoster();
            if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
                listUser.addAll(Arrays.asList(canPost));
            }
        }
        if (listUser.size() > 0) {
            return ForumServiceUtils.hasPermission((String[])listUser.toArray(new String[0]), (String)this.userName);
        }
        return true;
    }

    private String getIPRemoter() throws Exception {
        if (this.enableIPLogging) {
            WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
            PortletRequestImp request = (PortletRequestImp)context.getRequest();
            return request.getRemoteAddr();
        }
        return "";
    }

    private Forum getForum() throws Exception {
        return this.forum;
    }

    private String getIdPostView() {
        if (this.IdPostView.equals("lastpost")) {
            this.IdPostView = "normal";
            return this.IdLastPost;
        }
        if (this.IdPostView.equals("top")) {
            this.IdPostView = "normal";
            return "top";
        }
        String temp = this.IdPostView;
        this.IdPostView = "normal";
        return temp;
    }

    public void setIdPostView(String IdPostView) {
        this.IdPostView = IdPostView;
    }

    public void setIsEditTopic(boolean isEditTopic) {
        this.isEditTopic = isEditTopic;
    }

    private Topic getTopic() throws Exception {
        SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
        try {
            if (this.isEditTopic || this.topic == null) {
                this.topic = this.forumService.getTopic(sProvider, this.categoryId, this.forumId, this.topicId, "user_gest_uoom");
                this.isEditTopic = false;
            }
            return this.topic;
        }
        catch (Exception e) {
            sProvider.close();
            return null;
        }
    }

    private boolean userCanView() throws Exception {
        if (this.isMod) {
            return true;
        }
        if (this.forum.getIsClosed() || this.topic.getIsClosed() || !this.topic.getIsActive() || !this.topic.getIsActiveByForum() || this.topic.getIsWaiting()) {
            return false;
        }
        if (this.isCanPostReply()) {
            return true;
        }
        ArrayList<String> listUser = new ArrayList<String>();
        String[] canPost = this.topic.getCanView();
        if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
            listUser.addAll(Arrays.asList(canPost));
            canPost = this.forum.getViewer();
            if (canPost != null && canPost.length > 0 && !canPost[0].equals(" ")) {
                listUser.addAll(Arrays.asList(canPost));
            }
        }
        if (listUser.size() > 0) {
            return ForumServiceUtils.hasPermission((String[])listUser.toArray(new String[0]), (String)this.userName);
        }
        return true;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getFileSource(ForumAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return ForumSessionUtils.getFileSource((InputStream)input, (String)fileName, (DownloadService)dservice);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private ForumContact getPersonalContact(String userId) throws Exception {
        ForumContact contact;
        if (this.mapContact.containsKey(userId)) {
            contact = (ForumContact)this.mapContact.get(userId);
        } else {
            contact = ForumSessionUtils.getPersonalContact((String)userId);
            this.mapContact.put(userId, contact);
        }
        if (contact == null) {
            contact = new ForumContact();
        }
        return contact;
    }

    private String getAvatarUrl(ForumContact contact, String userId, SessionProvider sessionProvider) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        return ForumSessionUtils.getUserAvatarURL((String)userId, (ForumService)this.forumService, (DownloadService)dservice);
    }

    private void initPage() throws Exception {
        this.isMod = false;
        if (this.userProfile.getUserRole() == 0L) {
            this.isMod = true;
        }
        if (!this.isMod) {
            this.isMod = ForumServiceUtils.hasPermission((String[])this.forum.getModerators(), (String)this.userName);
        }
        SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
        try {
            String isApprove = "";
            String isHidden = "";
            if (!this.isMod) {
                isHidden = "false";
            }
            if (this.forum.getIsModeratePost() || this.topic.getIsModeratePost()) {
                this.isModeratePost = true;
                if (!this.isMod && !this.topic.getOwner().equals(this.userName)) {
                    isApprove = "true";
                }
            }
            this.pageList = this.forumService.getPosts(sProvider, this.categoryId, this.forumId, this.topicId, isApprove, isHidden, "", this.userName);
            long maxPost = this.userProfile.getMaxPostInPage();
            if (maxPost <= 0L) {
                maxPost = 10L;
            }
            this.pageList.setPageSize(maxPost);
            this.maxPage = this.pageList.getAvailablePage();
            if (this.IdPostView.equals("lastpost")) {
                this.pageSelect = this.maxPage;
            }
        }
        catch (Exception e) {
            sProvider.close();
        }
    }

    private boolean getIsModeratePost() {
        return this.isModeratePost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Post> getPostPageList() throws Exception {
        List<Object> posts = new ArrayList<Post>();
        if (this.pageList == null) {
            return posts;
        }
        posts = this.pageList.getPage(this.pageSelect);
        if (posts == null) {
            posts = new ArrayList();
        }
        ArrayList<String> userNames = new ArrayList<String>();
        this.mapUserProfile.clear();
        for (Post post : posts) {
            if (!userNames.contains(post.getOwner())) {
                userNames.add(post.getOwner());
            }
            if (this.getUIFormCheckBoxInput(post.getId()) != null) {
                this.getUIFormCheckBoxInput(post.getId()).setChecked(false);
            } else {
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(post.getId(), post.getId(), (Object)false));
            }
            this.IdLastPost = post.getId();
        }
        if (userNames.size() > 0) {
            SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
            try {
                List list = this.forumService.getQuickProfiles(sProvider, userNames);
                for (UserProfile profile : list) {
                    this.mapUserProfile.put(profile.getUserId(), profile);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                sProvider.close();
            }
        }
        return posts;
    }

    public List<Post> getAllPost() throws Exception {
        return this.pageList.getPage(0L);
    }

    private Post getPost(String postId) throws Exception {
        for (Post post : this.getAllPost()) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return null;
    }

    public void setPostRules(boolean isNull) throws Exception {
        UIPostRules postRules = (UIPostRules)this.getChild(UIPostRules.class);
        postRules.setUserProfile(this.userProfile);
        if (!isNull) {
            if (this.forum.getIsClosed() || this.forum.getIsLock()) {
                postRules.setCanCreateNewThread(false);
                postRules.setCanAddPost(false);
            } else {
                String[] strings = this.forum.getCreateTopicRole();
                boolean canCreateThread = this.isMod;
                if (!canCreateThread) {
                    canCreateThread = this.isIPBaned(this.getIPRemoter()) ? false : (strings == null || strings.length == 0 || strings.length == 1 && strings[0].equals(" ") ? true : ForumServiceUtils.hasPermission((String[])strings, (String)this.userName));
                }
                postRules.setCanCreateNewThread(canCreateThread);
                if (this.topic != null && !this.topic.getIsClosed() && !this.topic.getIsLock()) {
                    postRules.setCanAddPost(this.isCanPostReply());
                } else {
                    postRules.setCanAddPost(false);
                }
            }
        } else {
            postRules.setCanCreateNewThread(!isNull);
            postRules.setCanAddPost(!isNull);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserProfile getUserInfo(String userName) throws Exception {
        if (!this.mapUserProfile.containsKey(userName)) {
            SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
            try {
                this.mapUserProfile.put(userName, this.forumService.getQuickProfile(sProvider, userName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sProvider.close();
            }
        }
        return (UserProfile)this.mapUserProfile.get(userName);
    }

    private String[] getCensoredKeyword(SessionProvider sProvider) throws Exception {
        ForumAdministration forumAdministration = this.forumService.getForumAdministration(sProvider);
        String stringKey = forumAdministration.getCensoredKeyword();
        if (stringKey != null && stringKey.length() > 0) {
            if ((stringKey = stringKey.toLowerCase().replaceAll(", ", ",").replaceAll(" ,", ",")).contains(",")) {
                stringKey.replaceAll(";", ",");
                return stringKey.trim().split(",");
            }
            return stringKey.trim().split(";");
        }
        return new String[0];
    }

    static /* synthetic */ String access$000(UITopicDetail x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$100(UITopicDetail x0) {
        return x0.forumId;
    }

    static /* synthetic */ String access$200(UITopicDetail x0) {
        return x0.topicId;
    }

    static /* synthetic */ Topic access$300(UITopicDetail x0) {
        return x0.topic;
    }

    static /* synthetic */ boolean access$400(UITopicDetail x0) {
        return x0.isMod;
    }

    static /* synthetic */ boolean access$502(UITopicDetail x0, boolean x1) {
        x0.isEditTopic = x1;
        return x0.isEditTopic;
    }

    static /* synthetic */ ForumService access$600(UITopicDetail x0) {
        return x0.forumService;
    }

    static /* synthetic */ Post access$700(UITopicDetail x0, String x1) throws Exception {
        return x0.getPost(x1);
    }

    static /* synthetic */ String access$802(UITopicDetail x0, String x1) {
        x0.IdPostView = x1;
        return x0.IdPostView;
    }

    static /* synthetic */ Forum access$900(UITopicDetail x0) {
        return x0.forum;
    }

    static /* synthetic */ UserProfile access$1000(UITopicDetail x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Map access$1100(UITopicDetail x0) {
        return x0.mapUserProfile;
    }

    static /* synthetic */ Map access$1200(UITopicDetail x0) {
        return x0.mapContact;
    }

    static /* synthetic */ String[] access$1300(UITopicDetail x0, SessionProvider x1) throws Exception {
        return x0.getCensoredKeyword(x1);
    }

    static /* synthetic */ String access$1400(UITopicDetail x0) throws Exception {
        return x0.getIPRemoter();
    }

    static /* synthetic */ UserProfile access$1500(UITopicDetail x0, String x1) throws Exception {
        return x0.getUserInfo(x1);
    }

    static /* synthetic */ Topic access$1600(UITopicDetail x0) throws Exception {
        return x0.getTopic();
    }
}

