/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UIFormSelectBoxForum;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UIForumLinks.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIForumLinks
extends UIForm {
    private ForumService forumService;
    public static final String FIELD_FORUMLINK_SELECTBOX = "forumLink";
    public static final String FIELD_FORUMHOMEPAGE_LABEL = "forumHomePage";
    private String path = Utils.FORUM_SERVICE;
    private List<ForumLinkData> forumLinks = null;
    private UserProfile userProfile = new UserProfile();

    public UIForumLinks() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    }

    private String getStrQuery(List<String> list, String property) {
        StringBuffer strQueryCate = new StringBuffer();
        int t = 0;
        for (String string : list) {
            if (t == 0) {
                strQueryCate.append("@exo:").append(property).append("='").append(string).append("'");
            } else {
                strQueryCate.append(" or @exo:").append(property).append("='").append(string).append("'");
            }
            ++t;
        }
        return strQueryCate.toString();
    }

    public void setUpdateForumLinks() throws Exception {
        UIFormSelectBoxForum forumLink;
        String strQueryCate = "";
        String strQueryForum = "";
        List listUser = ForumSessionUtils.getAllGroupAndMembershipOfUser((String)this.userProfile.getUserId());
        if (this.userProfile.getUserRole() > 0L) {
            strQueryCate = this.getStrQuery(listUser, "userPrivate");
            if (!ForumUtils.isEmpty((String)strQueryCate)) {
                strQueryCate = "[@exo:userPrivate=' ' or " + strQueryCate + "]";
            }
            if (!ForumUtils.isEmpty((String)(strQueryForum = this.getStrQuery(listUser, "moderators")))) {
                strQueryForum = "[@exo:isClosed='false' or " + strQueryForum + "]";
            }
        }
        this.forumLinks = this.forumService.getAllLink(ForumSessionUtils.getSystemProvider(), strQueryCate, strQueryForum);
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(this.getLabel(FIELD_FORUMHOMEPAGE_LABEL) + "/" + FIELD_FORUMHOMEPAGE_LABEL, (Object)Utils.FORUM_SERVICE));
        String space = "&nbsp; &nbsp; ";
        String type = "/categoryLink";
        for (ForumLinkData linkData : this.forumLinks) {
            if (linkData.getType().equals(Utils.FORUM)) {
                type = "/forumLink";
                space = "&nbsp; &nbsp; &nbsp; &nbsp; ";
            }
            if (linkData.getType().equals(Utils.CATEGORY)) {
                type = "/categoryLink";
                space = "&nbsp; &nbsp; ";
            }
            if (linkData.getType().equals(Utils.TOPIC)) continue;
            list.add(new SelectItemOption(space + linkData.getName() + type, (Object)linkData.getPath()));
        }
        if (this.getChild(UIFormSelectBoxForum.class) != null) {
            forumLink = ((UIFormSelectBoxForum)this.getChild(UIFormSelectBoxForum.class)).setOptions(list);
            forumLink.setValue(this.path.trim());
        } else {
            forumLink = new UIFormSelectBoxForum(FIELD_FORUMLINK_SELECTBOX, FIELD_FORUMLINK_SELECTBOX, list);
            forumLink.setValue(this.path.trim());
            this.addUIFormInput((UIFormInput)forumLink);
        }
    }

    public UIFormSelectBoxForum getUIFormSelectBoxForum(String name) {
        return (UIFormSelectBoxForum)this.findComponentById(name);
    }

    private void setForumLinks() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        UICategories categories = (UICategories)forumPortlet.findFirstComponentOfType(UICategories.class);
        this.userProfile = forumPortlet.getUserProfile();
    }

    public List<ForumLinkData> getForumLinks() throws Exception {
        return this.forumLinks;
    }

    public void setValueOption(String path) throws Exception {
        this.path = path;
    }

    static /* synthetic */ String access$000(UIForumLinks x0) {
        return x0.path;
    }

    static /* synthetic */ String access$002(UIForumLinks x0, String x1) {
        x0.path = x1;
        return x0.path;
    }

    static /* synthetic */ ForumService access$100(UIForumLinks x0) {
        return x0.forumService;
    }
}

