/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.popup.UIImportForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIImportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIImportForm
extends UIForm
implements UIPopupComponent {
    private final String FILE_UPLOAD = "FileUpload";
    private String categoryPath = null;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIImportForm() {
        int sizeLimit = ForumUtils.getLimitUploadSize();
        if (sizeLimit >= 0) {
            this.addChild((UIComponent)new UIFormUploadInput("FileUpload", "FileUpload", sizeLimit));
        } else {
            this.addChild((UIComponent)new UIFormUploadInput("FileUpload", "FileUpload"));
        }
        this.categoryPath = null;
    }

    public void setPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    private boolean extractFromZipFile(ZipInputStream zipStream, String nodePath, ForumService service) throws Exception {
        int numberOfFile = 0;
        int numberExportFalse = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[5120];
        ZipEntry entry = zipStream.getNextEntry();
        ByteArrayInputStream inputStream = null;
        while (entry != null) {
            ++numberOfFile;
            out = new ByteArrayOutputStream();
            int available = -1;
            while ((available = zipStream.read(data, 0, 1024)) > -1) {
                out.write(data, 0, available);
            }
            zipStream.closeEntry();
            out.close();
            inputStream = new ByteArrayInputStream(out.toByteArray());
            service.importXML(nodePath, inputStream, 0);
            ++numberExportFalse;
            entry = zipStream.getNextEntry();
        }
        zipStream.close();
        return numberOfFile != numberExportFalse;
    }

    static /* synthetic */ String access$000(UIImportForm x0) {
        return x0.categoryPath;
    }

    static /* synthetic */ boolean access$100(UIImportForm x0, ZipInputStream x1, String x2, ForumService x3) throws Exception {
        return x0.extractFromZipFile(x1, x2, x3);
    }
}

