/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISplitTopicForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISplitTopicForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UISplitTopicForm
extends UIForumKeepStickPageIterator
implements UIPopupComponent {
    private List<Post> posts = new ArrayList();
    private Topic topic = new Topic();
    private String link;
    private UserProfile userProfile = null;
    private List<String> listPostId = new ArrayList();
    private boolean isRender = true;
    public static final String FIELD_SPLITTHREAD_INPUT = "SplitThread";

    public UISplitTopicForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SPLITTHREAD_INPUT, FIELD_SPLITTHREAD_INPUT, null));
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    private Post getPostById(String postId) throws Exception {
        for (Post post : this.posts) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return new Post();
    }

    public boolean getIdRender() {
        return this.isRender;
    }

    private List<String> getListPost() throws Exception {
        String postId = this.topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
        this.posts.remove(this.getPostById(postId));
        this.listPostId.clear();
        for (Post post : this.posts) {
            this.listPostId.add(post.getId());
            if (this.getUIFormCheckBoxInput(post.getId()) != null) {
                this.getUIFormCheckBoxInput(post.getId()).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(post.getId(), post.getId(), (Object)false));
        }
        this.pageList = new ForumPageList(6, this.listPostId.size());
        this.pageList.setPageSize(6);
        this.maxPage = this.pageList.getAvailablePage();
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.addAll(this.pageList.getPageList((long)this.pageSelect, this.listPostId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.maxPage <= 1) {
            this.isRender = false;
        }
        return list;
    }

    public void setListPost(List<Post> posts) {
        this.posts = posts;
    }

    private Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    private UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    static /* synthetic */ Post access$000(UISplitTopicForm x0, String x1) throws Exception {
        return x0.getPostById(x1);
    }

    static /* synthetic */ UserProfile access$100(UISplitTopicForm x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Topic access$200(UISplitTopicForm x0) {
        return x0.topic;
    }
}

