/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.webui.UIFormSelectBoxForum;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIForumUserSettingForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIForumUserSettingForm.gtmpl", events={@EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={SetDefaultAvatarActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={OpenTabActionListener.class}), @EventConfig(listeners={OpentContentActionListener.class}), @EventConfig(listeners={DeleteEmailWatchActionListener.class}), @EventConfig(listeners={ResetRSSActionListener.class}), @EventConfig(listeners={UpdateEmailActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIForumUserSettingForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_USERPROFILE_FORM = "ForumUserProfile";
    public static final String FIELD_USEROPTION_FORM = "ForumUserOption";
    public static final String FIELD_USERWATCHMANGER_FORM = "ForumUserWatches";
    public static final String FIELD_TIMEZONE_SELECTBOX = "TimeZone";
    public static final String FIELD_SHORTDATEFORMAT_SELECTBOX = "ShortDateformat";
    public static final String FIELD_LONGDATEFORMAT_SELECTBOX = "LongDateformat";
    public static final String FIELD_TIMEFORMAT_SELECTBOX = "Timeformat";
    public static final String FIELD_MAXTOPICS_SELECTBOX = "MaximumThreads";
    public static final String FIELD_MAXPOSTS_SELECTBOX = "MaximumPosts";
    public static final String FIELD_FORUMJUMP_CHECKBOX = "ShowForumJump";
    public static final String FIELD_AUTOWATCHMYTOPICS_CHECKBOX = "AutoWatchMyTopics";
    public static final String FIELD_AUTOWATCHTOPICIPOST_CHECKBOX = "AutoWatchTopicIPost";
    public static final String FIELD_TIMEZONE = "timeZone";
    public static final String FIELD_USERID_INPUT = "ForumUserName";
    public static final String FIELD_SCREENNAME_INPUT = "ScreenName";
    public static final String FIELD_USERTITLE_INPUT = "ForumUserTitle";
    public static final String FIELD_SIGNATURE_TEXTAREA = "Signature";
    public static final String FIELD_ISDISPLAYSIGNATURE_CHECKBOX = "IsDisplaySignature";
    public static final String FIELD_ISDISPLAYAVATAR_CHECKBOX = "IsDisplayAvatar";
    public static final String RSS_LINK = "RSSLink";
    public static final String EMAIL_ADD = "EmailAddress";
    public final String WATCHES_ITERATOR = "WatchChesPageIterator";
    private String tabId = "ForumUserProfile";
    private ForumService forumService;
    private UserProfile userProfile = null;
    private String[] permissionUser = null;
    private List<Watch> listWatches = new ArrayList();
    private JCRPageList pageList;
    UIForumPageIterator pageIterator;
    private final String defaultAvatar = "/forum/skin/DefaultSkin/webui/background/Avatar1.gif";

    public UIForumUserSettingForm() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.permissionUser = new String[]{res.getString("UIForumPortlet.label.PermissionAdmin").toLowerCase(), res.getString("UIForumPortlet.label.PermissionModerator").toLowerCase(), res.getString("UIForumPortlet.label.PermissionGuest").toLowerCase(), res.getString("UIForumPortlet.label.PermissionUser").toLowerCase()};
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private void initForumOption() throws Exception {
        String[] format;
        try {
            this.userProfile = this.forumService.getUserSettingProfile(ForumSessionUtils.getCurrentUser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] timeZone1 = this.getLabel(FIELD_TIMEZONE).split("/");
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        for (String string : timeZone1) {
            list.add(new SelectItemOption(string + "/timeZone", (Object)ForumUtils.getTimeZoneNumberInString((String)string)));
        }
        UIFormSelectBoxForum timeZone = new UIFormSelectBoxForum(FIELD_TIMEZONE_SELECTBOX, FIELD_TIMEZONE_SELECTBOX, list);
        double timeZoneOld = -this.userProfile.getTimeZone();
        Date date = this.getNewDate(timeZoneOld);
        String mark = "-";
        if (timeZoneOld < 0.0) {
            timeZoneOld = -timeZoneOld;
        } else if (timeZoneOld > 0.0) {
            mark = "+";
        } else {
            timeZoneOld = 0.0;
            mark = "";
        }
        timeZone.setValue(mark + timeZoneOld + "0");
        list = new ArrayList();
        for (String frm : format = new String[]{"M-d-yyyy", "M-d-yy", "MM-dd-yy", "MM-dd-yyyy", "yyyy-MM-dd", "yy-MM-dd", "dd-MM-yyyy", "dd-MM-yy", "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yyyy/MM/dd", "yy/MM/dd", "dd/MM/yyyy", "dd/MM/yy"}) {
            list.add(new SelectItemOption(frm.toLowerCase() + " (" + ForumUtils.getFormatDate((String)frm, (Date)date) + ")", (Object)frm));
        }
        UIFormSelectBox shortdateFormat = new UIFormSelectBox(FIELD_SHORTDATEFORMAT_SELECTBOX, FIELD_SHORTDATEFORMAT_SELECTBOX, list);
        shortdateFormat.setValue(this.userProfile.getShortDateFormat());
        list = new ArrayList();
        for (String idFrm : format = new String[]{"DDD, MMMM dd, yyyy", "DDDD, MMMM dd, yyyy", "DDDD, dd MMMM, yyyy", "DDD, MMM dd, yyyy", "DDDD, MMM dd, yyyy", "DDDD, dd MMM, yyyy", "MMMM dd, yyyy", "dd MMMM, yyyy", "MMM dd, yyyy", "dd MMM, yyyy"}) {
            list.add(new SelectItemOption(idFrm.toLowerCase() + " (" + ForumUtils.getFormatDate((String)idFrm, (Date)date) + ")", (Object)idFrm.replaceFirst(" ", "=")));
        }
        UIFormSelectBox longDateFormat = new UIFormSelectBox(FIELD_LONGDATEFORMAT_SELECTBOX, FIELD_LONGDATEFORMAT_SELECTBOX, list);
        longDateFormat.setValue(this.userProfile.getLongDateFormat().replaceFirst(" ", "="));
        list = new ArrayList();
        list.add(new SelectItemOption("12-hour", (Object)"hh:mm=a"));
        list.add(new SelectItemOption("24-hour", (Object)"HH:mm"));
        UIFormSelectBox timeFormat = new UIFormSelectBox(FIELD_TIMEFORMAT_SELECTBOX, FIELD_TIMEFORMAT_SELECTBOX, list);
        timeFormat.setValue(this.userProfile.getTimeFormat().replace(' ', '='));
        list = new ArrayList();
        for (int i = 5; i <= 45; i += 5) {
            list.add(new SelectItemOption(String.valueOf(i), (Object)("id" + i)));
        }
        UIFormSelectBox maximumThreads = new UIFormSelectBox(FIELD_MAXTOPICS_SELECTBOX, FIELD_MAXTOPICS_SELECTBOX, list);
        maximumThreads.setValue("id" + this.userProfile.getMaxTopicInPage());
        list = new ArrayList();
        for (int i = 5; i <= 35; i += 5) {
            list.add(new SelectItemOption(String.valueOf(i), (Object)("id" + i)));
        }
        UIFormSelectBox maximumPosts = new UIFormSelectBox(FIELD_MAXPOSTS_SELECTBOX, FIELD_MAXPOSTS_SELECTBOX, list);
        maximumPosts.setValue("id" + this.userProfile.getMaxPostInPage());
        boolean isJump = this.userProfile.getIsShowForumJump();
        UIFormCheckBoxInput isShowForumJump = new UIFormCheckBoxInput(FIELD_FORUMJUMP_CHECKBOX, FIELD_FORUMJUMP_CHECKBOX, (Object)isJump);
        isShowForumJump.setChecked(isJump);
        UIFormStringInput userId = new UIFormStringInput(FIELD_USERID_INPUT, FIELD_USERID_INPUT, null);
        userId.setValue((Object)this.userProfile.getUserId());
        userId.setEditable(false);
        userId.setEnable(false);
        UIFormStringInput screenName = new UIFormStringInput(FIELD_SCREENNAME_INPUT, FIELD_SCREENNAME_INPUT, null);
        String screenN = this.userProfile.getScreenName();
        if (ForumUtils.isEmpty((String)screenN)) {
            screenN = this.userProfile.getUserId();
        }
        screenName.setValue((Object)screenN);
        UIFormStringInput userTitle = new UIFormStringInput(FIELD_USERTITLE_INPUT, FIELD_USERTITLE_INPUT, null);
        userTitle.setValue((Object)this.userProfile.getUserTitle());
        if (this.userProfile.getUserRole() > 0L) {
            userTitle.setEditable(false);
            userTitle.setEnable(false);
        }
        UIFormTextAreaInput signature = new UIFormTextAreaInput(FIELD_SIGNATURE_TEXTAREA, FIELD_SIGNATURE_TEXTAREA, null);
        String strSignature = this.userProfile.getSignature();
        if (ForumUtils.isEmpty((String)strSignature)) {
            strSignature = "";
        }
        signature.setValue((Object)strSignature);
        UIFormCheckBoxInput isDisplaySignature = new UIFormCheckBoxInput(FIELD_ISDISPLAYSIGNATURE_CHECKBOX, FIELD_ISDISPLAYSIGNATURE_CHECKBOX, (Object)false);
        isDisplaySignature.setChecked(this.userProfile.getIsDisplaySignature());
        UIFormCheckBoxInput isAutoWatchMyTopics = new UIFormCheckBoxInput(FIELD_AUTOWATCHMYTOPICS_CHECKBOX, FIELD_AUTOWATCHMYTOPICS_CHECKBOX, (Object)false);
        isAutoWatchMyTopics.setChecked(this.userProfile.getIsAutoWatchMyTopics());
        UIFormCheckBoxInput isAutoWatchTopicIPost = new UIFormCheckBoxInput(FIELD_AUTOWATCHTOPICIPOST_CHECKBOX, FIELD_AUTOWATCHTOPICIPOST_CHECKBOX, (Object)false);
        isAutoWatchTopicIPost.setChecked(this.userProfile.getIsAutoWatchTopicIPost());
        UIFormCheckBoxInput isDisplayAvatar = new UIFormCheckBoxInput(FIELD_ISDISPLAYAVATAR_CHECKBOX, FIELD_ISDISPLAYAVATAR_CHECKBOX, (Object)false);
        isDisplayAvatar.setChecked(this.userProfile.getIsDisplayAvatar());
        UIFormInputWithActions inputSetProfile = new UIFormInputWithActions(FIELD_USERPROFILE_FORM);
        inputSetProfile.addUIFormInput((UIFormInput)userId);
        inputSetProfile.addUIFormInput((UIFormInput)screenName);
        inputSetProfile.addUIFormInput((UIFormInput)userTitle);
        inputSetProfile.addUIFormInput((UIFormInput)signature);
        inputSetProfile.addUIFormInput((UIFormInput)isDisplaySignature);
        inputSetProfile.addUIFormInput((UIFormInput)isDisplayAvatar);
        inputSetProfile.addUIFormInput((UIFormInput)isAutoWatchMyTopics);
        inputSetProfile.addUIFormInput((UIFormInput)isAutoWatchTopicIPost);
        UIFormInputWithActions inputSetOption = new UIFormInputWithActions(FIELD_USEROPTION_FORM);
        inputSetOption.addUIFormInput((UIFormInput)timeZone);
        inputSetOption.addUIFormInput((UIFormInput)shortdateFormat);
        inputSetOption.addUIFormInput((UIFormInput)longDateFormat);
        inputSetOption.addUIFormInput((UIFormInput)timeFormat);
        inputSetOption.addUIFormInput((UIFormInput)maximumThreads);
        inputSetOption.addUIFormInput((UIFormInput)maximumPosts);
        inputSetOption.addUIFormInput((UIFormInput)isShowForumJump);
        UIFormInputWithActions inputUserWatchManger = new UIFormInputWithActions(FIELD_USERWATCHMANGER_FORM);
        this.listWatches = this.forumService.getWatchByUser(this.userProfile.getUserId());
        UIFormCheckBoxInput formCheckBoxRSS = null;
        UIFormCheckBoxInput formCheckBoxEMAIL = null;
        String listObjectId = "";
        ArrayList<String> listId = new ArrayList<String>();
        ForumSubscription forumSubscription = this.forumService.getForumSubscription(this.userProfile.getUserId());
        listId.addAll(Arrays.asList(forumSubscription.getCategoryIds()));
        listId.addAll(Arrays.asList(forumSubscription.getForumIds()));
        listId.addAll(Arrays.asList(forumSubscription.getTopicIds()));
        for (Watch watch : this.listWatches) {
            if (listObjectId.trim().length() > 0) {
                listObjectId = listObjectId + "/";
            }
            String watchId = watch.getId();
            listObjectId = listObjectId + watchId;
            formCheckBoxRSS = new UIFormCheckBoxInput("RSS" + watch.getId(), "RSS" + watch.getId(), (Object)false);
            boolean isAddWatchRSS = watch.isAddWatchByRS();
            formCheckBoxRSS.setEnable(isAddWatchRSS);
            if (isAddWatchRSS) {
                if (listId.contains(watchId)) {
                    formCheckBoxRSS.setChecked(true);
                } else {
                    formCheckBoxRSS.setChecked(false);
                }
            }
            inputUserWatchManger.addChild((UIComponent)formCheckBoxRSS);
            formCheckBoxEMAIL = new UIFormCheckBoxInput("EMAIL" + watch.getId(), "EMAIL" + watch.getId(), (Object)watch.isAddWatchByEmail());
            formCheckBoxEMAIL.setChecked(watch.isAddWatchByEmail());
            formCheckBoxEMAIL.setEnable(watch.isAddWatchByEmail());
            inputUserWatchManger.addChild((UIComponent)formCheckBoxEMAIL);
        }
        UIFormStringInput formStringInput = null;
        formStringInput = new UIFormStringInput(RSS_LINK, null);
        String rssLink = "";
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String url = portalContext.getRequest().getRequestURL().toString();
        url = url.substring(0, url.indexOf("/", 8));
        rssLink = url + RSS.getUserRSSLink((String)this.userProfile.getUserId());
        formStringInput.setValue((Object)rssLink);
        formStringInput.setEditable(false);
        inputUserWatchManger.addChild((UIComponent)formStringInput);
        formStringInput = new UIFormStringInput(EMAIL_ADD, ForumSessionUtils.getEmailUser((String)this.userProfile.getUserId()));
        formStringInput.setValue((Object)ForumSessionUtils.getEmailUser((String)this.userProfile.getUserId()));
        inputUserWatchManger.addChild((UIComponent)formStringInput);
        this.addUIFormInput((UIFormInputSet)inputSetProfile);
        this.addUIFormInput((UIFormInputSet)inputSetOption);
        this.addUIFormInput((UIFormInputSet)inputUserWatchManger);
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "WatchChesPageIterator");
        this.pageList = new ForumPageList(7, this.listWatches.size());
        this.pageIterator.updatePageList(this.pageList);
        try {
            if ((Long)this.pageIterator.getInfoPage().get(3) <= 1L) {
                this.pageIterator.setRendered(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveForumSubscription() throws Exception {
        ArrayList<String> cateIds = new ArrayList<String>();
        ArrayList<String> forumIds = new ArrayList<String>();
        ArrayList<String> topicIds = new ArrayList<String>();
        UIFormCheckBoxInput formCheckBoxRSS = null;
        UIFormInputWithActions inputUserWatchManger = (UIFormInputWithActions)this.getChildById(FIELD_USERWATCHMANGER_FORM);
        for (Watch watch : this.listWatches) {
            formCheckBoxRSS = (UIFormCheckBoxInput)inputUserWatchManger.getChildById("RSS" + watch.getId());
            String watchId = watch.getId();
            if (!formCheckBoxRSS.isChecked()) continue;
            if (watchId.indexOf(Utils.CATEGORY) == 0) {
                cateIds.add(watchId);
                continue;
            }
            if (watchId.indexOf(Utils.FORUM) == 0) {
                forumIds.add(watchId);
                continue;
            }
            if (watchId.indexOf(Utils.TOPIC) != 0) continue;
            topicIds.add(watchId);
        }
        ForumSubscription forumSubscription = new ForumSubscription();
        forumSubscription.setCategoryIds(cateIds.toArray(new String[0]));
        forumSubscription.setForumIds(forumIds.toArray(new String[0]));
        forumSubscription.setTopicIds(topicIds.toArray(new String[0]));
        this.forumService.saveForumSubscription(forumSubscription, this.userProfile.getUserId());
    }

    public List<Watch> getListWatch() throws Exception {
        long pageSelect = this.pageIterator.getPageSelected();
        ArrayList<Watch> list = new ArrayList<Watch>();
        try {
            list.addAll(this.pageList.getPageWatch(pageSelect, this.listWatches));
            if (list.isEmpty()) {
                while (list.isEmpty() && pageSelect > 1L) {
                    list.addAll(this.pageList.getPageWatch(--pageSelect, this.listWatches));
                    this.pageIterator.setSelectPage(pageSelect);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    private Date getNewDate(double timeZoneOld) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset + (long)(timeZoneOld * 3600000.0));
        return calendar.getTime();
    }

    private String getAvatarUrl() {
        String url = "/forum/skin/DefaultSkin/webui/background/Avatar1.gif";
        try {
            DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
            url = ForumSessionUtils.getUserAvatarURL((String)ForumSessionUtils.getCurrentUser(), (ForumService)this.forumService, (DownloadService)dservice);
        }
        catch (Exception e) {
            url = "/forum/skin/DefaultSkin/webui/background/Avatar1.gif";
        }
        if (url == null || url.trim().length() < 1) {
            url = "/forum/skin/DefaultSkin/webui/background/Avatar1.gif";
        }
        return url;
    }

    public UIFormSelectBoxForum getUIFormSelectBoxForum(String name) {
        return (UIFormSelectBoxForum)this.findComponentById(name);
    }

    public void activate() throws Exception {
        this.initForumOption();
    }

    public void deActivate() throws Exception {
    }

    private boolean canView(Category category, Forum forum, Topic topic, Post post, UserProfile userProfile) throws Exception {
        if (userProfile.getUserRole() == 0L) {
            return true;
        }
        boolean canView = true;
        boolean isModerator = false;
        if (category == null) {
            return false;
        }
        String[] listUsers = category.getUserPrivate();
        if (listUsers.length > 0 && listUsers[0].trim().length() > 0 && !ForumServiceUtils.hasPermission((String[])listUsers, (String)userProfile.getUserId())) {
            return false;
        }
        canView = true;
        if (forum != null) {
            listUsers = forum.getModerators();
            if (userProfile.getUserRole() == 1L && listUsers.length > 0 && listUsers[0].trim().length() > 0 && ForumServiceUtils.hasPermission((String[])listUsers, (String)userProfile.getUserId())) {
                isModerator = true;
                canView = true;
            } else {
                if (forum.getIsClosed()) {
                    return false;
                }
                canView = true;
            }
            if (topic != null) {
                canView = isModerator ? true : !topic.getIsClosed() && topic.getIsActive() && topic.getIsActiveByForum() && topic.getIsApproved() && !topic.getIsWaiting() && (topic.getCanView().length == 1 && topic.getCanView()[0].trim().length() < 1 || ForumServiceUtils.hasPermission((String[])topic.getCanView(), (String)userProfile.getUserId()) || ForumServiceUtils.hasPermission((String[])forum.getViewer(), (String)userProfile.getUserId()) || ForumServiceUtils.hasPermission((String[])forum.getPoster(), (String)userProfile.getUserId()));
            }
        }
        return canView;
    }

    static /* synthetic */ UserProfile access$000(UIForumUserSettingForm x0) {
        return x0.userProfile;
    }

    static /* synthetic */ String[] access$100(UIForumUserSettingForm x0) {
        return x0.permissionUser;
    }

    static /* synthetic */ ForumService access$200(UIForumUserSettingForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ void access$300(UIForumUserSettingForm x0) throws Exception {
        x0.saveForumSubscription();
    }

    static /* synthetic */ String access$402(UIForumUserSettingForm x0, String x1) {
        x0.tabId = x1;
        return x0.tabId;
    }

    static /* synthetic */ List access$500(UIForumUserSettingForm x0) {
        return x0.listWatches;
    }

    static /* synthetic */ JCRPageList access$602(UIForumUserSettingForm x0, JCRPageList x1) {
        x0.pageList = x1;
        return x0.pageList;
    }

    static /* synthetic */ JCRPageList access$600(UIForumUserSettingForm x0) {
        return x0.pageList;
    }

    static /* synthetic */ boolean access$700(UIForumUserSettingForm x0, Category x1, Forum x2, Topic x3, Post x4, UserProfile x5) throws Exception {
        return x0.canView(x1, x2, x3, x4, x5);
    }
}

