/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumInfos;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicContainer;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicContainer.gtmpl", events={@EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class}), @EventConfig(listeners={AddTopicActionListener.class}), @EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={OpenTopicsTagActionListener.class}), @EventConfig(listeners={EditForumActionListener.class}), @EventConfig(listeners={SetLockedForumActionListener.class}), @EventConfig(listeners={SetUnLockForumActionListener.class}), @EventConfig(listeners={SetOpenForumActionListener.class}), @EventConfig(listeners={SetCloseForumActionListener.class}), @EventConfig(listeners={MoveForumActionListener.class}), @EventConfig(listeners={RemoveForumActionListener.class}, confirm="UITopicContainer.confirm.RemoveForum"), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={EditTopicActionListener.class}), @EventConfig(listeners={SetOpenTopicActionListener.class}), @EventConfig(listeners={SetCloseTopicActionListener.class}), @EventConfig(listeners={SetLockedTopicActionListener.class}), @EventConfig(listeners={SetUnLockTopicActionListener.class}), @EventConfig(listeners={SetStickTopicActionListener.class}), @EventConfig(listeners={SetUnStickTopicActionListener.class}), @EventConfig(listeners={SetMoveTopicActionListener.class}), @EventConfig(listeners={MergeTopicActionListener.class}), @EventConfig(listeners={SetDeleteTopicActionListener.class}), @EventConfig(listeners={SetUnWaitingActionListener.class}), @EventConfig(listeners={ApproveTopicsActionListener.class}), @EventConfig(listeners={ActivateTopicsActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={ExportForumActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class}), @EventConfig(listeners={BanIpForumToolsActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UITopicContainer
extends UIForumKeepStickPageIterator {
    private ForumService forumService;
    private String forumId = "";
    private String categoryId = "";
    private Forum forum;
    private List<Topic> topicList;
    private List<String> moderators;
    private boolean isUpdate = false;
    private boolean isModerator = false;
    private boolean canAddNewThread = true;
    private UserProfile userProfile = null;
    private String strOrderBy = "";
    private boolean isLogin = false;
    private boolean isNull = false;
    private boolean enableIPLogging = true;
    private boolean isReload = true;
    private boolean isShowActive = false;
    private String DEFAULT_ID = TopicType.DEFAULT_ID;
    private Map<String, TopicType> topicTypeM = new HashMap();

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public UITopicContainer() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_T, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_B, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        if (!ForumSessionUtils.isAnonim()) {
            this.isLogin = true;
        }
        this.isLink = true;
    }

    private UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
    }

    public String getRSSLink(String cateId) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return RSS.getRSSLink((String)"forum", (String)pcontainer.getPortalContainerInfo().getContainerName(), (String)cateId);
    }

    private String getLastPostIdReadOfTopic(String topicId) throws Exception {
        return this.userProfile.getLastPostIdReadOfTopic(topicId);
    }

    public void setUpdateForum(String categoryId, Forum forum, int page) throws Exception {
        this.forum = forum;
        this.forumId = forum.getId();
        this.categoryId = categoryId;
        this.pageSelect = page;
        this.isUpdate = false;
        this.isReload = false;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + this.forumId);
        forumPortlet.updateAccessForum(this.forumId);
        this.userProfile = forumPortlet.getUserProfile();
        this.cleanCheckedList();
        this.setForum(true);
    }

    private boolean getIsAutoPrune() throws Exception {
        return this.isShowActive;
    }

    public void setTopicType(String typeId) throws Exception {
        block5: {
            try {
                TopicType topicType = this.forumService.getTopicType(typeId);
                if (topicType.getId().equals(TopicType.DEFAULT_ID)) {
                    if (this.topicTypeM.containsKey(typeId)) {
                        this.topicTypeM.remove(typeId);
                    }
                } else {
                    this.topicTypeM.put(typeId, topicType);
                }
            }
            catch (Exception e) {
                if (!this.topicTypeM.containsKey(typeId)) break block5;
                this.topicTypeM.remove(typeId);
            }
        }
    }

    private String[] getIconTopicType(String typeId) throws Exception {
        try {
            TopicType topicType = (TopicType)this.topicTypeM.get(typeId);
            if (topicType != null) {
                return new String[]{topicType.getIcon(), topicType.getName()};
            }
            topicType = this.forumService.getTopicType(typeId);
            if (!topicType.getId().equals(TopicType.DEFAULT_ID)) {
                this.topicTypeM.put(typeId, topicType);
                return new String[]{topicType.getIcon(), topicType.getName()};
            }
            return new String[]{" "};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[]{" "};
        }
    }

    private String getScreenName(String userName) throws Exception {
        return this.forumService.getScreenName(userName);
    }

    public void setIdUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public void updateByBreadcumbs(String categoryId, String forumId, boolean isBreadcumbs, int page) throws Exception {
        this.forumId = forumId;
        this.categoryId = categoryId;
        this.isUpdate = true;
        this.pageSelect = page;
        this.isReload = false;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        forumPortlet.updateAccessForum(forumId);
        this.userProfile = forumPortlet.getUserProfile();
        if (!isBreadcumbs) {
            ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + "/" + forumId);
        }
        this.cleanCheckedList();
        this.setForum(true);
    }

    public boolean getCanAddNewThread() {
        return this.canAddNewThread;
    }

    private void setForumModeratorPortlet() throws Exception {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            ActionResponse actionRes = (ActionResponse)pcontext.getResponse();
            ForumParameter param = new ForumParameter();
            param.setRenderModerator(true);
            param.setModerators(this.moderators);
            param.setRenderRule(true);
            List list = param.getInfoRules();
            boolean isLock = this.forum.getIsClosed();
            if (!isLock) {
                isLock = this.forum.getIsLock();
            }
            if (!isLock) {
                isLock = !this.canAddNewThread;
            }
            list.set(0, String.valueOf(isLock));
            param.setInfoRules(list);
            actionRes.setEvent(new QName("ForumModerateEvent"), (Serializable)param);
            actionRes.setEvent(new QName("ForumRuleEvent"), (Serializable)param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setForum(boolean isSetModerator) throws Exception {
        String[] strings;
        if (this.isUpdate || this.forum == null) {
            this.forum = this.forumService.getForum(this.categoryId, this.forumId);
            this.isUpdate = false;
        }
        this.canAddNewThread = true;
        this.moderators = ForumServiceUtils.getUserPermission((String[])this.forum.getModerators());
        String userId = this.userProfile.getUserId();
        List ipBaneds = this.forum.getBanIP();
        this.isModerator = false;
        if (this.userProfile.getUserRole() == 0L || !this.moderators.isEmpty() && this.moderators.contains(userId)) {
            this.isModerator = true;
        }
        if (ipBaneds != null && ipBaneds.size() > 0) {
            if (!ipBaneds.contains(this.getIPRemoter())) {
                strings = this.forum.getCreateTopicRole();
                if (strings != null && strings.length > 0 && !strings[0].equals(" ")) {
                    this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
                }
                if (!(this.canAddNewThread && strings != null && strings.length != 0 && !strings[0].equals(" ") || (strings = this.forumService.getPermissionTopicByCategory(this.categoryId, "createTopic")) == null || strings.length <= 0 || strings[0].equals(" "))) {
                    this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
                }
            } else {
                this.canAddNewThread = false;
            }
        } else if (!this.isModerator) {
            strings = this.forum.getCreateTopicRole();
            if (strings != null && strings.length > 0) {
                this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
            }
            if (!(this.canAddNewThread && strings != null && strings.length != 0 && !strings[0].equals(" ") || (strings = this.forumService.getPermissionTopicByCategory(this.categoryId, "createTopic")) == null || strings.length <= 0 || strings[0].equals(" "))) {
                this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
            }
        }
        if (isSetModerator) {
            this.setForumModeratorPortlet();
        }
        UIForumContainer forumContainer = (UIForumContainer)this.getParent();
        if (this.forum != null) {
            ((UIForumInfos)forumContainer.findFirstComponentOfType(UIForumInfos.class)).setForum(this.forum);
        }
    }

    private Forum getForum() throws Exception {
        return this.forum;
    }

    private void initPage() throws Exception {
        int maxTopic;
        this.objectId = this.forumId;
        if (this.userProfile == null) {
            this.userProfile = new UserProfile();
        }
        StringBuffer strQuery = new StringBuffer();
        String userId = this.userProfile.getUserId();
        if (this.isReload) {
            this.setForum(false);
        } else {
            this.isReload = true;
        }
        if (!this.isModerator) {
            strQuery.append("@exo:isClosed='false' and @exo:isWaiting='false' and @exo:isActive='true'");
            boolean isView = ForumServiceUtils.hasPermission((String[])this.forum.getPoster(), (String)userId);
            if (!isView) {
                isView = ForumServiceUtils.hasPermission((String[])this.forum.getViewer(), (String)userId);
            }
            if (!isView) {
                strQuery.append(" and (@exo:owner='").append(userId).append("' or @exo:canView=' ' or @exo:canPost=' '");
                for (String string : ForumSessionUtils.getAllGroupAndMembershipOfUser((String)userId)) {
                    strQuery.append(" or @exo:canView='" + string + "' or @exo:canPost='" + string + "'");
                }
                strQuery.append(")");
            }
        }
        if (!this.isModerator && this.forum.getIsModerateTopic()) {
            if (!ForumUtils.isEmpty((String)strQuery.toString())) {
                strQuery.append(" and ");
            }
            strQuery.append("@exo:isApproved='true'");
        }
        if ((maxTopic = this.userProfile.getMaxTopicInPage().intValue()) <= 0) {
            maxTopic = 10;
        }
        this.pageList = this.forumService.getTopicList(this.categoryId, this.forumId, strQuery.toString(), this.strOrderBy, maxTopic);
    }

    private String getIPRemoter() throws Exception {
        if (this.enableIPLogging) {
            WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
            PortletRequestImp request = (PortletRequestImp)context.getRequest();
            return request.getRemoteAddr();
        }
        return "";
    }

    private String[] getActionMenuForum() throws Exception {
        String[] actions = this.userProfile.getUserRole() == 0L ? new String[]{"EditForum", "SetUnLockForum", "SetLockedForum", "SetOpenForum", "SetCloseForum", "MoveForum", "RemoveForum", "ExportForum", "WatchOption", "BanIpForumTools"} : new String[]{"EditForum", "SetUnLockForum", "SetLockedForum", "SetOpenForum", "SetCloseForum", "ExportForum", "WatchOption", "BanIpForumTools"};
        return actions;
    }

    private String[] getActionMenuTopic() throws Exception {
        String[] actions = new String[]{"EditTopic", "SetOpenTopic", "SetCloseTopic", "SetLockedTopic", "SetUnLockTopic", "SetStickTopic", "SetUnStickTopic", "SetMoveTopic", "SetDeleteTopic", "MergeTopic", "SetUnWaiting", "ApproveTopics", "ActivateTopics"};
        return actions;
    }

    private List<Topic> getTopicPageList() throws Exception {
        this.maxPage = this.pageList.getAvailablePage();
        if (this.pageSelect > this.maxPage) {
            this.pageSelect = this.maxPage;
        }
        this.topicList = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.topicList == null) {
            this.topicList = new ArrayList();
        }
        this.isShowActive = false;
        try {
            for (Topic topic : this.topicList) {
                if (!topic.getIsActive()) {
                    this.isShowActive = true;
                }
                if (this.getUIFormCheckBoxInput(topic.getId()) != null) {
                    this.getUIFormCheckBoxInput(topic.getId()).setChecked(false);
                    continue;
                }
                UIFormCheckBoxInput checkItem = new UIFormCheckBoxInput(topic.getId(), topic.getId(), (Object)false);
                this.addChild((UIComponent)checkItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.topicList;
    }

    private Topic getTopicByAll(String topicId) throws Exception {
        List listTopic = this.pageList.getAll();
        for (Topic topic : listTopic) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return null;
    }

    private Topic getTopic(String topicId) throws Exception {
        try {
            for (Topic topic : this.topicList) {
                if (!topic.getId().equals(topicId)) continue;
                return topic;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private long getSizePost(Topic topic) throws Exception {
        long maxPost = this.userProfile.getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        if (topic.getPostCount() >= maxPost) {
            long availablePost = 0L;
            if (this.isModerator) {
                availablePost = topic.getPostCount() + 1L;
            } else {
                String isApprove = "";
                String userLogin = this.userProfile.getUserId();
                if ((this.forum.getIsModeratePost() || topic.getIsModeratePost()) && !topic.getOwner().equals(userLogin)) {
                    isApprove = "true";
                }
                availablePost = this.forumService.getAvailablePost(this.categoryId, this.forumId, topic.getId(), isApprove, "false", userLogin);
            }
            long value = availablePost / maxPost;
            if (value * maxPost < availablePost) {
                ++value;
            }
            return value;
        }
        return 1L;
    }

    private String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    static /* synthetic */ Forum access$000(UITopicContainer x0) {
        return x0.forum;
    }

    static /* synthetic */ boolean access$100(UITopicContainer x0) {
        return x0.isModerator;
    }

    static /* synthetic */ UserProfile access$200(UITopicContainer x0) {
        return x0.getUserProfile();
    }

    static /* synthetic */ String access$300(UITopicContainer x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$400(UITopicContainer x0) {
        return x0.forumId;
    }

    static /* synthetic */ UserProfile access$500(UITopicContainer x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Topic access$600(UITopicContainer x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ Forum access$002(UITopicContainer x0, Forum x1) {
        x0.forum = x1;
        return x0.forum;
    }

    static /* synthetic */ ForumService access$700(UITopicContainer x0) {
        return x0.forumService;
    }

    static /* synthetic */ Forum access$800(UITopicContainer x0) throws Exception {
        return x0.getForum();
    }

    static /* synthetic */ boolean access$902(UITopicContainer x0, boolean x1) {
        x0.isUpdate = x1;
        return x0.isUpdate;
    }

    static /* synthetic */ boolean access$1002(UITopicContainer x0, boolean x1) {
        x0.isReload = x1;
        return x0.isReload;
    }

    static /* synthetic */ Topic access$1100(UITopicContainer x0, String x1) throws Exception {
        return x0.getTopicByAll(x1);
    }

    static /* synthetic */ String access$1200(UITopicContainer x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$1202(UITopicContainer x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

