/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.webui.popup.UICategoryForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UICategoryForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddPrivateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UICategoryForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String CATEGORY_DETAIL_TAB = "DetailTab";
    public static final String CATEGORY_PERMISSION_TAB = "PermissionTab";
    public static final String FIELD_CATEGORYTITLE_INPUT = "CategoryTitle";
    public static final String FIELD_CATEGORYORDER_INPUT = "CategoryOrder";
    public static final String FIELD_DESCRIPTION_INPUT = "Description";
    public static final String FIELD_USERPRIVATE_MULTIVALUE = "UserPrivate";
    public static final String FIELD_MODERAROR_MULTIVALUE = "moderators";
    public static final String FIELD_VIEWER_MULTIVALUE = "Viewer";
    public static final String FIELD_POSTABLE_MULTIVALUE = "Postable";
    public static final String FIELD_TOPICABLE_MULTIVALUE = "Topicable";
    private String categoryId = "";
    private int id = 0;
    private boolean isDoubleClickSubmit = false;

    public UICategoryForm() throws Exception {
        UIFormInputWithActions.ActionData ad;
        UIFormInputWithActions detailTab = new UIFormInputWithActions(CATEGORY_DETAIL_TAB);
        UIFormInputWithActions permissionTab = new UIFormInputWithActions(CATEGORY_PERMISSION_TAB);
        UIFormStringInput categoryTitle = new UIFormStringInput(FIELD_CATEGORYTITLE_INPUT, FIELD_CATEGORYTITLE_INPUT, null);
        categoryTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput categoryOrder = new UIFormStringInput(FIELD_CATEGORYORDER_INPUT, FIELD_CATEGORYORDER_INPUT, "0");
        categoryOrder.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        UIFormTextAreaInput description = new UIFormTextAreaInput(FIELD_DESCRIPTION_INPUT, FIELD_DESCRIPTION_INPUT, null);
        UIFormTextAreaInput userPrivate = new UIFormTextAreaInput(FIELD_USERPRIVATE_MULTIVALUE, FIELD_USERPRIVATE_MULTIVALUE, null);
        UIFormTextAreaInput moderators = new UIFormTextAreaInput(FIELD_MODERAROR_MULTIVALUE, FIELD_MODERAROR_MULTIVALUE, null);
        UIFormTextAreaInput viewer = new UIFormTextAreaInput(FIELD_VIEWER_MULTIVALUE, FIELD_VIEWER_MULTIVALUE, null);
        UIFormTextAreaInput postable = new UIFormTextAreaInput(FIELD_POSTABLE_MULTIVALUE, FIELD_POSTABLE_MULTIVALUE, null);
        UIFormTextAreaInput topicable = new UIFormTextAreaInput(FIELD_TOPICABLE_MULTIVALUE, FIELD_TOPICABLE_MULTIVALUE, null);
        detailTab.addUIFormInput((UIFormInput)categoryTitle);
        detailTab.addUIFormInput((UIFormInput)categoryOrder);
        detailTab.addUIFormInput((UIFormInput)userPrivate);
        detailTab.addUIFormInput((UIFormInput)description);
        permissionTab.addUIFormInput((UIFormInput)moderators);
        permissionTab.addUIFormInput((UIFormInput)topicable);
        permissionTab.addUIFormInput((UIFormInput)postable);
        permissionTab.addUIFormInput((UIFormInput)viewer);
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        int i = 0;
        for (String string : strings) {
            ad = new UIFormInputWithActions.ActionData();
            ad.setActionListener("AddPrivate");
            ad.setActionParameter(String.valueOf(i) + "," + FIELD_USERPRIVATE_MULTIVALUE);
            ad.setCssIconClass(string + "Icon");
            ad.setActionName(string);
            actions.add(ad);
            ++i;
        }
        detailTab.setActionField(FIELD_USERPRIVATE_MULTIVALUE, actions);
        for (int j = 0; j < this.getChildIds().length; ++j) {
            String field = this.getChildIds()[j];
            actions = new ArrayList();
            i = 0;
            for (String string : strings) {
                ad = new UIFormInputWithActions.ActionData();
                ad.setActionListener("AddPrivate");
                ad.setActionParameter(String.valueOf(i) + "," + field);
                ad.setCssIconClass(string + "Icon");
                ad.setActionName(string);
                actions.add(ad);
                ++i;
            }
            permissionTab.setActionField(field, actions);
        }
        this.addUIFormInput((UIFormInputSet)detailTab);
        this.addUIFormInput((UIFormInputSet)permissionTab);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    private String[] getChildIds() {
        return new String[]{FIELD_MODERAROR_MULTIVALUE, FIELD_TOPICABLE_MULTIVALUE, FIELD_POSTABLE_MULTIVALUE, FIELD_VIEWER_MULTIVALUE};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setCategoryValue(Category category, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.categoryId = category.getId();
            this.getUIStringInput(FIELD_CATEGORYTITLE_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)category.getCategoryName()));
            this.getUIStringInput(FIELD_CATEGORYORDER_INPUT).setValue((Object)Long.toString(category.getCategoryOrder()));
            this.getUIFormTextAreaInput(FIELD_DESCRIPTION_INPUT).setDefaultValue((Object)ForumTransformHTML.unCodeHTML((String)category.getDescription()));
            String userPrivate = ForumUtils.unSplitForForum((String[])category.getUserPrivate());
            String moderator = ForumUtils.unSplitForForum((String[])category.getModerators());
            String topicAble = ForumUtils.unSplitForForum((String[])category.getCreateTopicRole());
            String poster = ForumUtils.unSplitForForum((String[])category.getPoster());
            String viewer = ForumUtils.unSplitForForum((String[])category.getViewer());
            this.getUIFormTextAreaInput(FIELD_USERPRIVATE_MULTIVALUE).setValue((Object)userPrivate);
            this.getUIFormTextAreaInput(FIELD_MODERAROR_MULTIVALUE).setValue((Object)moderator);
            this.getUIFormTextAreaInput(FIELD_TOPICABLE_MULTIVALUE).setValue((Object)topicAble);
            this.getUIFormTextAreaInput(FIELD_POSTABLE_MULTIVALUE).setValue((Object)poster);
            this.getUIFormTextAreaInput(FIELD_VIEWER_MULTIVALUE).setValue((Object)viewer);
        }
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        String values = (String)fieldInput.getValue();
        if (!ForumUtils.isEmpty((String)values)) {
            if (!ForumUtils.isStringInStrings((String[])(values = ForumUtils.removeSpaceInString((String)values)).split(","), (String)value)) {
                if (values.lastIndexOf(",") != values.length() - 1) {
                    values = values + ",";
                }
                values = values + value;
            }
        } else {
            values = value;
        }
        fieldInput.setValue((Object)values);
    }

    static /* synthetic */ boolean access$000(UICategoryForm x0) {
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ String access$100(UICategoryForm x0) {
        return x0.categoryId;
    }

    static /* synthetic */ boolean access$002(UICategoryForm x0, boolean x1) {
        x0.isDoubleClickSubmit = x1;
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ int access$202(UICategoryForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }

    static /* synthetic */ int access$200(UICategoryForm x0) {
        return x0.id;
    }
}

