/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIModerationForum;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIModerationForum.gtmpl", events={@EventConfig(listeners={OpenActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIModerationForum
extends UIForm
implements UIPopupComponent {
    private UserProfile userProfile;
    private ForumService forumService;
    private String[] path = new String[0];
    List<ForumSearch> list_;
    private boolean isShowIter = true;
    public final String SEARCH_ITERATOR = "moderationIterator";
    private JCRPageList pageList;
    private UIForumPageIterator pageIterator;

    public UIModerationForum() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "moderationIterator");
        this.setActions(new String[]{"Close"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
        if (this.userProfile == null) {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
    }

    public String[] getPath() {
        if (this.userProfile.getUserRole() <= 1L) {
            this.path = this.userProfile.getUserRole() == 1L ? this.userProfile.getModerateForums() : new String[0];
        }
        return this.path;
    }

    public void setPath(String[] path) {
        this.path = path;
    }

    public boolean getIsShowIter() {
        return this.isShowIter;
    }

    private List<ForumSearch> getListObject() throws Exception {
        try {
            this.list_ = this.forumService.getJobWattingForModerator(this.getPath());
        }
        catch (Exception e) {
            this.list_ = new ArrayList();
            e.printStackTrace();
        }
        this.pageList = new ForumPageList(10, this.list_.size());
        this.pageList.setPageSize(10);
        this.pageIterator.updatePageList(this.pageList);
        this.isShowIter = true;
        if (this.pageList.getAvailablePage() <= 1) {
            this.isShowIter = false;
        }
        long pageSelect = this.pageIterator.getPageSelected();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        try {
            list.addAll(this.pageList.getPageSearch(pageSelect, this.list_));
        }
        catch (Exception e) {
            // empty catch block
        }
        pageSelect = this.pageList.getCurrentPage();
        return list;
    }

    private ForumSearch getObject(String id) throws Exception {
        for (ForumSearch obj : this.list_) {
            if (!obj.getId().equals(id)) continue;
            return obj;
        }
        return null;
    }

    static /* synthetic */ ForumSearch access$000(UIModerationForum x0, String x1) throws Exception {
        return x0.getObject(x1);
    }

    static /* synthetic */ ForumService access$100(UIModerationForum x0) {
        return x0.forumService;
    }
}

