/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.forum.SettingPortletPreference;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ForumUtils {
    public static final String FIELD_EXOFORUM_LABEL = "eXoForum".intern();
    public static final String FIELD_SEARCHFORUM_LABEL = "SearchForum".intern();
    public static String UPLOAD_FILE_SIZE = "uploadFileSizeLimitMB".intern();
    public static final String SEARCHFORM_ID = "SearchForm".intern();
    public static final String GOPAGE_ID_T = "goPageTop".intern();
    public static final String GOPAGE_ID_B = "goPageBottom".intern();
    public static final String CATEGORIES = "Categories".intern();
    public static final String CATEGORY = "Category".intern();
    public static final String FORUM = "Forum".intern();
    public static final String THREAD = "Topic".intern();
    public static final String TAG = "Tag".intern();
    public static final String POST = "Post".intern();
    public static final String POLL = "Poll".intern();
    public static final int MAXSIGNATURE = 300;
    public static final int MAXTITLE = 100;
    public static final long MAXMESSAGE = 10000L;
    private String key;
    private String id;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static String getFormatDate(String format, Date myDate) {
        if (myDate == null) {
            return "";
        }
        String strCase = "";
        int day = myDate.getDay();
        switch (day) {
            case 0: {
                strCase = "Sunday";
                break;
            }
            case 1: {
                strCase = "Monday";
                break;
            }
            case 2: {
                strCase = "Tuesday";
                break;
            }
            case 3: {
                strCase = "Wednesday";
                break;
            }
            case 4: {
                strCase = "Thursday";
                break;
            }
            case 5: {
                strCase = "Friday";
                break;
            }
            case 6: {
                strCase = "Saturday";
                break;
            }
        }
        String form = "temp" + format;
        if (form.indexOf("DDDD") > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat(form.substring(form.indexOf("DDDD") + 5));
            return strCase + ", " + formatter.format((Object)myDate).replaceAll(",", ", ");
        }
        if (form.indexOf("DDD") > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat(form.substring(form.indexOf("DDD") + 4));
            return strCase.replaceFirst("day", "") + ", " + formatter.format((Object)myDate).replaceAll(",", ", ");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)myDate);
    }

    public static Calendar getInstanceTempCalendar() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isValidEmailAddresses(String addressList) throws Exception {
        if (ForumUtils.isEmpty((String)addressList)) {
            return true;
        }
        addressList = StringUtils.remove((String)addressList, (String)" ");
        addressList = StringUtils.replace((String)addressList, (String)";", (String)",");
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().toString().matches(emailRegex)) continue;
                return false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    public static String getSizeFile(double size) {
        String str;
        int t;
        String unit = " Byte";
        if (size >= 1000.0) {
            size /= 1024.0;
            unit = " Kb";
        }
        if (size >= 1000.0) {
            size /= 1024.0;
            unit = " Mb";
        }
        if ((t = (str = String.valueOf(size)).indexOf(".")) > 0 && str.length() > t + 4) {
            str = str.substring(0, t + 4);
        }
        return str + unit;
    }

    public static String getTimeZoneNumberInString(String string) {
        if (!ForumUtils.isEmpty((String)string)) {
            int c;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length() && (c = string.charAt(i)) != 41; ++i) {
                if (!Character.isDigit((char)c) && c != 45 && c != 43 && c != 58) continue;
                if (c == 58) {
                    c = 46;
                }
                if (c == 51 && string.charAt(i - 1) == ':') {
                    c = 53;
                }
                stringBuffer.append((char)c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String[] getStarNumber(double voteRating) throws Exception {
        int star = (int)voteRating;
        String[] className = new String[6];
        float k = 0.0f;
        for (int i = 0; i < 5; ++i) {
            if (i < star) {
                className[i] = "star";
            } else if (i == star) {
                k = (float)(voteRating - (double)i);
                if ((double)k < 0.25) {
                    className[i] = "notStar";
                }
                if ((double)k >= 0.25 && (double)k < 0.75) {
                    className[i] = "halfStar";
                }
                if ((double)k >= 0.75) {
                    className[i] = "star";
                }
            } else {
                className[i] = "notStar";
            }
            className[5] = "" + voteRating;
            if (className[5].length() >= 3) {
                className[5] = className[5].substring(0, 3);
            }
            if (k != 0.0f) continue;
            className[5] = "" + star;
        }
        return className;
    }

    public static String[] splitForForum(String str) throws Exception {
        if (!ForumUtils.isEmpty((String)str)) {
            if ((str = StringUtils.remove((String)str, (String)" ")).contains(",")) {
                str.replaceAll(";", ",");
                return str.trim().split(",");
            }
            str.replaceAll(",", ";");
            return str.trim().split(";");
        }
        return new String[0];
    }

    public static String unSplitForForum(String[] str) throws Exception {
        if (str == null || str.length == 0) {
            return "";
        }
        StringBuilder rtn = new StringBuilder();
        if (!str[0].equals(" ")) {
            for (String temp : str) {
                if (rtn.length() > 1) {
                    rtn.append(",").append(temp.trim());
                    continue;
                }
                rtn.append(temp.trim());
            }
        }
        return rtn.toString();
    }

    public static String removeSpaceInString(String str) throws Exception {
        if (!ForumUtils.isEmpty((String)str)) {
            String[] strs = new String[]{";", ", ", " ,", ",,"};
            for (int i = 0; i < strs.length; ++i) {
                while (str.indexOf(strs[i]) >= 0) {
                    str = str.replaceAll(strs[i], ",");
                }
            }
            if (str.lastIndexOf(",") == str.length() - 1) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.indexOf(",") == 0) {
                str = str.substring(1, str.length());
            }
            return str;
        }
        return "";
    }

    public static String removeZeroFirstNumber(String str) {
        if (!ForumUtils.isEmpty((String)str)) {
            while (str.length() > 1 && str.charAt(0) == '0') {
                str = str.replaceFirst("0", "");
            }
        }
        return str;
    }

    public static String removeStringResemble(String s) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)s)) {
            String[] temp = ForumUtils.splitForForum((String)s);
            s = "";
            int l = temp.length;
            for (int i = 0; i < l; ++i) {
                if (list.contains(temp[i]) || temp[i].trim().length() == 0) continue;
                list.add(temp[i]);
                s = i == l - 1 ? s + temp[i] : s + temp[i] + ",";
            }
            return s;
        }
        return "";
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String[] addStringToString(String input, String output) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)output) && !ForumUtils.isEmpty((String)input)) {
            String[] temp;
            if (input.lastIndexOf(",") != input.length() - 1) {
                input = input + ",";
            }
            output = input + output;
            for (String string : temp = ForumUtils.splitForForum((String)output)) {
                if (list.contains(string) || string.length() == 0) continue;
                list.add(string);
            }
        }
        if (list.size() == 0) {
            list.add(" ");
        }
        return list.toArray(new String[0]);
    }

    public static boolean isStringInStrings(String[] strings, String string) {
        string = string.trim();
        for (String string1 : strings) {
            if (!string.equals(string1 = string1.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringInList(List<String> list, String string) {
        return list.contains(string);
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!ForumUtils.isEmpty((String)str) && (l = str.length()) > max) {
            int space = (str = str.substring(0, max)).lastIndexOf(" ");
            str = space > max - 6 ? str.substring(0, space) + "..." : str + "...";
        }
        return str;
    }

    public static String getLabel(String label, String key) {
        if (ForumUtils.isEmpty((String)key)) {
            key = " ";
        }
        try {
            return label.replaceFirst("<keyWord>", key);
        }
        catch (Exception e) {
            String s = label.substring(0, label.indexOf("<keyWord>") - 1);
            return s + "'" + key + "'" + label.substring(label.indexOf("<keyWord>"));
        }
    }

    public static String[] getColor() {
        return new String[]{"blue", "DarkGoldenRod", "green", "yellow", "BlueViolet", "orange", "darkBlue", "IndianRed", "DarkCyan", "lawnGreen"};
    }

    public static String getDefaultMail() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString("UIForumAdministrationForm.label.notifyEmailContentDefault");
    }

    public static boolean enableIPLogging() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", ""));
    }

    public static void savePortletPreference(String listCategoryId, String listForumId) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        portletPref.setValue("invisibleCategories", listCategoryId);
        portletPref.setValue("invisibleForums", listForumId);
        portletPref.store();
    }

    public static SettingPortletPreference getPorletPreference() throws Exception {
        SettingPortletPreference preference = new SettingPortletPreference();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        preference.setShowForumActionBar(Boolean.parseBoolean(portletPref.getValue("showForumActionBar", "")));
        preference.setForumNewPost(Integer.parseInt(portletPref.getValue("forumNewPost", "")));
        preference.setUseAjax(Boolean.parseBoolean(portletPref.getValue("useAjax", "")));
        preference.setEnableIPLogging(Boolean.parseBoolean(portletPref.getValue("enableIPLogging", "")));
        preference.setEnableIPFiltering(Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", "")));
        preference.setInvisibleCategories(ForumUtils.getListInValus((String)portletPref.getValue("invisibleCategories", "")));
        preference.setInvisibleForums(ForumUtils.getListInValus((String)portletPref.getValue("invisibleForums", "")));
        preference.setShowForumJump(Boolean.parseBoolean(portletPref.getValue("isShowForumJump", "")));
        preference.setShowIconsLegend(Boolean.parseBoolean(portletPref.getValue("isShowIconsLegend", "")));
        preference.setShowModerators(Boolean.parseBoolean(portletPref.getValue("isShowModerators", "")));
        preference.setShowPoll(Boolean.parseBoolean(portletPref.getValue("isShowPoll", "")));
        preference.setShowQuickReply(Boolean.parseBoolean(portletPref.getValue("isShowQuickReply", "")));
        preference.setShowRules(Boolean.parseBoolean(portletPref.getValue("isShowRules", "")));
        preference.setShowStatistics(Boolean.parseBoolean(portletPref.getValue("isShowStatistics", "")));
        return preference;
    }

    public static void savePortletPreference(SettingPortletPreference sPreference) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String listForumId = "";
        String listCategoryId = "";
        List invisibleForums = sPreference.getInvisibleForums();
        List invisibleCategories = sPreference.getInvisibleCategories();
        if (!invisibleCategories.isEmpty()) {
            listForumId = invisibleForums.toString().replace("[", "").replace("]", "").replaceAll(" ", "");
            listCategoryId = invisibleCategories.toString().replace("[", "").replace("]", "").replaceAll(" ", "");
        }
        portletPref.setValue("isShowForumJump", sPreference.isShowForumJump() + "");
        portletPref.setValue("isShowIconsLegend", sPreference.isShowIconsLegend() + "");
        portletPref.setValue("isShowModerators", sPreference.isShowModerators() + "");
        portletPref.setValue("isShowPoll", sPreference.isShowPoll() + "");
        portletPref.setValue("isShowQuickReply", sPreference.isShowQuickReply() + "");
        portletPref.setValue("isShowRules", sPreference.isShowRules() + "");
        portletPref.setValue("isShowStatistics", sPreference.isShowStatistics() + "");
        portletPref.setValue("useAjax", sPreference.isUseAjax() + "");
        portletPref.setValue("invisibleCategories", listCategoryId);
        portletPref.setValue("invisibleForums", listForumId);
        portletPref.store();
    }

    public static List<String> getListInValus(String value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    public static int getLimitUploadSize() {
        int limitMB;
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            limitMB = Integer.parseInt(portletPref.getValue(UPLOAD_FILE_SIZE, "").trim());
        }
        catch (Exception e) {
            limitMB = -1;
        }
        return limitMB;
    }

    public static String getActionViewInfoUser(String link, String conponentId, String actionRepl, String actionWith) {
        if (ForumUtils.isEmpty((String)link)) {
            return "";
        }
        link = StringUtils.replace((String)link, (String)conponentId, (String)"UIForumPortlet");
        if ((link = StringUtils.replace((String)link, (String)actionRepl, (String)actionWith)).indexOf("javascript") < 0) {
            link = "javascript:ajaxGet('" + link + "&ajaxRequest=true')";
        }
        return link;
    }

    public static String getCalculateListEmail(String s) throws Exception {
        String[] strs = ForumUtils.splitForForum((String)s);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (i > 0) {
                builder.append(",<br/>");
            }
            builder.append("<span title='").append(strs[i]).append("'>").append(ForumUtils.getSubString((String)strs[i], (int)15)).append("</span>");
        }
        return builder.toString();
    }
}

