/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISplitTopicForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISplitTopicForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UISplitTopicForm
extends UIForumKeepStickPageIterator
implements UIPopupComponent {
    private Topic topic = new Topic();
    private String link;
    private UserProfile userProfile = null;
    private boolean isRender = true;
    private boolean isSetPage = true;
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    public static final String FIELD_SPLITTHREAD_INPUT = "SplitThread";

    public UISplitTopicForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SPLITTHREAD_INPUT, FIELD_SPLITTHREAD_INPUT, null));
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean getIdRender() {
        return this.isRender;
    }

    private List<Post> getListPost() throws Exception {
        List<Post> posts = new ArrayList();
        String path = this.topic.getPath();
        path = path.substring(path.indexOf(Utils.CATEGORY));
        if (this.isSetPage) {
            this.pageList = this.forumService.getPostForSplitTopic(path);
        }
        this.pageList.setPageSize(6);
        this.maxPage = this.pageList.getAvailablePage();
        posts = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.maxPage <= 1) {
            this.isRender = false;
        }
        for (Post post : posts) {
            String checkBoxId = post.getCreatedDate().getTime() + "/" + post.getId();
            if (this.getUIFormCheckBoxInput(checkBoxId) != null) {
                this.getUIFormCheckBoxInput(checkBoxId).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(checkBoxId, checkBoxId, (Object)false));
        }
        this.isSetPage = true;
        return posts;
    }

    public void setPageListPost(JCRPageList pageList) {
        this.pageList = pageList;
        this.isSetPage = false;
    }

    private Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    private UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    static /* synthetic */ Topic access$000(UISplitTopicForm x0) {
        return x0.topic;
    }

    static /* synthetic */ ForumService access$100(UISplitTopicForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ UserProfile access$200(UISplitTopicForm x0) {
        return x0.userProfile;
    }
}

