/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UIViewPost;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewPost.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ApproveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeletePostActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenTopicLinkActionListener.class}), @EventConfig(listeners={DownloadAttachActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewPost
extends UIForm
implements UIPopupComponent {
    private Post post;
    private boolean isViewUserInfo = true;
    private ForumService forumService;
    private UserProfile userProfile;
    private List<BBCode> listBBCode = new ArrayList();

    public UIViewPost() {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    }

    public void setActionForm(String[] actions) {
        this.setActions(actions);
    }

    private UserProfile getUserProfile() throws Exception {
        block4: {
            try {
                this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
            }
            catch (Exception e) {
                String userName = UserHelper.getCurrentUser();
                if (userName == null) break block4;
                try {
                    this.userProfile = this.forumService.getQuickProfile(userName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.userProfile;
    }

    private String getReplaceByBBCode(String s) throws Exception {
        try {
            s = Utils.getReplacementByBBcode((String)s, (List)this.listBBCode, (ForumService)this.forumService);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getFileSource(ForumAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return ForumSessionUtils.getFileSource((InputStream)input, (String)fileName, (DownloadService)dservice);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void setPostView(Post post) throws Exception {
        this.post = post;
        List bbcName = new ArrayList();
        ArrayList<BBCode> bbcs = new ArrayList<BBCode>();
        try {
            bbcName = this.forumService.getActiveBBCode();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean isAdd = true;
        for (String string : bbcName) {
            isAdd = true;
            for (BBCode bbc : this.listBBCode) {
                if (!bbc.getTagName().equals(string) && (!bbc.getTagName().equals(string.replaceFirst("=", "")) || !bbc.isOption())) continue;
                bbcs.add(bbc);
                isAdd = false;
                break;
            }
            if (!isAdd) continue;
            BBCode bbCode = new BBCode();
            if (string.indexOf("=") >= 0) {
                bbCode.setOption(true);
                string = string.replaceFirst("=", "");
                bbCode.setId(string + "_option");
            } else {
                bbCode.setId(string);
            }
            bbCode.setTagName(string);
            bbcs.add(bbCode);
        }
        this.listBBCode.clear();
        this.listBBCode.addAll(bbcs);
    }

    private Post getPostView() throws Exception {
        return this.post;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setViewUserInfo(boolean isView) {
        this.isViewUserInfo = isView;
    }

    public boolean getIsViewUserInfo() {
        return this.isViewUserInfo;
    }

    static /* synthetic */ Post access$000(UIViewPost x0) {
        return x0.post;
    }

    static /* synthetic */ ForumService access$100(UIViewPost x0) {
        return x0.forumService;
    }

    static /* synthetic */ UserProfile access$200(UIViewPost x0) {
        return x0.userProfile;
    }
}

