/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.forum.webui.popup.UIPopupAction;
import org.exoplatform.forum.webui.popup.UIPopupContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUIForm
extends UIForm {
    protected Log log = ExoLogger.getLogger(this.getClass());

    public String i18n(String key) {
        ResourceBundle res = null;
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            res = context.getApplicationResourceBundle();
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            this.log.warn((Object)("Could not find key for in " + res + " for locale " + res.getLocale()));
            return key;
        }
    }

    public String getLabel(String labelID) {
        ResourceBundle res = null;
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            res = context.getApplicationResourceBundle();
            return super.getLabel(res, labelID);
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not find label for " + labelID + "in " + res + " for locale " + res.getLocale()));
            return labelID;
        }
    }

    protected void info(String messageKey) {
        this.info(messageKey, (String[])null);
    }

    protected void info(String messageKey, String ... args) {
        this.message(messageKey, args, 2);
    }

    protected void warning(String messageKey) {
        this.warning(messageKey, (String[])null);
    }

    protected void warning(String messageKey, String ... args) {
        this.message(messageKey, args, 1);
    }

    private void message(String messageKey, String[] args, int messageType) {
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        uiApp.addMessage(new ApplicationMessage(messageKey, (Object[])args, messageType));
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
    }

    protected void throwWarning(String message, String ... args) throws MessageException {
        throw new MessageException(new ApplicationMessage(message, (Object[])args, 1));
    }

    protected void throwWarning(String message) throws MessageException {
        throw new MessageException(new ApplicationMessage(message, new Object[0], 1));
    }

    protected <T extends UIComponent> T openPopup(UIContainer parent, Class<T> componentType, String popupId, int width, int height) throws Exception {
        UIPopupAction popupAction = (UIPopupAction)parent.getChild(UIPopupAction.class);
        UIPopupContainer popupContainer = (UIPopupContainer)popupAction.createUIComponent(UIPopupContainer.class, null, null);
        UIComponent form = popupContainer.addChild(componentType, null, null);
        popupAction.activate((UIComponent)popupContainer, width, height);
        if (popupId != null) {
            popupContainer.setId(popupId);
        }
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)popupAction);
        return (T)form;
    }

    protected <T extends UIComponent> T openPopup(UIContainer parent, Class<T> componentType, int width, int height) throws Exception {
        return (T)this.openPopup(parent, componentType, null, width, height);
    }
}

