/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListTopicByUser;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/popup/UIPageListTopicByUser.gtmpl", events={@EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={DeleteTopicActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisTopic")})
public class UIPageListTopicByUser
extends UIContainer {
    private ForumService forumService;
    private UserProfile userProfile;
    private JCRPageList pageList;
    private String strOrderBy = "";
    private String userName = new String();
    private boolean isUseAjax = true;
    private List<Topic> topics = new ArrayList();

    public UIPageListTopicByUser() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIForumPageIterator.class, null, "PageListTopicByUser");
    }

    private UserProfile getUserProfile() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.userProfile = forumPortlet.getUserProfile();
        return this.userProfile;
    }

    public boolean isUseAjax() {
        return this.isUseAjax;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private String getTitleInHTMLCode(String s) {
        return ForumTransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    private List<Topic> getTopicsByUser() throws Exception {
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        try {
            boolean isMod = false;
            if (this.userProfile.getUserRole() == 0L) {
                isMod = true;
            }
            this.pageList = this.forumService.getPageTopicByUser(this.userName, isMod, this.strOrderBy);
            forumPageIterator.updatePageList(this.pageList);
            if (this.pageList != null) {
                this.pageList.setPageSize(6);
            }
            this.topics = this.pageList.getPage(forumPageIterator.getPageSelected());
            forumPageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.topics;
    }

    public Topic getTopicById(String topicId) throws Exception {
        for (Topic topic : this.topics) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return (Topic)this.forumService.getObjectNameById(topicId, Utils.TOPIC);
    }

    private String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    static /* synthetic */ ForumService access$000(UIPageListTopicByUser x0) {
        return x0.forumService;
    }

    static /* synthetic */ UserProfile access$100(UIPageListTopicByUser x0) {
        return x0.userProfile;
    }

    static /* synthetic */ String access$200(UIPageListTopicByUser x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$202(UIPageListTopicByUser x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

