/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.io.InputStream;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.rendering.RenderHelper;
import org.exoplatform.forum.rendering.RenderingException;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIViewPost;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewPost.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ApproveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeletePostActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenTopicLinkActionListener.class}), @EventConfig(listeners={DownloadAttachActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewPost
extends UIForm
implements UIPopupComponent {
    private Post post;
    private boolean isViewUserInfo = true;
    private ForumService forumService;
    private UserProfile userProfile;
    RenderHelper renderHelper = new RenderHelper();

    public UIViewPost() {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    }

    public void setActionForm(String[] actions) {
        this.setActions(actions);
    }

    private UserProfile getUserProfile() throws Exception {
        block4: {
            try {
                this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
            }
            catch (Exception e) {
                String userName = UserHelper.getCurrentUser();
                if (userName == null) break block4;
                try {
                    this.userProfile = this.forumService.getQuickProfile(userName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.userProfile;
    }

    public String renderPost(Post post) throws RenderingException {
        return this.renderHelper.renderPost(post);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getFileSource(ForumAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return ForumSessionUtils.getFileSource((InputStream)input, (String)fileName, (DownloadService)dservice);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void setPostView(Post post) throws Exception {
        this.post = post;
    }

    private Post getPostView() throws Exception {
        return this.post;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setViewUserInfo(boolean isView) {
        this.isViewUserInfo = isView;
    }

    public boolean getIsViewUserInfo() {
        return this.isViewUserInfo;
    }

    static /* synthetic */ Post access$000(UIViewPost x0) {
        return x0.post;
    }

    static /* synthetic */ ForumService access$100(UIViewPost x0) {
        return x0.forumService;
    }
}

