/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIViewResultSearchUser;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewResultSearchUser.gtmpl", events={@EventConfig(listeners={ViewUserActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewResultSearchUser
extends UIForm
implements UIPopupComponent {
    private List<UserProfile> userProfiles = new ArrayList();
    private JCRPageList pageList;
    private static String FORUM_PAGE_ITERATOR = "ForumUserPageIterator";
    private String[] permissionUser = null;
    private long totalPage = 0L;

    public UIViewResultSearchUser() throws Exception {
        this.addChild(UIForumPageIterator.class, null, FORUM_PAGE_ITERATOR);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.permissionUser = new String[]{res.getString("UIForumPortlet.label.PermissionAdmin").toLowerCase(), res.getString("UIForumPortlet.label.PermissionModerator").toLowerCase(), res.getString("UIForumPortlet.label.PermissionUser").toLowerCase(), res.getString("UIForumPortlet.label.PermissionGuest").toLowerCase()};
        this.setActions(new String[]{"Close"});
    }

    public void setPageListSearch(JCRPageList pageList) {
        this.pageList = pageList;
        this.pageList.setPageSize(5);
        ((UIForumPageIterator)this.getChild(UIForumPageIterator.class)).updatePageList(this.pageList);
    }

    private List<UserProfile> getListUserProfile() throws Exception {
        UIForumPageIterator pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        long page = pageIterator.getPageSelected();
        ArrayList listUserProfile = this.pageList.getPage(page);
        pageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        if (listUserProfile == null) {
            listUserProfile = new ArrayList();
        }
        this.userProfiles = new ArrayList();
        for (UserProfile userProfile : listUserProfile) {
            this.userProfiles.add(userProfile);
        }
        return this.userProfiles;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String[] getPermissionUser() {
        return this.permissionUser;
    }

    public void setPermissionUser(String[] permissionUser) {
        this.permissionUser = permissionUser;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }
}

