/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UICategory;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UICategory.gtmpl", events={@EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={ExportCategoryActionListener.class}), @EventConfig(listeners={ImportForumActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UICategory.confirm.DeleteCategory"), @EventConfig(listeners={AddForumActionListener.class}), @EventConfig(listeners={EditForumActionListener.class}), @EventConfig(listeners={SetLockedActionListener.class}), @EventConfig(listeners={SetUnLockActionListener.class}), @EventConfig(listeners={SetOpenActionListener.class}), @EventConfig(listeners={SetCloseActionListener.class}), @EventConfig(listeners={MoveForumActionListener.class}), @EventConfig(listeners={RemoveForumActionListener.class}), @EventConfig(listeners={OpenForumLinkActionListener.class}), @EventConfig(listeners={OpenLastTopicLinkActionListener.class}), @EventConfig(listeners={OpenLastReadTopicActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UICategory
extends BaseForumForm {
    private UserProfile userProfile = null;
    private String categoryId;
    private Category category;
    private boolean isEditCategory = false;
    private boolean isEditForum = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private List<Forum> forums = new ArrayList();
    private List<Watch> listWatches = new ArrayList();
    private Map<String, Topic> MaptopicLast = new HashMap();
    public static boolean isUnWatch = false;
    public static String unwatchEmail = "";

    public UICategory() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        this.setActions(new String[]{"EditCategory", "ExportCategory", "ImportForum", "DeleteCategory", "WatchOption", "AddForum", "EditForum", "SetLocked", "SetUnLock", "SetOpen", "SetClose", "MoveForum", "RemoveForum"});
    }

    private UserProfile getUserProfile() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.useAjax = forumPortlet.isUseAjax();
        this.dayForumNewPost = forumPortlet.getDayForumNewPost();
        this.userProfile = forumPortlet.getUserProfile();
        this.listWatches = forumPortlet.getWatchingByCurrentUser();
        return this.userProfile;
    }

    public String getRSSLink(String cateId) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return RSS.getRSSLink((String)"forum", (String)pcontainer.getPortalContainerInfo().getContainerName(), (String)cateId);
    }

    private int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    private String getLastReadPostOfForum(String forumId) throws Exception {
        return this.userProfile.getLastPostIdReadOfForum(forumId);
    }

    private String getScreenName(String userName) throws Exception {
        return this.getForumService().getScreenName(userName);
    }

    public void update(Category category, List<Forum> forums) throws Exception {
        this.category = category;
        if (forums == null) {
            this.isEditForum = true;
        } else {
            this.forums = forums;
        }
        this.categoryId = category.getId();
        ((UIBreadcumbs)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getChild(UIBreadcumbs.class)).setUpdataPath(this.categoryId);
    }

    public void updateByBreadcumbs(String categoryId) {
        this.categoryId = categoryId;
        this.isEditCategory = true;
        this.isEditForum = true;
    }

    public void updateByLink(Category category) {
        this.categoryId = category.getId();
        this.isEditCategory = false;
        this.isEditForum = true;
        this.category = category;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    private Category getCategory() throws Exception {
        if (this.isEditCategory || this.category == null) {
            try {
                this.category = this.getForumService().getCategory(this.categoryId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isEditCategory = false;
        }
        return this.category;
    }

    private Category refreshCategory() throws Exception {
        try {
            this.category = this.getForumService().getCategory(this.categoryId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.category;
    }

    private boolean isShowForum(String id) {
        if (((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleCategories().isEmpty()) {
            return true;
        }
        ArrayList list = new ArrayList();
        list.addAll(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleForums());
        return list.contains(id);
    }

    private List<Forum> getForumList() throws Exception {
        if (this.isEditForum) {
            String strQuery = "";
            if (this.userProfile.getUserRole() > 0L) {
                strQuery = "(@exo:isClosed='false') or (exo:moderators='" + this.userProfile.getUserId() + "')";
            }
            try {
                this.forums = this.getForumService().getForumSummaries(this.categoryId, strQuery);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isEditForum = false;
            ((UICategories)((UICategoryContainer)this.getAncestorOfType(UICategoryContainer.class)).getChild(UICategories.class)).setIsgetForumList(true);
        }
        ArrayList<Forum> listForum = new ArrayList<Forum>();
        for (Forum forum : this.forums) {
            String forumId = forum.getId();
            if (this.getUIFormCheckBoxInput(forumId) != null) {
                this.getUIFormCheckBoxInput(forumId).setChecked(false);
            } else {
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(forumId, forumId, (Object)false));
            }
            if (!this.isShowForum(forumId)) continue;
            listForum.add(forum);
        }
        return listForum;
    }

    public void setIsEditCategory(boolean isEdit) {
        this.isEditCategory = isEdit;
    }

    public void setIsEditForum(boolean isEdit) {
        this.isEditForum = isEdit;
    }

    private Forum getForum(String forumId) throws Exception {
        for (Forum forum : this.forums) {
            if (!forum.getId().equals(forumId)) continue;
            return forum;
        }
        return null;
    }

    private Topic getLastTopic(Category cate, Forum forum) throws Exception {
        Topic topic = null;
        String topicPath = forum.getLastTopicPath();
        if (!ForumUtils.isEmpty((String)topicPath)) {
            try {
                topic = this.getForumService().getTopicByPath(topicPath, true);
            }
            catch (Exception e) {
                topic = null;
                this.log.warn((Object)e);
            }
            if (topic != null) {
                String topicId = topic.getId();
                if (((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).checkCanView(cate, forum, topic)) {
                    this.MaptopicLast.put(topicId, topic);
                } else {
                    if (this.MaptopicLast.containsKey(topicId)) {
                        this.MaptopicLast.remove(topicId);
                    }
                    return null;
                }
            }
        }
        return topic;
    }

    private Topic getTopic(String topicId) throws Exception {
        if (this.MaptopicLast.containsKey(topicId)) {
            return (Topic)this.MaptopicLast.get(topicId);
        }
        return null;
    }

    private boolean isWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            if (!path.equals(watch.getNodePath()) || !watch.isAddWatchByEmail()) continue;
            return true;
        }
        return false;
    }

    private String getEmailWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            try {
                if (!watch.getNodePath().endsWith(path)) continue;
                return watch.getEmail();
            }
            catch (Exception e) {
            }
        }
        return "";
    }

    static /* synthetic */ Category access$000(UICategory x0) throws Exception {
        return x0.getCategory();
    }

    static /* synthetic */ boolean access$102(UICategory x0, boolean x1) {
        x0.isEditCategory = x1;
        return x0.isEditCategory;
    }

    static /* synthetic */ String access$200(UICategory x0) {
        return x0.categoryId;
    }

    static /* synthetic */ boolean access$302(UICategory x0, boolean x1) {
        x0.isEditForum = x1;
        return x0.isEditForum;
    }

    static /* synthetic */ Forum access$400(UICategory x0, String x1) throws Exception {
        return x0.getForum(x1);
    }

    static /* synthetic */ Topic access$500(UICategory x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ UserProfile access$600(UICategory x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Category access$700(UICategory x0) {
        return x0.category;
    }

    static /* synthetic */ String access$800(UICategory x0, String x1) throws Exception {
        return x0.getEmailWatching(x1);
    }

    static /* synthetic */ Category access$900(UICategory x0) throws Exception {
        return x0.refreshCategory();
    }

    static /* synthetic */ UserProfile access$1000(UICategory x0) throws Exception {
        return x0.getUserProfile();
    }
}

