/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIBanIPForumManagerForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIBanIPForumManagerForm.gtmpl", events={@EventConfig(listeners={AddIpActionListener.class}), @EventConfig(listeners={OpenPostsActionListener.class}), @EventConfig(listeners={UnBanActionListener.class}, confirm="UIBanIPForumManagerForm.confirm.UnBanIP"), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBanIPForumManagerForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String SEARCH_IP_BAN = "searchIpBan";
    public static final String NEW_IP_BAN_INPUT1 = "newIpBan1";
    public static final String NEW_IP_BAN_INPUT2 = "newIpBan2";
    public static final String NEW_IP_BAN_INPUT3 = "newIpBan3";
    public static final String NEW_IP_BAN_INPUT4 = "newIpBan4";
    public static final String BAN_IP_PAGE_ITERATOR = "IpBanPageIterator";
    private String forumId = "null";
    private boolean isForum = false;
    private JCRPageList pageList;
    private UIForumPageIterator pageIterator;

    public UIBanIPForumManagerForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_IP_BAN, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT1, null).setMaxLength(3));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT2, null).setMaxLength(3));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT3, null).setMaxLength(3));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT4, null).setMaxLength(3));
        this.setActions(new String[]{"Cancel"});
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, BAN_IP_PAGE_ITERATOR);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setForumId(String forumId) {
        this.forumId = forumId;
        this.isForum = true;
    }

    private String getRestPath() throws Exception {
        try {
            ExoContainerContext exoContext = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
            return "/" + exoContext.getPortalContainerName() + "/" + exoContext.getRestContextName();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not get portal name or rest context name, exception: ", (Throwable)e);
            return "";
        }
    }

    private List<String> getListIpBan() throws Exception {
        List listIpBan = new ArrayList();
        if (this.isForum) {
            listIpBan = this.getForumService().getForumBanList(this.forumId);
        } else {
            listIpBan.addAll(this.getForumService().getBanList());
        }
        this.pageList = new ForumPageList(8, listIpBan.size());
        this.pageList.setPageSize(8);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pageList.getPageList((long)this.pageIterator.getPageSelected(), listIpBan));
        this.pageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        try {
            if (this.pageList.getAvailablePage() <= 1) {
                this.pageIterator.setRendered(false);
            } else {
                this.pageIterator.setRendered(true);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed to init page iterator", (Throwable)e);
        }
        return list;
    }

    public String checkIpAddress(String[] ipAdd) {
        StringBuilder ip = new StringBuilder();
        if (ipAdd.length < 4) {
            return null;
        }
        try {
            int[] ips = new int[4];
            for (int t = 0; t < ipAdd.length; ++t) {
                if (t > 0) {
                    ip.append(".");
                }
                ip.append(ipAdd[t]);
                ips[t] = Integer.parseInt(ipAdd[t]);
            }
            for (int i = 0; i < 4; ++i) {
                if (ips[i] >= 0 && ips[i] <= 255) continue;
                return null;
            }
            if (ips[0] == 255 && ips[1] == 255 && ips[2] == 255 && ips[3] == 255) {
                return null;
            }
            if (ips[0] == 0 && ips[1] == 0 && ips[2] == 0 && ips[3] == 0) {
                return null;
            }
            return ip.toString();
        }
        catch (Exception e) {
            this.log.error((Object)"failed to check IP address, Ip is not format number.");
            return null;
        }
    }

    private String getValueIp(String inputId) throws Exception {
        UIFormStringInput stringInput = this.getUIStringInput(inputId);
        String vl = (String)stringInput.getValue();
        stringInput.setValue((Object)"");
        return ForumUtils.isEmpty((String)vl) ? "0" : vl;
    }

    static /* synthetic */ String access$000(UIBanIPForumManagerForm x0, String x1) throws Exception {
        return x0.getValueIp(x1);
    }

    static /* synthetic */ boolean access$100(UIBanIPForumManagerForm x0) {
        return x0.isForum;
    }

    static /* synthetic */ String access$200(UIBanIPForumManagerForm x0) {
        return x0.forumId;
    }

    static /* synthetic */ ForumService access$300(UIBanIPForumManagerForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$400(UIBanIPForumManagerForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$500(UIBanIPForumManagerForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$600(UIBanIPForumManagerForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ void access$700(UIBanIPForumManagerForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

