/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListTopicUnApprove;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPageListTopicUnApprove.gtmpl", events={@EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={ApproveTopicActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPageListTopicUnApprove
extends UIForumKeepStickPageIterator
implements UIPopupComponent {
    private String categoryId;
    private String forumId;
    private int typeApprove = 3;
    private List<Topic> topics;

    public UIPageListTopicUnApprove() throws Exception {
        this.setActions(new String[]{"ApproveTopic", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public int getTypeApprove() {
        return this.typeApprove;
    }

    public void setTypeApprove(int typeApprove) {
        this.typeApprove = typeApprove;
    }

    private UserProfile getUserProfile() throws Exception {
        return ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
    }

    public void setUpdateContainer(String categoryId, String forumId) {
        this.categoryId = categoryId;
        this.forumId = forumId;
    }

    private String getTitleInHTMLCode(String s) {
        return ForumTransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    private List<Topic> getTopicsUnApprove() throws Exception {
        String type = this.typeApprove == 5 ? "exo:isWaiting" : (this.typeApprove == 3 ? "exo:isApproved" : "exo:isActive");
        this.pageList = this.getForumService().getPageTopic(this.categoryId, this.forumId, "@" + type + "='" + (this.typeApprove == 5 ? "true" : "false") + "'", "");
        this.pageList.setPageSize(6);
        this.maxPage = this.pageList.getAvailablePage();
        this.topics = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.topics == null) {
            this.topics = new ArrayList();
        }
        for (Topic topic : this.topics) {
            if (this.getUIFormCheckBoxInput(topic.getId()) != null) {
                this.getUIFormCheckBoxInput(topic.getId()).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(topic.getId(), topic.getId(), (Object)false));
        }
        return this.topics;
    }

    private Topic getTopic(String topicId) throws Exception {
        for (Topic topic : this.topics) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return (Topic)this.getForumService().getObjectNameById(topicId, Utils.TOPIC);
    }

    static /* synthetic */ Topic access$000(UIPageListTopicUnApprove x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ int access$100(UIPageListTopicUnApprove x0) {
        return x0.typeApprove;
    }

    static /* synthetic */ ForumService access$200(UIPageListTopicUnApprove x0) {
        return x0.getForumService();
    }

    static /* synthetic */ void access$300(UIPageListTopicUnApprove x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ List access$400(UIPageListTopicUnApprove x0) {
        return x0.topics;
    }
}

