/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIForumInputWithActions;
import org.exoplatform.forum.webui.popup.UIPostForm;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPostForm.gtmpl", events={@EventConfig(listeners={PreviewPostActionListener.class}), @EventConfig(listeners={SubmitPostActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectIconActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPostForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_POSTTITLE_INPUT = "PostTitle";
    public static final String FIELD_EDITREASON_INPUT = "editReason";
    public static final String FIELD_LABEL_QUOTE = "ReUser";
    public static final String ACT_REMOVE = "remove";
    public static final String FIELD_ATTACHMENTS = "Attachments";
    public static final String FIELD_FROM_INPUT = "FromInput";
    public static final String FIELD_MESSAGECONTENT = "MessageContent";
    public static final String FIELD_ORIGINALLY = "Originally";
    public static final String FIELD_THREADCONTEN_TAB = "ThreadContent";
    public static final String FIELD_THREADICON_TAB = "IconAndSmiley";
    private int tabId = 0;
    private List<ForumAttachment> attachments_ = new ArrayList();
    private String categoryId;
    private String forumId;
    private String topicId;
    private String postId = "";
    private boolean isMod = false;
    private Topic topic;
    private Post post_ = new Post();
    private boolean isQuote = false;
    private boolean isMP = false;
    private String link = "";
    private boolean isDoubleClickSubmit = false;

    public UIPostForm() throws Exception {
        if (ForumUtils.isEmpty((String)this.getId())) {
            this.setId("UIPostForm");
        }
        this.isDoubleClickSubmit = false;
        UIFormStringInput postTitle = new UIFormStringInput(FIELD_POSTTITLE_INPUT, FIELD_POSTTITLE_INPUT, null);
        postTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput editReason = new UIFormStringInput(FIELD_EDITREASON_INPUT, FIELD_EDITREASON_INPUT, null);
        editReason.setRendered(false);
        UIForumInputWithActions threadContent = new UIForumInputWithActions(FIELD_THREADCONTEN_TAB);
        UIFormWYSIWYGInput formWYSIWYGInput = new UIFormWYSIWYGInput(FIELD_MESSAGECONTENT, FIELD_MESSAGECONTENT, "");
        formWYSIWYGInput.addValidator(MandatoryValidator.class, new Object[0]);
        formWYSIWYGInput.setToolBarName("Basic");
        formWYSIWYGInput.setFCKConfig(org.exoplatform.ks.common.Utils.getFCKConfig());
        threadContent.addChild((UIComponent)postTitle);
        threadContent.addChild((UIComponent)editReason);
        threadContent.addChild((UIComponent)formWYSIWYGInput);
        threadContent.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        threadContent.setActionField(FIELD_THREADCONTEN_TAB, this.getUploadFileList());
        threadContent.setActionIdAddItem(FIELD_ATTACHMENTS);
        threadContent.setActionAddItem("Attachment");
        threadContent.setLabelActionAddItem(this.getLabel("Attachment"));
        UIFormInputIconSelector inputIconSelector = new UIFormInputIconSelector(FIELD_THREADICON_TAB, FIELD_THREADICON_TAB);
        inputIconSelector.setSelectedIcon("IconsView");
        this.addUIFormInput((UIFormInputSet)threadContent);
        this.addUIFormInput((UIFormInput)inputIconSelector);
        this.setActions(new String[]{"PreviewPost", "SubmitPost", "Cancel"});
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    private boolean tabIsSelected(int tabId) {
        return this.tabId == tabId;
    }

    private String[] getTabName() {
        String[] tab = new String[]{"UIPostForm.tittle.threadContent", "UIPostForm.tittle.iconAndSmiley"};
        return tab;
    }

    public void setPostIds(String categoryId, String forumId, String topicId, Topic topic) {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        this.topic = topic;
    }

    public List<UIForumInputWithActions.ActionData> getUploadFileList() {
        ArrayList<UIForumInputWithActions.ActionData> uploadedFiles = new ArrayList<UIForumInputWithActions.ActionData>();
        for (ForumAttachment attachdata : this.attachments_) {
            UIForumInputWithActions.ActionData fileUpload = new UIForumInputWithActions.ActionData();
            fileUpload.setActionListener("");
            fileUpload.setActionType(2);
            fileUpload.setCssIconClass("AttachmentIcon");
            String size = ForumUtils.getSizeFile((long)attachdata.getSize());
            fileUpload.setActionName(attachdata.getName() + "(" + size + ")");
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIForumInputWithActions.ActionData removeAction = new UIForumInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(ACT_REMOVE);
            removeAction.setActionParameter(attachdata.getId());
            removeAction.setActionType(0);
            removeAction.setCssIconClass("DustBin");
            removeAction.setBreakLine(true);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void refreshUploadFileList() throws Exception {
        UIForumInputWithActions threadContent = (UIForumInputWithActions)this.getChildById(FIELD_THREADCONTEN_TAB);
        threadContent.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
    }

    public void addToUploadFileList(ForumAttachment attachfile) {
        this.attachments_.add(attachfile);
    }

    public void removeFromUploadFileList(ForumAttachment attachfile) {
        this.attachments_.remove(attachfile);
    }

    public void removeUploadFileList() {
        this.attachments_.clear();
    }

    public List<ForumAttachment> getAttachFileList() {
        return this.attachments_;
    }

    public void updatePost(String postId, boolean isQuote, boolean isPP, Post post) throws Exception {
        if (post != null) {
            this.post_ = post;
        }
        this.postId = postId;
        this.isQuote = isQuote;
        this.isMP = isPP;
        UIForumInputWithActions threadContent = (UIForumInputWithActions)this.getChildById(FIELD_THREADCONTEN_TAB);
        UIFormStringInput editReason = threadContent.getUIStringInput(FIELD_EDITREASON_INPUT);
        editReason.setRendered(false);
        if (!ForumUtils.isEmpty((String)this.postId) && post != null) {
            String message = post.getMessage();
            if (isQuote) {
                String title = "";
                title = post.getName().indexOf(": ") > 0 ? post.getName() : this.getLabel(FIELD_LABEL_QUOTE) + ": " + post.getName();
                threadContent.getUIStringInput(FIELD_POSTTITLE_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)title));
                String value = "[QUOTE=" + post.getOwner() + "]" + message + "[/QUOTE]";
                ((UIFormWYSIWYGInput)threadContent.getChild(UIFormWYSIWYGInput.class)).setValue((Object)value);
                ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(this.topic.getIcon());
            } else if (isPP) {
                String title = this.topic.getTopicName();
                threadContent.getUIStringInput(FIELD_POSTTITLE_INPUT).setValue((Object)(this.getLabel(FIELD_LABEL_QUOTE) + ": " + ForumTransformHTML.unCodeHTML((String)title)));
                ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(this.topic.getIcon());
            } else {
                editReason.setRendered(true);
                threadContent.getUIStringInput(FIELD_POSTTITLE_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)post.getName()));
                if (post.getAttachments() != null && post.getAttachments().size() > 0) {
                    this.attachments_ = post.getAttachments();
                    this.refreshUploadFileList();
                }
                ((UIFormWYSIWYGInput)threadContent.getChild(UIFormWYSIWYGInput.class)).setValue((Object)message);
                ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(post.getIcon());
            }
        } else if (!isQuote) {
            String title = this.topic.getTopicName();
            threadContent.getUIStringInput(FIELD_POSTTITLE_INPUT).setValue((Object)(this.getLabel(FIELD_LABEL_QUOTE) + ": " + ForumTransformHTML.unCodeHTML((String)title)));
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(this.topic.getIcon());
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean checkForumHasAddTopic(UserProfile userProfile) throws Exception {
        this.topic = (Topic)this.getForumService().getObjectNameById(this.topicId, Utils.TOPIC);
        if (this.topic.getIsClosed() || this.topic.getIsLock()) {
            return false;
        }
        Forum forum = (Forum)this.getForumService().getObjectNameById(this.forumId, Utils.FORUM);
        if (forum.getIsClosed() || forum.getIsLock()) {
            return false;
        }
        if (userProfile.getUserRole() > 1L || userProfile.getUserRole() == 1L && !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)userProfile.getUserId())) {
            if (!this.topic.getIsActive() || !this.topic.getIsActiveByForum()) {
                return false;
            }
            String[] canCreadPost = this.topic.getCanPost();
            if (!ForumUtils.isArrayEmpty((String[])canCreadPost)) {
                return ForumServiceUtils.hasPermission((String[])canCreadPost, (String)userProfile.getUserId());
            }
        }
        return true;
    }

    private String[] getCensoredKeyword() throws Exception {
        ForumAdministration forumAdministration = this.getForumService().getForumAdministration();
        String stringKey = forumAdministration.getCensoredKeyword();
        if (stringKey != null && stringKey.length() > 0) {
            stringKey = stringKey.toLowerCase().replaceAll(", ", ",").replaceAll(" ,", ",");
            return ForumUtils.splitForForum((String)stringKey);
        }
        return new String[0];
    }

    public boolean isMod() {
        return this.isMod;
    }

    public void setMod(boolean isMod) {
        this.isMod = isMod;
    }

    static /* synthetic */ Post access$000(UIPostForm x0) {
        return x0.post_;
    }

    static /* synthetic */ String access$100(UIPostForm x0) {
        return x0.postId;
    }

    static /* synthetic */ UIComponent access$200(UIPostForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$300(UIPostForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$400(UIPostForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ boolean access$500(UIPostForm x0) {
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ boolean access$502(UIPostForm x0, boolean x1) {
        x0.isDoubleClickSubmit = x1;
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ boolean access$600(UIPostForm x0, UserProfile x1) throws Exception {
        return x0.checkForumHasAddTopic(x1);
    }

    static /* synthetic */ String[] access$700(UIPostForm x0) throws Exception {
        return x0.getCensoredKeyword();
    }

    static /* synthetic */ boolean access$800(UIPostForm x0) {
        return x0.isMP;
    }

    static /* synthetic */ Topic access$900(UIPostForm x0) {
        return x0.topic;
    }

    static /* synthetic */ void access$1000(UIPostForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ String access$1100(UIPostForm x0) {
        return x0.topicId;
    }

    static /* synthetic */ boolean access$1200(UIPostForm x0) {
        return x0.isQuote;
    }

    static /* synthetic */ String access$1300(UIPostForm x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$1400(UIPostForm x0) {
        return x0.forumId;
    }

    static /* synthetic */ ForumService access$1500(UIPostForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$1600(UIPostForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$1700(UIPostForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$1800(UIPostForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$1900(UIPostForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ boolean access$802(UIPostForm x0, boolean x1) {
        x0.isMP = x1;
        return x0.isMP;
    }

    static /* synthetic */ boolean access$1202(UIPostForm x0, boolean x1) {
        x0.isQuote = x1;
        return x0.isQuote;
    }

    static /* synthetic */ void access$2000(UIPostForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$2100(UIPostForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$2200(UIPostForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$2300(UIPostForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$2400(UIPostForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$2500(UIPostForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ Log access$2600(UIPostForm x0) {
        return x0.log;
    }

    static /* synthetic */ void access$2700(UIPostForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ UIComponent access$2800(UIPostForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ int access$2902(UIPostForm x0, int x1) {
        x0.tabId = x1;
        return x0.tabId;
    }

    static /* synthetic */ List access$3000(UIPostForm x0) {
        return x0.attachments_;
    }
}

