/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIShowBookMarkForm;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIShowBookMarkForm.gtmpl", events={@EventConfig(listeners={OpenLinkActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteLinkActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIShowBookMarkForm
extends BaseUIForm
implements UIPopupComponent {
    ForumService forumService;
    public final String BOOKMARK_ITERATOR = "BookmarkPageIterator";
    private JCRPageList pageList;
    UIForumPageIterator pageIterator;
    private List<String> bookMarks = new ArrayList();

    public UIShowBookMarkForm() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "BookmarkPageIterator");
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private List<String> getBookMark() throws Exception {
        try {
            this.bookMarks = this.forumService.getBookmarks(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile().getUserId());
        }
        catch (Exception e) {
            this.log.error((Object)"Getting book mark fail: ", (Throwable)e);
        }
        this.pageList = new ForumPageList(6, this.bookMarks.size());
        this.pageList.setPageSize(6);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pageList.getPageList((long)this.pageIterator.getPageSelected(), this.bookMarks));
        this.pageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        try {
            if (this.pageList.getAvailablePage() <= 1) {
                this.pageIterator.setRendered(false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("\nCould not render a UIComponent: " + e.getMessage() + "\n" + e.getCause()));
        }
        return list;
    }

    private String getBookMarkId(String id) throws Exception {
        for (String str : this.bookMarks) {
            if (str.indexOf(id) < 0) continue;
            return str;
        }
        return ForumUtils.EMPTY_STR;
    }

    private String getType(String id) {
        return id.indexOf(Utils.FORUM_SERVICE) >= 0 ? Utils.FORUM_SERVICE : (id.indexOf(Utils.CATEGORY) >= 0 ? ForumUtils.CATEGORY : (id.indexOf(Utils.FORUM) >= 0 ? ForumUtils.FORUM : (id.indexOf(Utils.TOPIC) >= 0 ? ForumUtils.TOPIC : ForumUtils.EMPTY_STR)));
    }
}

