/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIBBCodeManagerForm;
import org.exoplatform.ks.bbcode.api.BBCode;
import org.exoplatform.ks.bbcode.api.BBCodeService;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIBBCodeManagerForm.gtmpl", events={@EventConfig(listeners={AddNewBBCodeActionListener.class}), @EventConfig(listeners={EditBBCodeActionListener.class}), @EventConfig(listeners={DeleteBBCodeActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBBCodeManagerForm
extends BaseForumForm
implements UIPopupComponent {
    private BBCodeService bbCodeService;
    private List<BBCode> listBBCode = new ArrayList();

    public UIBBCodeManagerForm() {
        this.bbCodeService = (BBCodeService)this.getApplicationComponent(BBCodeService.class);
        this.setActions(new String[]{"AddNewBBCode", "Save", "Close"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void loadBBCodes() throws Exception {
        this.listBBCode = new ArrayList();
        try {
            this.listBBCode.addAll(this.bbCodeService.getAll());
        }
        catch (Exception e) {
            this.log.error((Object)"failed to set BBCode List", (Throwable)e);
        }
        this.initCheckBoxActiveBBCode();
    }

    private String getIdCheckBox(String id) {
        return id.contains("=") ? id.replaceFirst("=", "opt") : id;
    }

    public void initCheckBoxActiveBBCode() throws Exception {
        for (BBCode bbc : this.listBBCode) {
            String id = this.getIdCheckBox(bbc.getId());
            UIFormCheckBoxInput isActiveBBcode = this.getUIFormCheckBoxInput(id);
            if (isActiveBBcode == null) {
                isActiveBBcode = new UIFormCheckBoxInput(id, id, (Object)false);
                this.addUIFormInput((UIFormInput)isActiveBBcode);
            }
            isActiveBBcode.setChecked(bbc.isActive());
        }
    }

    private List<BBCode> getListBBcode() throws Exception {
        return this.listBBCode;
    }

    private BBCode getBBCode(String bbcId) {
        for (BBCode bbCode : this.listBBCode) {
            if (!bbCode.getId().equals(bbcId)) continue;
            return bbCode;
        }
        return new BBCode();
    }

    static /* synthetic */ UIComponent access$000(UIBBCodeManagerForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ BBCode access$100(UIBBCodeManagerForm x0, String x1) {
        return x0.getBBCode(x1);
    }

    static /* synthetic */ UIComponent access$200(UIBBCodeManagerForm x0, UIContainer x1, Class x2, String x3, int x4, int x5) throws Exception {
        return x0.openPopup(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ BBCodeService access$300(UIBBCodeManagerForm x0) {
        return x0.bbCodeService;
    }

    static /* synthetic */ List access$400(UIBBCodeManagerForm x0) {
        return x0.listBBCode;
    }

    static /* synthetic */ String access$500(UIBBCodeManagerForm x0, String x1) {
        return x0.getIdCheckBox(x1);
    }

    static /* synthetic */ Log access$600(UIBBCodeManagerForm x0) {
        return x0.log;
    }
}

