/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UICategory;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumDescription;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UISearchForm;
import org.exoplatform.forum.webui.UITopicContainer;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.forum.webui.UITopicDetailContainer;
import org.exoplatform.forum.webui.UITopicPoll;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.forum.webui.popup.UIPostForm;
import org.exoplatform.forum.webui.popup.UISettingEditModeForm;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.ks.common.webui.WebUIUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/forum/webui/UIForumPortlet.gtmpl", events={@EventConfig(listeners={ReLoadPortletEventActionListener.class}), @EventConfig(listeners={ViewPublicUserInfoActionListener.class}), @EventConfig(listeners={ViewPostedByUserActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={ViewThreadByUserActionListener.class}), @EventConfig(listeners={OpenLinkActionListener.class})})
public class UIForumPortlet
extends UIPortletApplication {
    public static String QUICK_REPLY_EVENT_PARAMS = "UIForumPortlet.QuickReplyEventParams";
    public static String FORUM_POLL_EVENT_PARAMS = "UIForumPortlet.ForumPollEventParams";
    public static String RULE_EVENT_PARAMS = "UIForumPortlet.RuleEventParams";
    public static String FORUM_MODERATE_EVENT_PARAMS = "UIForumPortlet.ForumModerateEvent";
    public static String FORUM_LINK_EVENT_PARAMS = "UIForumPortlet.ForumLinkEvent";
    private ForumService forumService;
    private boolean isCategoryRendered = true;
    private boolean isForumRendered = false;
    private boolean isTagRendered = false;
    private boolean isSearchRendered = false;
    private boolean isJumpRendered = false;
    private boolean isShowForumJump = false;
    private boolean isShowPoll = false;
    private boolean isShowModerators = false;
    private boolean isShowRules = false;
    private boolean isShowIconsLegend = false;
    private boolean isShowStatistics = false;
    private boolean isShowQuickReply = false;
    private UserProfile userProfile = null;
    private boolean enableIPLogging = false;
    private boolean prefForumActionBar = false;
    private boolean isRenderActionBar = false;
    private boolean enableBanIP = false;
    private boolean useAjax = true;
    protected boolean forumSpDeleted = false;
    private int dayForumNewPost = 0;
    private String categorySpId = "";
    private String forumSpId = null;
    private String spaceGroupId = null;
    protected String spaceDisplayName = null;
    private List<String> invisibleForums = new ArrayList();
    private List<String> invisibleCategories = new ArrayList();
    private PortletMode portletMode;

    public UIForumPortlet() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIBreadcumbs.class, null, null);
        this.isRenderActionBar = !UserHelper.isAnonim();
        ((UIForumActionBar)this.addChild(UIForumActionBar.class, null, null)).setRendered(this.isRenderActionBar);
        ((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
        ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
        ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
        ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
        UIPopupAction popupAction = (UIPopupAction)this.addChild(UIPopupAction.class, null, "UIForumPopupAction");
        ((UIPopupWindow)popupAction.getChild(UIPopupWindow.class)).setId("UIForumPopupWindow");
        try {
            this.loadPreferences();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to load portlet preferences", (Throwable)e);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        this.portletMode = portletReqContext.getApplicationMode();
        if (this.portletMode == PortletMode.VIEW) {
            boolean bl = this.isRenderActionBar = !UserHelper.isAnonim();
            if (this.getChild(UIBreadcumbs.class) == null) {
                if (this.getChild(UISettingEditModeForm.class) != null) {
                    this.removeChild(UISettingEditModeForm.class);
                }
                this.addChild(UIBreadcumbs.class, null, null);
                ((UIForumActionBar)this.addChild(UIForumActionBar.class, null, null)).setRendered(this.isRenderActionBar);
                UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
                ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
                ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
                ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
                ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
                this.updateIsRendered(ForumUtils.CATEGORIES);
                categoryContainer.updateIsRender(true);
            }
            this.updateCurrentUserProfile();
        } else if (this.portletMode == PortletMode.EDIT && this.getChild(UISettingEditModeForm.class) == null) {
            UISettingEditModeForm editModeForm = (UISettingEditModeForm)this.addChild(UISettingEditModeForm.class, null, null);
            editModeForm.setInitComponent();
            this.removeAllChildPorletView();
        }
        try {
            this.renderComponentByURL(context);
        }
        catch (Exception e) {
            log.error((Object)"Can not open component by url, view exception: ", (Throwable)e);
        }
        super.processRender(app, context);
    }

    private void removeAllChildPorletView() {
        if (this.getChild(UIBreadcumbs.class) != null) {
            this.removeChild(UIBreadcumbs.class);
            this.removeChild(UIForumActionBar.class);
            this.removeChild(UICategoryContainer.class);
            this.removeChild(UIForumContainer.class);
            this.removeChild(UITopicsTag.class);
            this.removeChild(UISearchForm.class);
            this.removeChild(UIForumLinks.class);
        }
    }

    public void renderComponentByURL(WebuiRequestContext context) throws Exception {
        this.forumSpDeleted = false;
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String isAjax = portalContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            return;
        }
        String url = portalContext.getRequest().getRequestURL().toString();
        String pageNodeSelected = ForumUtils.SLASH + Util.getUIPortal().getSelectedUserNode().getURI();
        String portalName = Util.getUIPortal().getName();
        if (url.contains(portalName + pageNodeSelected)) {
            url = url.substring(url.lastIndexOf(portalName + pageNodeSelected) + (portalName + pageNodeSelected).length());
        } else if (url.contains(pageNodeSelected)) {
            url = url.substring(url.lastIndexOf(pageNodeSelected) + pageNodeSelected.length());
        }
        if (!ForumUtils.isEmpty((String)url)) {
            url = url.contains(ForumUtils.SLASH + Utils.FORUM_SERVICE) ? url.substring(url.lastIndexOf(Utils.FORUM_SERVICE)) : (url.contains(ForumUtils.SLASH + Utils.CATEGORY) ? url.substring(url.lastIndexOf(ForumUtils.SLASH + Utils.CATEGORY) + 1) : (url.contains(ForumUtils.SLASH + Utils.TOPIC) ? url.substring(url.lastIndexOf(ForumUtils.SLASH + Utils.TOPIC) + 1) : (url.contains(ForumUtils.SLASH + Utils.FORUM) ? url.substring(url.lastIndexOf(ForumUtils.SLASH + Utils.FORUM) + 1) : url)));
        } else if (!ForumUtils.isEmpty((String)this.getForumIdOfSpace())) {
            url = this.getForumIdOfSpace();
        }
        if (!ForumUtils.isEmpty((String)url) && url.length() > Utils.FORUM.length()) {
            this.calculateRenderComponent(url, context);
            context.addUIComponentToUpdateByAjax((UIComponent)this);
        }
    }

    public String getForumIdOfSpace() {
        block3: {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            if (pref.getValue("SPACE_URL", null) != null && ForumUtils.isEmpty((String)this.forumSpId)) {
                String url = pref.getValue("SPACE_URL", null);
                SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                Space space = sService.getSpaceByUrl(url);
                this.spaceGroupId = space.getGroupId();
                this.forumSpId = Utils.FORUM_SPACE_ID_PREFIX + space.getPrettyName();
                this.spaceDisplayName = space.getDisplayName();
                try {
                    OrganizationService service = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
                    String parentGrId = service.getGroupHandler().findGroupById(this.spaceGroupId).getParentId();
                    this.categorySpId = Utils.CATEGORY + parentGrId.replaceAll(CommonUtils.SLASH, CommonUtils.EMPTY_STR);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Failed to set category id of space " + space.getPrettyName()), (Throwable)e);
                }
            }
        }
        return this.forumSpId;
    }

    public void updateIsRendered(String selected) {
        if (selected.equals(ForumUtils.CATEGORIES)) {
            this.isCategoryRendered = true;
            this.isForumRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected.equals(ForumUtils.FORUM)) {
            this.isForumRendered = true;
            this.isCategoryRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected.equals(ForumUtils.TAG)) {
            this.isTagRendered = true;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = false;
        } else {
            this.isTagRendered = false;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = true;
        }
        if (!(this.prefForumActionBar || this.isCategoryRendered && !this.isSearchRendered)) {
            this.isRenderActionBar = false;
        }
        ((UIForumActionBar)this.getChild(UIForumActionBar.class)).setRendered(this.isRenderActionBar);
        this.setRenderForumLink();
        ((UIForumContainer)this.getChild(UIForumContainer.class)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.getChild(UITopicsTag.class)).setRendered(this.isTagRendered);
        ((UISearchForm)this.getChild(UISearchForm.class)).setRendered(this.isSearchRendered);
        if (!this.isForumRendered) {
            this.setRenderQuickReply();
        }
    }

    public void renderForumHome() throws Exception {
        this.updateIsRendered(ForumUtils.CATEGORIES);
        UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
        categoryContainer.updateIsRender(true);
        ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
        ((UIForumLinks)this.getChild(UIForumLinks.class)).setUpdateForumLinks();
        ((UIBreadcumbs)this.getChild(UIBreadcumbs.class)).setUpdataPath(Utils.FORUM_SERVICE);
    }

    public void setRenderForumLink() {
        this.isJumpRendered = this.isShowForumJump ? (!ForumUtils.isEmpty((String)this.getForumIdOfSpace()) ? false : this.getUserProfile().getIsShowForumJump()) : false;
        UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.getChild(UICategoryContainer.class)).setRendered(this.isCategoryRendered);
        categoryContainer.setIsRenderJump(this.isJumpRendered);
        if (!this.isCategoryRendered) {
            ((UIForumLinks)this.getChild(UIForumLinks.class)).setRendered(this.isJumpRendered);
        }
    }

    public void setRenderQuickReply() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletSession portletSession = pcontext.getRequest().getPortletSession();
        ActionResponse actionRes = null;
        if (pcontext.getResponse() instanceof ActionResponse) {
            actionRes = (ActionResponse)pcontext.getResponse();
        }
        ForumParameter param = new ForumParameter();
        param.setRenderQuickReply(false);
        param.setRenderPoll(false);
        param.setRenderModerator(false);
        param.setRenderRule(false);
        if (actionRes != null) {
            actionRes.setEvent(new QName("QuickReplyEvent"), (Serializable)param);
            actionRes.setEvent(new QName("ForumPollEvent"), (Serializable)param);
            actionRes.setEvent(new QName("ForumModerateEvent"), (Serializable)param);
            actionRes.setEvent(new QName("ForumRuleEvent"), (Serializable)param);
        } else {
            portletSession.setAttribute(QUICK_REPLY_EVENT_PARAMS, (Object)param, 1);
            portletSession.setAttribute(FORUM_POLL_EVENT_PARAMS, (Object)param, 1);
            portletSession.setAttribute(FORUM_MODERATE_EVENT_PARAMS, (Object)param, 1);
            portletSession.setAttribute(RULE_EVENT_PARAMS, (Object)param, 1);
        }
    }

    public void loadPreferences() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            PortletRequestContext pContext = (PortletRequestContext)context;
            PortletPreferences portletPref = pContext.getRequest().getPreferences();
            this.invisibleCategories.clear();
            this.invisibleForums.clear();
            this.prefForumActionBar = Boolean.parseBoolean(portletPref.getValue("showForumActionBar", ForumUtils.EMPTY_STR));
            this.dayForumNewPost = Integer.parseInt(portletPref.getValue("forumNewPost", ForumUtils.EMPTY_STR));
            this.useAjax = Boolean.parseBoolean(portletPref.getValue("useAjax", ForumUtils.EMPTY_STR));
            this.enableIPLogging = Boolean.parseBoolean(portletPref.getValue("enableIPLogging", ForumUtils.EMPTY_STR));
            this.enableBanIP = Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", ForumUtils.EMPTY_STR));
            this.isShowForumJump = Boolean.parseBoolean(portletPref.getValue("isShowForumJump", ForumUtils.EMPTY_STR));
            this.isShowPoll = Boolean.parseBoolean(portletPref.getValue("isShowPoll", ForumUtils.EMPTY_STR));
            this.isShowModerators = Boolean.parseBoolean(portletPref.getValue("isShowModerators", ForumUtils.EMPTY_STR));
            this.isShowRules = Boolean.parseBoolean(portletPref.getValue("isShowRules", ForumUtils.EMPTY_STR));
            this.isShowQuickReply = Boolean.parseBoolean(portletPref.getValue("isShowQuickReply", ForumUtils.EMPTY_STR));
            this.isShowStatistics = Boolean.parseBoolean(portletPref.getValue("isShowStatistics", ForumUtils.EMPTY_STR));
            this.isShowIconsLegend = Boolean.parseBoolean(portletPref.getValue("isShowIconsLegend", ForumUtils.EMPTY_STR));
            this.invisibleCategories.addAll(this.getListInValus(portletPref.getValue("invisibleCategories", ForumUtils.EMPTY_STR)));
            this.invisibleForums.addAll(this.getListInValus(portletPref.getValue("invisibleForums", ForumUtils.EMPTY_STR)));
            if (this.invisibleCategories.size() == 1 && ((String)this.invisibleCategories.get(0)).equals(" ")) {
                this.invisibleCategories.clear();
            }
        }
    }

    private List<String> getListInValus(String value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    public String[] getImportJSTagCode() {
        return new String[]{"shCore", "shBrushBash", "shBrushCpp", "shBrushCSharp", "shBrushCss", "shBrushDelphi", "shBrushGroovy", "shBrushJava", "shBrushJScript", "shBrushPhp", "shBrushPython", "shBrushRuby", "shBrushScala", "shBrushSql", "shBrushVb", "shBrushXml"};
    }

    public List<String> getInvisibleForums() {
        return this.invisibleForums;
    }

    public List<String> getInvisibleCategories() {
        return this.invisibleCategories;
    }

    public boolean isEnableIPLogging() {
        return this.enableIPLogging;
    }

    public boolean isEnableBanIp() {
        return this.enableBanIP;
    }

    public boolean isShowForumActionBar() {
        return this.prefForumActionBar;
    }

    public boolean isShowPoll() {
        return this.isShowPoll;
    }

    public boolean isShowModerators() {
        return this.isShowModerators;
    }

    public boolean isShowRules() {
        return this.isShowRules;
    }

    public boolean isShowIconsLegend() {
        return this.isShowIconsLegend;
    }

    public boolean isShowQuickReply() {
        return this.isShowQuickReply;
    }

    public boolean isShowStatistics() {
        return this.isShowStatistics;
    }

    public boolean isUseAjax() {
        return this.useAjax;
    }

    public int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public void updateCurrentUserProfile() {
        UIForumActionBar actionBar;
        try {
            String userId = UserHelper.getCurrentUser();
            this.userProfile = this.enableBanIP ? this.forumService.getDefaultUserProfile(userId, WebUIUtils.getRemoteIP()) : this.forumService.getDefaultUserProfile(userId, null);
            if (!ForumUtils.isEmpty((String)userId)) {
                this.userProfile.setEmail(UserHelper.getUserByUserId((String)userId).getEmail());
            }
            if (this.userProfile.getIsBanned()) {
                this.userProfile.setUserRole(3L);
            }
        }
        catch (Exception e) {
            this.userProfile = new UserProfile();
        }
        if (4L == this.userProfile.getUserRole() || 3L == this.userProfile.getUserRole()) {
            this.isRenderActionBar = false;
        }
        if ((actionBar = (UIForumActionBar)this.getChild(UIForumActionBar.class)) != null) {
            actionBar.setRendered(this.isRenderActionBar);
        }
    }

    public UserProfile getUserProfile() {
        if (this.userProfile == null) {
            this.updateCurrentUserProfile();
        }
        return this.userProfile;
    }

    public void updateAccessTopic(String topicId) throws Exception {
        String userId = this.userProfile.getUserId();
        if (userId != null && userId.length() > 0) {
            this.forumService.updateTopicAccess(userId, topicId);
        }
        this.userProfile.setLastTimeAccessTopic(topicId, CommonUtils.getGreenwichMeanTime().getTimeInMillis());
    }

    public void updateAccessForum(String forumId) throws Exception {
        String userId = this.userProfile.getUserId();
        if (userId != null && userId.length() > 0) {
            this.forumService.updateForumAccess(userId, forumId);
        }
        this.userProfile.setLastTimeAccessForum(forumId, CommonUtils.getGreenwichMeanTime().getTimeInMillis());
    }

    public void removeCacheUserProfile() {
        try {
            this.forumService.removeCacheUserProfile(this.userProfile.getUserId());
        }
        catch (Exception e) {
            log.debug((Object)("Failed to remove cache userprofile with user: " + this.userProfile.getUserId()));
        }
    }

    public String getPortletLink(String actionName, String userName) {
        try {
            return this.event(actionName, userName);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to set link to view info user.", (Throwable)e);
            return null;
        }
    }

    protected String getCometdContextName() {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
        return bayeux == null ? "cometd" : bayeux.getCometdContextName();
    }

    public String getUserToken() throws Exception {
        try {
            ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
            return continuation.getUserToken(this.userProfile.getUserId());
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve continuation token for user " + this.userProfile.getUserId()), (Throwable)e);
            return ForumUtils.EMPTY_STR;
        }
    }

    private boolean isArrayNotNull(String[] strs) {
        return strs != null && strs.length > 0 && !strs[0].equals(" ");
    }

    public boolean checkForumHasAddTopic(String categoryId, String forumId) throws Exception {
        block8: {
            if (this.getUserProfile().getUserRole() == 0L) {
                return true;
            }
            if (this.getUserProfile().getUserId().contains("user_gest_uoom")) {
                return false;
            }
            Forum forum = (Forum)this.forumService.getObjectNameById(forumId, Utils.FORUM);
            if (forum.getIsClosed() || forum.getIsLock()) {
                return false;
            }
            Category cate = (Category)this.forumService.getObjectNameById(categoryId, Utils.CATEGORY);
            boolean isAdd = true;
            if (!Utils.isEmpty((String[])cate.getUserPrivate())) {
                isAdd = ForumServiceUtils.hasPermission((String[])cate.getUserPrivate(), (String)this.userProfile.getUserId());
            }
            if (isAdd) {
                String[] canCreadTopic;
                if (!(this.userProfile.getUserRole() <= 1L && (this.userProfile.getUserRole() != 1L || ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)this.userProfile.getUserId())) || Utils.isEmpty((String[])(canCreadTopic = ForumUtils.arraysMerge((String[])forum.getCreateTopicRole(), (String[])cate.getCreateTopicRole()))) || canCreadTopic[0].equals(" "))) {
                    return ForumServiceUtils.hasPermission((String[])canCreadTopic, (String)this.userProfile.getUserId());
                }
                break block8;
            }
            return false;
        }
        return true;
    }

    public boolean checkForumHasAddPost(String categoryId, String forumId, String topicId) throws Exception {
        block11: {
            if (this.getUserProfile().getUserRole() == 0L) {
                return true;
            }
            if (this.getUserProfile().getUserId().contains("user_gest_uoom")) {
                return false;
            }
            Topic topic = (Topic)this.forumService.getObjectNameById(topicId, Utils.TOPIC);
            if (topic.getIsClosed() || topic.getIsLock()) {
                return false;
            }
            Forum forum = (Forum)this.forumService.getObjectNameById(forumId, Utils.FORUM);
            if (forum.getIsClosed() || forum.getIsLock()) {
                return false;
            }
            Category cate = (Category)this.forumService.getObjectNameById(categoryId, Utils.CATEGORY);
            boolean isAdd = true;
            if (!Utils.isEmpty((String[])cate.getUserPrivate())) {
                isAdd = ForumServiceUtils.hasPermission((String[])cate.getUserPrivate(), (String)this.userProfile.getUserId());
            }
            if (isAdd) {
                if (this.userProfile.getUserRole() > 1L || this.userProfile.getUserRole() == 1L && !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)this.userProfile.getUserId())) {
                    if (!topic.getIsActive() || !topic.getIsActiveByForum()) {
                        return false;
                    }
                    String[] canCreadPost = ForumUtils.arraysMerge((String[])cate.getCreateTopicRole(), (String[])ForumUtils.arraysMerge((String[])topic.getCanPost(), (String[])forum.getCreateTopicRole()));
                    if (!ForumUtils.isArrayEmpty((String[])canCreadPost)) {
                        return ForumServiceUtils.hasPermission((String[])canCreadPost, (String)this.userProfile.getUserId());
                    }
                }
                break block11;
            }
            return false;
        }
        return true;
    }

    public boolean checkCanView(Category cate, Forum forum, Topic topic) throws Exception {
        String userId = this.getUserProfile().getUserId();
        if (this.userProfile.getUserRole() == 0L) {
            return true;
        }
        List userBound = UserHelper.getAllGroupAndMembershipOfUser((String)userId);
        String[] viewer = cate.getUserPrivate();
        if (this.isArrayNotNull(viewer) && !Utils.hasPermission(Arrays.asList(viewer), (List)userBound)) {
            return false;
        }
        if (forum != null) {
            if (this.isArrayNotNull(forum.getModerators())) {
                if (Utils.hasPermission(Arrays.asList(forum.getModerators()), (List)userBound)) {
                    return true;
                }
            } else if (forum.getIsClosed()) {
                return false;
            }
        }
        if (topic != null) {
            List<String> list = new ArrayList();
            list = ForumUtils.addArrayToList(list, (String[])topic.getCanView());
            list = ForumUtils.addArrayToList(list, (String[])forum.getViewer());
            if (!(list = ForumUtils.addArrayToList(list, (String[])cate.getViewer())).isEmpty() && topic.getOwner() != null) {
                list.add(topic.getOwner());
            }
            if (topic.getIsClosed() || !topic.getIsActive() || !topic.getIsActiveByForum() || !topic.getIsApproved() || topic.getIsWaiting() || !list.isEmpty() && !Utils.hasPermission(list, (List)userBound)) {
                return false;
            }
        }
        return true;
    }

    public static void showWarningMessage(WebuiRequestContext context, String key, String ... args) {
        context.getUIApplication().addMessage(new ApplicationMessage(key, (Object[])args, 1));
    }

    public void calculateRenderComponent(String path, WebuiRequestContext context) throws Exception {
        block64: {
            ResourceBundle res = context.getApplicationResourceBundle();
            if (path.equals(Utils.FORUM_SERVICE)) {
                this.renderForumHome();
            } else if (path.indexOf(ForumUtils.FIELD_SEARCHFORUM_LABEL) >= 0) {
                this.updateIsRendered(ForumUtils.FIELD_SEARCHFORUM_LABEL);
                UISearchForm searchForm = (UISearchForm)this.getChild(UISearchForm.class);
                searchForm.setUserProfile(this.getUserProfile());
                searchForm.setPath(ForumUtils.EMPTY_STR);
                searchForm.setSelectType(path.replaceFirst(ForumUtils.FIELD_SEARCHFORUM_LABEL, ""));
                path = ForumUtils.FIELD_EXOFORUM_LABEL;
            } else if (path.lastIndexOf(Utils.TAG) >= 0) {
                this.updateIsRendered(ForumUtils.TAG);
                ((UIForumLinks)this.getChild(UIForumLinks.class)).setValueOption(ForumUtils.EMPTY_STR);
                ((UITopicsTag)this.getChild(UITopicsTag.class)).setIdTag(path);
            } else if (path.lastIndexOf(Utils.TOPIC) >= 0) {
                boolean isReply = false;
                boolean isQuote = false;
                if (path.indexOf("/true") > 0) {
                    isQuote = true;
                    path = path.replaceFirst("/true", ForumUtils.EMPTY_STR);
                } else if (path.indexOf("/false") > 0) {
                    isReply = true;
                    path = path.replaceFirst("/false", ForumUtils.EMPTY_STR);
                }
                if (path.indexOf(Utils.CATEGORY) > 0) {
                    path = path.substring(path.indexOf(Utils.CATEGORY));
                }
                String[] id = path.split(ForumUtils.SLASH);
                String postId = "top";
                int page = 0;
                if (path.indexOf(Utils.POST) > 0) {
                    postId = id[id.length - 1];
                    path = path.substring(0, path.lastIndexOf(ForumUtils.SLASH));
                    id = path.split(ForumUtils.SLASH);
                } else if (id.length > 1) {
                    block63: {
                        try {
                            page = Integer.parseInt(id[id.length - 1]);
                        }
                        catch (NumberFormatException e) {
                            if (!log.isDebugEnabled()) break block63;
                            log.debug((Object)("Failed to parse number " + id[id.length - 1]), (Throwable)e);
                        }
                    }
                    if (page > 0) {
                        path = path.replace(ForumUtils.SLASH + id[id.length - 1], ForumUtils.EMPTY_STR);
                        id = path.split(ForumUtils.SLASH);
                    } else {
                        page = 0;
                    }
                }
                try {
                    Topic topic = id.length > 1 ? this.forumService.getTopicByPath(path, false) : (Topic)this.forumService.getObjectNameById(path, Utils.TOPIC);
                    if (topic != null) {
                        Forum forum;
                        Category category;
                        if (path.indexOf(ForumUtils.SLASH) < 0) {
                            path = topic.getPath();
                            path = path.substring(path.indexOf(Utils.CATEGORY));
                            id = path.split(ForumUtils.SLASH);
                        }
                        if (this.checkCanView(category = this.forumService.getCategory(id[0]), forum = this.forumService.getForum(id[0], id[1]), topic)) {
                            this.updateIsRendered(ForumUtils.FORUM);
                            UIForumContainer uiForumContainer = (UIForumContainer)this.getChild(UIForumContainer.class);
                            UITopicDetailContainer uiTopicDetailContainer = (UITopicDetailContainer)uiForumContainer.getChild(UITopicDetailContainer.class);
                            uiForumContainer.setIsRenderChild(false);
                            ((UIForumDescription)uiForumContainer.getChild(UIForumDescription.class)).setForum(forum);
                            UITopicDetail uiTopicDetail = (UITopicDetail)uiTopicDetailContainer.getChild(UITopicDetail.class);
                            uiTopicDetail.setIsEditTopic(true);
                            uiTopicDetail.setUpdateForum(forum);
                            uiTopicDetail.initInfoTopic(id[0], id[1], topic, page);
                            ((UITopicPoll)uiTopicDetailContainer.getChild(UITopicPoll.class)).updateFormPoll(id[0], id[1], topic.getId());
                            ((UIForumLinks)this.getChild(UIForumLinks.class)).setValueOption(id[0] + ForumUtils.SLASH + id[1] + " ");
                            uiTopicDetail.setIdPostView(postId);
                            uiTopicDetail.setLastPostId(postId.equals("top") ? ForumUtils.EMPTY_STR : postId);
                            if (isReply || isQuote) {
                                if (uiTopicDetail.getCanPost()) {
                                    uiTopicDetail.setIdPostView("top");
                                    try {
                                        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
                                        UIPopupContainer popupContainer = (UIPopupContainer)popupAction.createUIComponent(UIPopupContainer.class, null, null);
                                        UIPostForm postForm = (UIPostForm)popupContainer.addChild(UIPostForm.class, null, null);
                                        boolean isMod = ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)this.userProfile.getUserId());
                                        postForm.setPostIds(id[0], id[1], topic.getId(), topic);
                                        postForm.setMod(isMod);
                                        if (isQuote) {
                                            Post post = this.forumService.getPost(id[0], id[1], topic.getId(), postId);
                                            if (post != null) {
                                                postForm.updatePost(postId, true, false, post);
                                                popupContainer.setId("UIQuoteContainer");
                                            } else {
                                                UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIBreadcumbs.msg.post-no-longer-exist", (String[])new String[]{ForumUtils.EMPTY_STR});
                                                uiTopicDetail.setIdPostView("normal");
                                            }
                                        } else {
                                            postForm.updatePost(ForumUtils.EMPTY_STR, false, false, null);
                                            popupContainer.setId("UIAddPostContainer");
                                        }
                                        popupAction.activate((UIComponent)popupContainer, 900, 500);
                                        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
                                    }
                                    catch (Exception e) {
                                        log.error((Object)e);
                                    }
                                } else {
                                    UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIPostForm.msg.no-permission", (String[])new String[]{ForumUtils.EMPTY_STR});
                                }
                            }
                            if (!UserHelper.isAnonim()) {
                                this.forumService.updateTopicAccess(this.userProfile.getUserId(), topic.getId());
                                this.getUserProfile().setLastTimeAccessTopic(topic.getId(), CommonUtils.getGreenwichMeanTime().getTimeInMillis());
                            }
                        } else {
                            UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIBreadcumbs.msg.do-not-permission", (String[])new String[]{topic.getTopicName(), res.getString("UIForumPortlet.label.topic").toLowerCase()});
                            if (!ForumUtils.isEmpty((String)this.getForumIdOfSpace())) {
                                this.calculateRenderComponent(this.forumSpId, context);
                            } else {
                                this.renderForumHome();
                                path = Utils.FORUM_SERVICE;
                            }
                        }
                    } else if (!ForumUtils.isEmpty((String)this.getForumIdOfSpace())) {
                        if (this.forumService.getForum(this.categorySpId, this.forumSpId) == null) {
                            this.forumSpDeleted = true;
                            this.removeAllChildPorletView();
                            log.info((Object)("The forum in space " + this.spaceDisplayName + " no longer exists."));
                            return;
                        }
                        UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIShowBookMarkForm.msg.link-not-found", (String[])new String[]{ForumUtils.EMPTY_STR});
                        this.calculateRenderComponent(this.forumSpId, context);
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed to render forum link: [" + path + "]. Forum home will be rendered.\nCaused by:"), (Throwable)e);
                    }
                    UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIShowBookMarkForm.msg.link-not-found", (String[])new String[]{ForumUtils.EMPTY_STR});
                    this.renderForumHome();
                    path = Utils.FORUM_SERVICE;
                }
            } else if (path.lastIndexOf(Utils.FORUM) == 0 && path.lastIndexOf(Utils.CATEGORY) < 0 || path.lastIndexOf(Utils.FORUM) > 0) {
                try {
                    Forum forum = null;
                    String cateId = null;
                    int page = 0;
                    if (path.indexOf(ForumUtils.SLASH) >= 0) {
                        String[] arr;
                        block65: {
                            arr = path.split(ForumUtils.SLASH);
                            try {
                                page = Integer.parseInt(arr[arr.length - 1]);
                            }
                            catch (Exception e) {
                                if (!log.isDebugEnabled()) break block65;
                                log.debug((Object)("Failed to parse number " + arr[arr.length - 1]), (Throwable)e);
                            }
                        }
                        if (arr[0].indexOf(Utils.CATEGORY) == 0) {
                            cateId = arr[0];
                            forum = this.forumService.getForum(cateId, arr[1]);
                        } else {
                            forum = (Forum)this.forumService.getObjectNameById(arr[0], Utils.FORUM);
                        }
                    }
                    if (forum == null) {
                        forum = (Forum)this.forumService.getObjectNameById(path, Utils.FORUM);
                        if (forum == null && path.equals(this.getForumIdOfSpace())) {
                            forum = this.forumService.getForum(this.categorySpId, path);
                        }
                        if (forum == null) {
                            this.forumSpDeleted = true;
                            this.removeAllChildPorletView();
                            log.info((Object)("The forum in space " + this.spaceDisplayName + " no longer exists."));
                            return;
                        }
                    }
                    path = forum.getPath();
                    if (cateId == null) {
                        cateId = path.substring(path.indexOf(Utils.CATEGORY), path.lastIndexOf(Utils.FORUM) - 1);
                    }
                    path = path.substring(path.indexOf(Utils.CATEGORY));
                    Category category = this.forumService.getCategory(cateId);
                    if (this.checkCanView(category, forum, null)) {
                        this.updateIsRendered(ForumUtils.FORUM);
                        UIForumContainer forumContainer = (UIForumContainer)this.findFirstComponentOfType(UIForumContainer.class);
                        forumContainer.setIsRenderChild(true);
                        ((UIForumDescription)forumContainer.getChild(UIForumDescription.class)).setForum(forum);
                        ((UITopicContainer)forumContainer.getChild(UITopicContainer.class)).setUpdateForum(cateId, forum, page);
                        break block64;
                    }
                    UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIBreadcumbs.msg.do-not-permission", (String[])new String[]{forum.getForumName(), res.getString("UIForumPortlet.label.forum").toLowerCase()});
                    this.renderForumHome();
                    path = Utils.FORUM_SERVICE;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed to render forum link: [" + path + "]. Forum home will be rendered.\nCaused by:"), (Throwable)e);
                    }
                    UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIShowBookMarkForm.msg.link-not-found", (String[])new String[]{res.getString("UIForumPortlet.label.forum")});
                    this.renderForumHome();
                    path = Utils.FORUM_SERVICE;
                }
            } else if (path.indexOf(Utils.CATEGORY) >= 0 && path.indexOf(ForumUtils.SLASH) < 0) {
                UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                try {
                    Category category = this.forumService.getCategory(path);
                    if (this.checkCanView(category, null, null)) {
                        ((UICategory)categoryContainer.getChild(UICategory.class)).updateByLink(category);
                        categoryContainer.updateIsRender(false);
                        this.updateIsRendered(ForumUtils.CATEGORIES);
                        break block64;
                    }
                    UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIBreadcumbs.msg.do-not-permission", (String[])new String[]{category.getCategoryName(), res.getString("UIForumPortlet.label.category").toLowerCase()});
                    this.renderForumHome();
                    path = Utils.FORUM_SERVICE;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed to render forum link: [" + path + "]. Forum home will be rendered.\nCaused by:"), (Throwable)e);
                    }
                    UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIShowBookMarkForm.msg.link-not-found", (String[])new String[]{ForumUtils.EMPTY_STR});
                    this.renderForumHome();
                    path = Utils.FORUM_SERVICE;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to render forum link: [" + path + "]. Forum home will be rendered."));
                }
                UIForumPortlet.showWarningMessage((WebuiRequestContext)context, (String)"UIShowBookMarkForm.msg.link-not-found", (String[])new String[]{ForumUtils.EMPTY_STR});
                this.renderForumHome();
                path = Utils.FORUM_SERVICE;
            }
        }
        ((UIBreadcumbs)this.getChild(UIBreadcumbs.class)).setUpdataPath(path);
        ((UIForumLinks)this.getChild(UIForumLinks.class)).setValueOption(path);
    }

    static /* synthetic */ UserProfile access$000(UIForumPortlet x0) {
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$100(UIForumPortlet x0) {
        return x0.forumService;
    }

    static /* synthetic */ Log access$200() {
        return log;
    }
}

