/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.SettingPortletPreference;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ForumUtils {
    protected static Log log = ExoLogger.getLogger(ForumUtils.class);
    public static final String FIELD_EXOFORUM_LABEL = "eXoForum".intern();
    public static final String FIELD_SEARCHFORUM_LABEL = "SearchForum".intern();
    public static final String UPLOAD_FILE_SIZE = "uploadFileSizeLimitMB".intern();
    public static final String UPLOAD_AVATAR_SIZE = "uploadAvatarSizeLimitMB".intern();
    public static final String SEARCHFORM_ID = "SearchForm".intern();
    public static final String GOPAGE_ID_T = "goPageTop".intern();
    public static final String GOPAGE_ID_B = "goPageBottom".intern();
    public static final String CATEGORIES = "Categories".intern();
    public static final String CATEGORY = "category".intern();
    public static final String FORUM = "forum".intern();
    public static final String TOPIC = "topic".intern();
    public static final String POST = "post".intern();
    public static final String TAG = "Tag".intern();
    public static final String POLL = "Poll".intern();
    public static final String COMMA = ",".intern();
    public static final String SLASH = "/".intern();
    public static final String EMPTY_STR = "".intern();
    public static final String SPACE_GROUP_ID = "/spaces".replace(SLASH, EMPTY_STR);
    public static final int MAXSIGNATURE = 300;
    public static final int MAXTITLE = 100;
    public static final int DEFAULT_VALUE_UPLOAD_PORTAL = -1;
    public static final long MAXMESSAGE = 10000L;

    private static String buildForumLink(String url, String type, String id) {
        StringBuilder link = new StringBuilder(url);
        if (!ForumUtils.isEmpty((String)type) && !ForumUtils.isEmpty((String)id)) {
            if (link.lastIndexOf(SLASH) == link.length() - 1) {
                link.append(type);
            } else {
                link.append(SLASH).append(type);
            }
            if (!id.equals(Utils.FORUM_SERVICE)) {
                link.append(SLASH).append(id);
            }
        }
        return link.toString();
    }

    public static String createdForumLink(String type, String id, boolean isPrivate) throws Exception {
        String containerName = ((ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class)).getPortalContainerName();
        String pageNodeSelected = Util.getUIPortal().getSelectedUserNode().getURI();
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String fullUrl = portalContext.getRequest().getRequestURL().toString();
        String host = fullUrl.substring(0, fullUrl.indexOf(containerName) - 1);
        return ForumUtils.buildLink((String)(host + portalContext.getPortalURI()), (String)containerName, (String)pageNodeSelected, (String)type, (String)id, (boolean)isPrivate);
    }

    public static String buildLink(String portalURI, String containerName, String selectedNode, String type, String id, boolean isPrivate) {
        StringBuilder sb = new StringBuilder();
        portalURI = portalURI.concat(selectedNode).concat(SLASH);
        if (!isPrivate) {
            sb.append(ForumUtils.buildForumLink((String)portalURI, (String)type, (String)id));
        } else {
            String host = portalURI.substring(0, portalURI.indexOf(containerName) - 1);
            sb.append(host).append(SLASH).append(containerName).append(SLASH).append("login?&initialURI=").append(ForumUtils.buildForumLink((String)portalURI.replaceFirst(host, EMPTY_STR), (String)type, (String)id)).toString();
        }
        return sb.toString();
    }

    public static boolean isValidEmailAddresses(String addressList) {
        if (ForumUtils.isEmpty((String)addressList)) {
            return true;
        }
        addressList = StringUtils.remove((String)addressList, (String)" ");
        addressList = StringUtils.replace((String)addressList, (String)";", (String)COMMA);
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().matches(emailRegex)) continue;
                return false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    public static String getSizeFile(long size) {
        String sizeStr = String.valueOf(size);
        String unit = " Byte";
        if (size >= 1024L) {
            DecimalFormat df = new DecimalFormat("#,###.#", new DecimalFormatSymbols(Locale.ENGLISH));
            double convertedSize = (double)size / 1024.0;
            unit = " Kb";
            if (convertedSize >= 1024.0) {
                convertedSize /= 1024.0;
                unit = " Mb";
            }
            sizeStr = df.format(convertedSize);
        }
        return sizeStr + unit;
    }

    public static String getTimeZoneNumberInString(String string) {
        if (!ForumUtils.isEmpty((String)string)) {
            int c;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length() && (c = string.charAt(i)) != 41; ++i) {
                if (!Character.isDigit((char)c) && c != 45 && c != 43 && c != 58) continue;
                if (c == 58) {
                    c = 46;
                }
                if (c == 51 && string.charAt(i - 1) == ':') {
                    c = 53;
                }
                stringBuffer.append((char)c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String[] getStarNumber(double voteRating) {
        int star = (int)voteRating;
        String[] className = new String[6];
        float k = 0.0f;
        for (int i = 0; i < 5; ++i) {
            if (i < star) {
                className[i] = "star";
            } else if (i == star) {
                k = (float)(voteRating - (double)i);
                if ((double)k < 0.25) {
                    className[i] = "notStar";
                }
                if ((double)k >= 0.25 && (double)k < 0.75) {
                    className[i] = "halfStar";
                }
                if ((double)k >= 0.75) {
                    className[i] = "star";
                }
            } else {
                className[i] = "notStar";
            }
            className[5] = String.valueOf(voteRating);
            if (className[5].length() >= 3) {
                className[5] = className[5].substring(0, 3);
            }
            if (k != 0.0f) continue;
            className[5] = String.valueOf(star);
        }
        return className;
    }

    public static String getOrderBy(String strOrderBy, String param) {
        strOrderBy = !ForumUtils.isEmpty((String)strOrderBy) ? (strOrderBy.indexOf(param) >= 0 ? (strOrderBy.indexOf("descending") > 0 ? param + " ascending" : param + " descending") : param + " ascending") : param + " ascending";
        return strOrderBy;
    }

    public static String updateMultiValues(String value, String values) {
        if (!ForumUtils.isEmpty((String)values)) {
            if (!ForumUtils.isStringInStrings((String[])(values = ForumUtils.removeSpaceInString((String)values)).split(COMMA), (String)value)) {
                if (values.lastIndexOf(COMMA) != values.length() - 1) {
                    values = values + COMMA;
                }
                values = values + value;
            }
        } else {
            values = value;
        }
        return ForumUtils.removeStringResemble((String)values);
    }

    public static String[] getCensoredKeyword(ForumService forumService) throws Exception {
        ForumAdministration forumAdministration = forumService.getForumAdministration();
        return ForumUtils.getCensoredKeyword((String)forumAdministration.getCensoredKeyword());
    }

    public static String[] getCensoredKeyword(String stringKey) {
        if (!ForumUtils.isEmpty((String)stringKey)) {
            String str = EMPTY_STR;
            while (!stringKey.equals(str)) {
                str = stringKey;
                if ((stringKey = stringKey.toLowerCase().replaceAll(";", COMMA).replaceAll(COMMA + " ", COMMA).replaceAll(" " + COMMA, COMMA).replaceAll(COMMA + COMMA, COMMA)).indexOf(COMMA) != 0) continue;
                stringKey = stringKey.replaceFirst(COMMA, EMPTY_STR);
            }
            return stringKey.trim().split(COMMA);
        }
        return new String[0];
    }

    public static String[] splitForForum(String str) {
        if (!ForumUtils.isEmpty((String)str)) {
            if ((str = StringUtils.remove((String)str, (String)" ")).contains(COMMA)) {
                str = str.replaceAll(";", COMMA);
                return str.trim().split(COMMA);
            }
            str = str.replaceAll(COMMA, ";");
            return str.trim().split(";");
        }
        return new String[]{EMPTY_STR};
    }

    public static String unSplitForForum(String[] str) {
        if (str == null || str.length == 0) {
            return EMPTY_STR;
        }
        StringBuilder rtn = new StringBuilder();
        if (!str[0].equals(" ")) {
            for (String temp : str) {
                if (rtn.length() > 1) {
                    rtn.append(COMMA).append(temp.trim());
                    continue;
                }
                rtn.append(temp.trim());
            }
        }
        return rtn.toString();
    }

    public static String removeSpaceInString(String str) {
        if (!ForumUtils.isEmpty((String)str)) {
            String[] strs = new String[]{";", COMMA + " ", " " + COMMA, COMMA + COMMA};
            for (int i = 0; i < strs.length; ++i) {
                while (str.indexOf(strs[i]) >= 0) {
                    str = str.replaceAll(strs[i], COMMA);
                }
            }
            if (str.lastIndexOf(COMMA) == str.length() - 1) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.indexOf(COMMA) == 0) {
                str = str.substring(1, str.length());
            }
            return str;
        }
        return EMPTY_STR;
    }

    public static String removeZeroFirstNumber(String str) {
        if (!ForumUtils.isEmpty((String)str)) {
            str = str.trim();
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i + 1 < str.length() && (str.charAt(i) == '0' || str.charAt(i) == ' ')) {
                s.append(str.charAt(i));
                ++i;
            }
            str = str.replaceFirst(s.toString(), EMPTY_STR);
        }
        return str;
    }

    public static String removeStringResemble(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)s)) {
            String[] temp = ForumUtils.splitForForum((String)s);
            StringBuilder builder = new StringBuilder();
            int l = temp.length;
            for (int i = 0; i < l; ++i) {
                if (list.contains(temp[i]) || temp[i].trim().length() == 0) continue;
                list.add(temp[i]);
                if (i == l - 1) {
                    builder.append(temp[i]);
                    continue;
                }
                builder.append(temp[i]).append(COMMA);
            }
            return builder.toString();
        }
        return EMPTY_STR;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isArrayEmpty(String[] strs) {
        return strs == null || strs.length == 0 || strs.length == 1 && strs[0].trim().length() <= 0;
    }

    public static String[] addStringToString(String input, String output) {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)output) && !ForumUtils.isEmpty((String)input)) {
            String[] temp;
            if (input.lastIndexOf(COMMA) != input.length() - 1) {
                input = input + COMMA;
            }
            output = input + output;
            for (String string : temp = ForumUtils.splitForForum((String)output)) {
                if (list.contains(string) || string.length() == 0) continue;
                list.add(string);
            }
        }
        if (list.size() == 0) {
            list.add(" ");
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] arraysMerge(String[] strs1, String[] strs2) {
        int i;
        if (ForumUtils.isArrayEmpty((String[])strs1)) {
            return strs2;
        }
        if (ForumUtils.isArrayEmpty((String[])strs2)) {
            return strs1;
        }
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < strs1.length; ++i) {
            set.add(strs1[i]);
        }
        for (i = 0; i < strs2.length; ++i) {
            set.add(strs2[i]);
        }
        return set.toArray(new String[set.size()]);
    }

    public static boolean isStringInStrings(String[] strings, String string) {
        if (ForumUtils.isEmpty((String)string)) {
            return false;
        }
        if (ForumUtils.isArrayEmpty((String[])strings)) {
            return false;
        }
        return ForumUtils.isStringInList(Arrays.asList(strings), (String)string.trim());
    }

    public static boolean isStringInList(List<String> list, String string) {
        for (String str : list) {
            if (!str.trim().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!ForumUtils.isEmpty((String)str) && (l = str.length()) > max) {
            int space = (str = str.substring(0, max)).lastIndexOf(" ");
            str = space > max - 6 ? str.substring(0, space) + "..." : str + "...";
        }
        return str;
    }

    public static List<String> addArrayToList(List<String> list, String[] array) {
        if (array == null) {
            return list;
        }
        if (list.isEmpty() && !ForumUtils.isArrayEmpty((String[])array)) {
            list.addAll(Arrays.asList(array));
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null || list.contains(array[i]) || array[i].trim().length() <= 0) continue;
                list.add(array[i]);
            }
        }
        return list;
    }

    public static String getLabel(String label, String key) {
        if (ForumUtils.isEmpty((String)key)) {
            key = " ";
        }
        try {
            return label.replaceFirst("<keyWord>", key);
        }
        catch (Exception e) {
            String s = label.substring(0, label.indexOf("<keyWord>") - 1);
            return s + "'" + key + "'" + label.substring(label.indexOf("<keyWord>"));
        }
    }

    public static String[] getColor() {
        return new String[]{"blue", "DarkGoldenRod", "green", "yellow", "BlueViolet", "orange", "darkBlue", "IndianRed", "DarkCyan", "lawnGreen"};
    }

    public static MessageBuilder getDefaultMail() {
        MessageBuilder messageBuilder = new MessageBuilder();
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            messageBuilder.setContent(res.getString("UINotificationForm.label.notifyEmailContentDefault"));
            String header = res.getString("UINotificationForm.label.notifyEmailHeaderSubjectDefault");
            messageBuilder.setHeaderSubject(ForumUtils.isEmpty((String)header) ? EMPTY_STR : header);
            messageBuilder.setTypes(res.getString("UIForumPortlet.label.category"), res.getString("UIForumPortlet.label.forum"), res.getString("UIForumPortlet.label.topic"), res.getString("UIForumPortlet.label.post"));
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get resource bundle for default content email notification !", (Throwable)e);
        }
        return messageBuilder;
    }

    public static boolean enableIPLogging() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", EMPTY_STR));
    }

    public static void savePortletPreference(String listCategoryId, String listForumId) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        portletPref.setValue("invisibleCategories", listCategoryId);
        portletPref.setValue("invisibleForums", listForumId);
        portletPref.store();
    }

    public static SettingPortletPreference getPorletPreference() {
        SettingPortletPreference preference = new SettingPortletPreference();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        preference.setShowForumActionBar(Boolean.parseBoolean(portletPref.getValue("showForumActionBar", EMPTY_STR)));
        preference.setForumNewPost(Integer.parseInt(portletPref.getValue("forumNewPost", EMPTY_STR)));
        preference.setUseAjax(Boolean.parseBoolean(portletPref.getValue("useAjax", EMPTY_STR)));
        preference.setEnableIPLogging(Boolean.parseBoolean(portletPref.getValue("enableIPLogging", EMPTY_STR)));
        preference.setEnableIPFiltering(Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", EMPTY_STR)));
        preference.setInvisibleCategories(ForumUtils.getListInValus((String)portletPref.getValue("invisibleCategories", EMPTY_STR)));
        preference.setInvisibleForums(ForumUtils.getListInValus((String)portletPref.getValue("invisibleForums", EMPTY_STR)));
        preference.setShowForumJump(Boolean.parseBoolean(portletPref.getValue("isShowForumJump", EMPTY_STR)));
        preference.setShowIconsLegend(Boolean.parseBoolean(portletPref.getValue("isShowIconsLegend", EMPTY_STR)));
        preference.setShowModerators(Boolean.parseBoolean(portletPref.getValue("isShowModerators", EMPTY_STR)));
        preference.setShowPoll(Boolean.parseBoolean(portletPref.getValue("isShowPoll", EMPTY_STR)));
        preference.setShowQuickReply(Boolean.parseBoolean(portletPref.getValue("isShowQuickReply", EMPTY_STR)));
        preference.setShowRules(Boolean.parseBoolean(portletPref.getValue("isShowRules", EMPTY_STR)));
        preference.setShowStatistics(Boolean.parseBoolean(portletPref.getValue("isShowStatistics", EMPTY_STR)));
        return preference;
    }

    public static void savePortletPreference(SettingPortletPreference sPreference) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String listForumId = EMPTY_STR;
        String listCategoryId = EMPTY_STR;
        List invisibleForums = sPreference.getInvisibleForums();
        List invisibleCategories = sPreference.getInvisibleCategories();
        if (!invisibleCategories.isEmpty()) {
            listForumId = invisibleForums.toString().replace('[' + EMPTY_STR, EMPTY_STR).replace(']' + EMPTY_STR, EMPTY_STR).replaceAll(" ", EMPTY_STR);
            listCategoryId = invisibleCategories.toString().replace('[' + EMPTY_STR, EMPTY_STR).replace(']' + EMPTY_STR, EMPTY_STR).replaceAll(" ", EMPTY_STR);
        }
        portletPref.setValue("isShowForumJump", sPreference.isShowForumJump() + EMPTY_STR);
        portletPref.setValue("isShowIconsLegend", sPreference.isShowIconsLegend() + EMPTY_STR);
        portletPref.setValue("isShowModerators", sPreference.isShowModerators() + EMPTY_STR);
        portletPref.setValue("isShowPoll", sPreference.isShowPoll() + EMPTY_STR);
        portletPref.setValue("isShowQuickReply", sPreference.isShowQuickReply() + EMPTY_STR);
        portletPref.setValue("isShowRules", sPreference.isShowRules() + EMPTY_STR);
        portletPref.setValue("isShowStatistics", sPreference.isShowStatistics() + EMPTY_STR);
        portletPref.setValue("useAjax", sPreference.isUseAjax() + EMPTY_STR);
        portletPref.setValue("invisibleCategories", listCategoryId);
        portletPref.setValue("invisibleForums", listForumId);
        portletPref.store();
    }

    public static boolean isAjaxRequest() {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        return portalContext.useAjax();
    }

    public static List<String> getListInValus(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    public static int getLimitUploadSize(boolean isAvatar) {
        int limitMB;
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            limitMB = isAvatar ? Integer.parseInt(portletPref.getValue(UPLOAD_AVATAR_SIZE, EMPTY_STR).trim()) : Integer.parseInt(portletPref.getValue(UPLOAD_FILE_SIZE, EMPTY_STR).trim());
        }
        catch (NumberFormatException e) {
            limitMB = -1;
        }
        return limitMB;
    }

    public static String getCalculateListEmail(String s) throws Exception {
        String[] strs = ForumUtils.splitForForum((String)s);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (ForumUtils.isEmpty((String)strs[i])) continue;
            if (i > 0) {
                builder.append(",<br/>");
            }
            builder.append("<span title='").append(strs[i]).append("'>").append(ForumUtils.getSubString((String)strs[i], (int)15)).append("</span>");
        }
        return builder.toString();
    }
}

