/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.TransformHTML;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicsTag.gtmpl", events={@EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={RemoveTopicActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UITopicsTag
extends UIForumKeepStickPageIterator {
    private String tagId = ForumUtils.EMPTY_STR;
    private Tag tag;
    private boolean isUpdateTag = true;
    private String strOrderBy = ForumUtils.EMPTY_STR;
    private String userIdAndtagId;
    private List<Topic> topics = new ArrayList();
    private Map<String, Long> mapNumberPagePost = new HashMap();

    public void setIdTag(String tagId) throws Exception {
        this.tagId = tagId;
        this.isUpdateTag = true;
        this.mapNumberPagePost.clear();
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        this.userIdAndtagId = !this.userProfile.getUserId().equals("user_gest_uoom") ? this.userProfile.getUserId() + ":" + tagId : tagId;
    }

    protected String getActionViewInfoUser(String linkType, String userName) {
        return ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getPortletLink(linkType, userName);
    }

    public void setTag(Tag tag, String userIdAndtagId) throws Exception {
        this.tag = tag;
        this.tagId = tag.getId();
        this.isUpdateTag = false;
        this.mapNumberPagePost.clear();
        this.userIdAndtagId = userIdAndtagId;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
    }

    public String getRSSLink(String cateId) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return CommonUtils.getRSSLink((String)"forum", (String)pcontainer.getPortalContainerInfo().getContainerName(), (String)cateId);
    }

    protected String getTitleInHTMLCode(String s) {
        return TransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    protected long getSizePost(String Id) throws Exception {
        if (this.mapNumberPagePost.containsKey(Id)) {
            return (Long)this.mapNumberPagePost.get(Id);
        }
        String[] Ids = Id.split(ForumUtils.SLASH);
        Topic topic = this.getTopic(Ids[Ids.length - 1]);
        long maxPost = this.getUserProfile().getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        if (topic != null && topic.getPostCount() > maxPost) {
            long availablePost;
            long value;
            String isApprove = ForumUtils.EMPTY_STR;
            String isHidden = ForumUtils.EMPTY_STR;
            String userLogin = this.userProfile.getUserId();
            long role = this.userProfile.getUserRole();
            if (role >= 2L) {
                isHidden = "false";
            }
            Forum forum = this.getForumService().getForum(Ids[Ids.length - 3], Ids[Ids.length - 2]);
            if (role == 1L && !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)userLogin)) {
                isHidden = "false";
            }
            if ((forum.getIsModeratePost() || topic.getIsModeratePost()) && isHidden.equals("false") && !topic.getOwner().equals(userLogin)) {
                isApprove = "true";
            }
            if ((value = (availablePost = this.getForumService().getAvailablePost(Ids[Ids.length - 3], Ids[Ids.length - 2], Ids[Ids.length - 1], isApprove, isHidden, userLogin)) / maxPost) * maxPost < availablePost) {
                ++value;
            }
            this.mapNumberPagePost.put(Id, value);
            return value;
        }
        this.mapNumberPagePost.put(Id, 1L);
        return 1L;
    }

    protected List<Topic> getTopicsTag() throws Exception {
        this.pageList = this.getForumService().getTopicByMyTag(this.userIdAndtagId, this.strOrderBy);
        int maxTopic = (int)this.userProfile.getMaxTopicInPage();
        if (maxTopic <= 0) {
            maxTopic = 10;
        }
        this.pageList.setPageSize(maxTopic);
        this.maxPage = this.pageList.getAvailablePage();
        this.topics = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.topics == null) {
            this.topics = new ArrayList();
        }
        for (Topic topic : this.topics) {
            if (this.getUICheckBoxInput(topic.getId()) != null) {
                this.getUICheckBoxInput(topic.getId()).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UICheckBoxInput(topic.getId(), topic.getId(), Boolean.valueOf(false)));
        }
        if (this.topics.size() > 0) {
            this.setListWatches();
        }
        return this.topics;
    }

    private Tag getTagById() throws Exception {
        if (this.isUpdateTag) {
            this.tag = this.getForumService().getTag(this.tagId);
            this.isUpdateTag = false;
        }
        return this.tag;
    }

    protected String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    private Topic getTopic(String topicId) throws Exception {
        for (Topic topic : this.topics) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return (Topic)this.getForumService().getObjectNameById(topicId, Utils.TOPIC);
    }

    private Forum getForum(String categoryId, String forumId) throws Exception {
        return this.getForumService().getForum(categoryId, forumId);
    }

    static /* synthetic */ Topic access$000(UITopicsTag x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ Forum access$100(UITopicsTag x0, String x1, String x2) throws Exception {
        return x0.getForum(x1, x2);
    }

    static /* synthetic */ String access$200(UITopicsTag x0) {
        return x0.tagId;
    }

    static /* synthetic */ Log access$300(UITopicsTag x0) {
        return x0.log;
    }

    static /* synthetic */ boolean access$402(UITopicsTag x0, boolean x1) {
        x0.isUpdateTag = x1;
        return x0.isUpdateTag;
    }

    static /* synthetic */ Tag access$500(UITopicsTag x0) throws Exception {
        return x0.getTagById();
    }

    static /* synthetic */ String access$602(UITopicsTag x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$600(UITopicsTag x0) {
        return x0.strOrderBy;
    }
}

