/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.ks.common.user.ContactProvider;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ForumSessionUtils {
    private static final Log LOG = ExoLogger.getLogger(ForumSessionUtils.class);
    public static final String DEFAULT_AVATAR = "/forum/skin/DefaultSkin/webui/background/Avatar1.gif";

    public static String getUserAvatarURL(String userName, ForumService forumService) {
        String url;
        block4: {
            url = null;
            try {
                ForumAttachment attachment = forumService.getUserAvatar(userName);
                url = CommonUtils.getImageUrl((String)attachment.getPath()) + "?size=" + attachment.getSize();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)String.format("can not load avatar of [%s] as file resource", userName), (Throwable)e);
            }
        }
        if (url == null || url.trim().length() < 1) {
            CommonContact contact = ForumSessionUtils.getPersonalContact((String)userName);
            if (!ForumUtils.isEmpty((String)contact.getAvatarUrl())) {
                url = contact.getAvatarUrl();
            }
            url = url == null || url.trim().length() < 1 ? "/forum/skin/DefaultSkin/webui/background/Avatar1.gif" : url;
        }
        return url;
    }

    public static String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public static CommonContact getPersonalContact(String userId) {
        try {
            if (userId.indexOf(Utils.DELETED) > 0) {
                return new CommonContact();
            }
            ContactProvider provider = (ContactProvider)PortalContainer.getComponent(ContactProvider.class);
            return provider.getCommonContact(userId);
        }
        catch (Exception e) {
            return new CommonContact();
        }
    }

    public static String getBreadcumbUrl(String link, String componentName, String actionName, String objectId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String url = portalContext.getRequest().getRequestURL().toString();
        url = url.substring(0, url.indexOf(ForumUtils.SLASH, 8));
        link = link.replaceFirst(componentName, "UIBreadcumbs").replaceFirst(actionName, "ChangePath").replace("pathId", objectId).replaceAll("&amp;", "&");
        return url + link;
    }

    public static List<String> getGroupIdInSpaceOfUser(String userId) throws Exception {
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Object group : UserHelper.getOrganizationService().getGroupHandler().findGroupsOfUser(userId)) {
            if (((Group)group).getId().indexOf(ForumUtils.SPACE_GROUP_ID) < 0) continue;
            groupIds.add(((Group)group).getGroupName());
        }
        return groupIds;
    }

    public static String getQueryForumInSpace(String userId) throws Exception {
        if (!ForumUtils.isEmpty((String)userId)) {
            StringBuilder builder = new StringBuilder();
            for (String groupId : ForumSessionUtils.getGroupIdInSpaceOfUser((String)userId)) {
                if (builder.length() > 0) {
                    builder.append(" or ");
                }
                builder.append("(jcr:like(@").append("exo:id").append(",'%").append(groupId).append("%'))");
            }
            return builder.toString();
        }
        return ForumUtils.EMPTY_STR;
    }
}

