/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UIQuickSearchForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={ChangePathActionListener.class}), @EventConfig(listeners={AccountSettingsActionListener.class}), @EventConfig(listeners={RssActionListener.class})})
public class UIBreadcumbs
extends UIContainer {
    private static Log log = ExoLogger.getExoLogger(UIBreadcumbs.class);
    protected boolean useAjax = true;
    private ForumService forumService;
    private List<String> breadcumbs_ = new ArrayList();
    private List<String> path_ = new ArrayList();
    private String QUICK_SEARCH = "QuickSearchForm";
    public static final String FORUM_SERVICE = Utils.FORUM_SERVICE;
    private boolean isLink = false;
    private boolean isOpen = true;
    private String tooltipLink = Utils.FORUM_SERVICE;

    public UIBreadcumbs() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
        this.path_.add(FORUM_SERVICE);
        this.addChild(UIQuickSearchForm.class, null, this.QUICK_SEARCH);
    }

    protected void setIsUseAjax() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.useAjax = forumPortlet.isUseAjax();
    }

    protected UserProfile getUserProfile() {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        return forumPortlet.getUserProfile();
    }

    public void setUpdataPath(String path) throws Exception {
        this.isLink = false;
        this.setRenderForumLink(path);
        String tempPath = ForumUtils.EMPTY_STR;
        String frspId = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getForumIdOfSpace();
        if (!ForumUtils.isEmpty((String)frspId)) {
            String[] temp;
            this.path_.clear();
            this.breadcumbs_.clear();
            for (String string : temp = path.split(ForumUtils.SLASH)) {
                Object obj = this.forumService.getObjectNameByPath(tempPath = !ForumUtils.isEmpty((String)tempPath) ? tempPath + ForumUtils.SLASH + string : string);
                if (obj instanceof Forum) {
                    this.addBreadcumbs(tempPath, ((Forum)obj).getForumName(), ForumUtils.FORUM);
                    continue;
                }
                if (obj instanceof Topic) {
                    this.addBreadcumbs(tempPath, ((Topic)obj).getTopicName(), ForumUtils.TOPIC);
                    continue;
                }
                if (!(obj instanceof Tag)) continue;
                Forum forum = (Forum)this.forumService.getObjectNameById(frspId, Utils.FORUM);
                this.addBreadcumbs(forum.getCategoryId() + ForumUtils.SLASH + forum.getId(), forum.getForumName(), ForumUtils.FORUM);
                this.addBreadcumbs(tempPath, ((Tag)obj).getName(), ForumUtils.TAG);
            }
        } else if (!ForumUtils.isEmpty((String)path) && !path.equals(FORUM_SERVICE)) {
            String[] temp = path.split(ForumUtils.SLASH);
            if (path.indexOf(ForumUtils.FIELD_EXOFORUM_LABEL) >= 0) {
                if (!ForumUtils.FIELD_EXOFORUM_LABEL.equals(path)) {
                    this.clearBreadcumbs();
                }
                if (!this.breadcumbs_.contains(ForumUtils.FIELD_SEARCHFORUM_LABEL)) {
                    this.addBreadcumbs(ForumUtils.SLASH + ForumUtils.FIELD_EXOFORUM_LABEL, ForumUtils.FIELD_SEARCHFORUM_LABEL, "");
                }
            } else {
                this.clearBreadcumbs();
                int i = 0;
                try {
                    for (String string : temp) {
                        Object obj = this.forumService.getObjectNameByPath(tempPath = !ForumUtils.isEmpty((String)tempPath) ? tempPath + ForumUtils.SLASH + string : string);
                        if (obj == null) {
                            if (i != 0) break;
                            this.isLink = true;
                        }
                        if (obj instanceof Category) {
                            tempPath = string;
                            this.addBreadcumbs(tempPath, ((Category)obj).getCategoryName(), ForumUtils.CATEGORY);
                        } else if (obj instanceof Forum) {
                            this.addBreadcumbs(tempPath, ((Forum)obj).getForumName(), ForumUtils.FORUM);
                        } else if (obj instanceof Topic) {
                            this.addBreadcumbs(tempPath, ((Topic)obj).getTopicName(), ForumUtils.TOPIC);
                        } else if (obj instanceof Tag) {
                            this.addBreadcumbs(tempPath, ((Tag)obj).getName(), ForumUtils.TAG);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)String.format("Failed to find object with path %s", path), (Throwable)e);
                }
            }
        } else {
            this.clearBreadcumbs();
        }
    }

    private void clearBreadcumbs() {
        this.path_.clear();
        this.breadcumbs_.clear();
        this.addBreadcumbs(FORUM_SERVICE, ForumUtils.FIELD_EXOFORUM_LABEL, FORUM_SERVICE);
    }

    private void addBreadcumbs(String path, String breadcumb, String tooltipLink) {
        this.path_.add(path);
        this.breadcumbs_.add(breadcumb);
        this.tooltipLink = tooltipLink;
    }

    private void setRenderForumLink(String path) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletSession portletSession = pcontext.getRequest().getPortletSession();
        ActionResponse actionRes = null;
        if (pcontext.getResponse() instanceof ActionResponse) {
            actionRes = (ActionResponse)pcontext.getResponse();
        }
        ForumParameter param = new ForumParameter();
        if (this.getUserProfile().getIsShowForumJump() && !FORUM_SERVICE.equals(path)) {
            if (path.indexOf(Utils.TOPIC) > 0) {
                path = path.substring(0, path.lastIndexOf(ForumUtils.SLASH));
            }
            param.setRenderForumLink(true);
            param.setPath(path);
        } else {
            param.setRenderForumLink(false);
        }
        if (actionRes != null) {
            actionRes.setEvent(new QName("ForumLinkEvent"), (Serializable)param);
        } else {
            portletSession.setAttribute(UIForumPortlet.FORUM_LINK_EVENT_PARAMS, (Object)param, 1);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    protected String getToolTip() {
        return this.tooltipLink;
    }

    protected boolean isLink() {
        return this.isLink;
    }

    public String getLastPath() {
        if (this.path_.size() > 0) {
            String str = (String)this.path_.get(this.path_.size() - 1);
            return (ForumUtils.SLASH + ForumUtils.FIELD_EXOFORUM_LABEL).equals(str) ? Utils.FORUM_SERVICE : str;
        }
        return Utils.FORUM_SERVICE;
    }

    protected String getPath(int index) {
        return (String)this.path_.get(index);
    }

    protected int getMaxPath() {
        return this.breadcumbs_.size();
    }

    protected List<String> getBreadcumbs() throws Exception {
        return new ArrayList<String>(this.breadcumbs_);
    }

    protected String getType(String id) {
        return id.indexOf(Utils.FORUM_SERVICE) >= 0 ? Utils.FORUM_SERVICE : (id.indexOf(Utils.CATEGORY) >= 0 ? ForumUtils.CATEGORY : (id.indexOf(Utils.FORUM) >= 0 ? ForumUtils.FORUM : (id.indexOf(Utils.TOPIC) >= 0 ? ForumUtils.TOPIC : ForumUtils.EMPTY_STR)));
    }

    protected boolean checkLinkPrivate(String id) throws Exception {
        if (id.indexOf(Utils.TOPIC) >= 0) {
            try {
                Topic topic = (Topic)this.forumService.getObjectNameById(id, Utils.TOPIC);
                if (topic != null) {
                    if (topic.getIsClosed() || !topic.getIsActiveByForum() || !topic.getIsActive() || topic.getIsWaiting() || !Utils.isEmpty((String[])topic.getCanView())) {
                        return true;
                    }
                    return this.isForumPrivate(topic.getPath(), true);
                }
            }
            catch (Exception e) {
                log.warn((Object)("\nThe " + id + " must exist"));
            }
        } else {
            if (id.indexOf(Utils.CATEGORY) == 0) {
                return this.isCategoryPrivate(id, false);
            }
            if (id.indexOf(Utils.FORUM) == 0) {
                return this.isForumPrivate(id, false);
            }
        }
        return false;
    }

    private boolean isCategoryPrivate(String id, boolean isForTopic) throws Exception {
        Category cate = this.forumService.getCategory(id);
        if (cate != null) {
            return !Utils.isEmpty((String[])cate.getUserPrivate()) || isForTopic && !Utils.isEmpty((String[])cate.getViewer());
        }
        return true;
    }

    private boolean isForumPrivate(String id, boolean isForTopic) throws Exception {
        Forum forum = null;
        if (id.indexOf("/") >= 0) {
            String[] arr = id.split("/");
            forum = this.forumService.getForum(arr[arr.length - 3], arr[arr.length - 2]);
        } else {
            forum = (Forum)this.forumService.getObjectNameById(id, Utils.FORUM);
        }
        if (forum != null) {
            if (forum.getIsClosed() || isForTopic && !Utils.isEmpty((String[])forum.getViewer())) {
                return true;
            }
            return this.isCategoryPrivate(forum.getCategoryId(), isForTopic);
        }
        return true;
    }

    static /* synthetic */ boolean access$002(UIBreadcumbs x0, boolean x1) {
        x0.isOpen = x1;
        return x0.isOpen;
    }
}

