/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UICategoryForm;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.ks.common.webui.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UICategoryForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddPrivateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UICategoryUserPopupWindow", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UICategoryForm
extends BaseForumForm
implements UIPopupComponent,
UISelector {
    public static final String CATEGORY_DETAIL_TAB = "DetailTab";
    public static final String CATEGORY_PERMISSION_TAB = "PermissionTab";
    public static final String FIELD_CATEGORYTITLE_INPUT = "CategoryTitle";
    public static final String FIELD_CATEGORYORDER_INPUT = "CategoryOrder";
    public static final String FIELD_DESCRIPTION_INPUT = "Description";
    public static final String FIELD_USERPRIVATE_MULTIVALUE = "UserPrivate";
    public static final String FIELD_MODERAROR_MULTIVALUE = "moderators";
    public static final String FIELD_VIEWER_MULTIVALUE = "Viewer";
    public static final String FIELD_POSTABLE_MULTIVALUE = "Postable";
    public static final String FIELD_TOPICABLE_MULTIVALUE = "Topicable";
    public static final String USER_SELECTOR_POPUPWINDOW = "UICategoryUserPopupWindow";
    private String categoryId = ForumUtils.EMPTY_STR;
    private int id = 0;
    private boolean isDoubleClickSubmit = false;

    public UICategoryForm() throws Exception {
        UIFormInputWithActions.ActionData ad;
        UIFormInputWithActions detailTab = new UIFormInputWithActions("DetailTab");
        UIFormInputWithActions permissionTab = new UIFormInputWithActions("PermissionTab");
        UIFormStringInput categoryTitle = new UIFormStringInput("CategoryTitle", "CategoryTitle", null);
        categoryTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput categoryOrder = new UIFormStringInput("CategoryOrder", "CategoryOrder", "0");
        categoryOrder.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        UIFormTextAreaInput description = new UIFormTextAreaInput("Description", "Description", null);
        UIFormTextAreaInput userPrivate = new UIFormTextAreaInput("UserPrivate", "UserPrivate", null);
        UIFormTextAreaInput moderators = new UIFormTextAreaInput("moderators", "moderators", null);
        UIFormTextAreaInput viewer = new UIFormTextAreaInput("Viewer", "Viewer", null);
        UIFormTextAreaInput postable = new UIFormTextAreaInput("Postable", "Postable", null);
        UIFormTextAreaInput topicable = new UIFormTextAreaInput("Topicable", "Topicable", null);
        detailTab.addUIFormInput((UIFormInput)categoryTitle);
        detailTab.addUIFormInput((UIFormInput)categoryOrder);
        detailTab.addUIFormInput((UIFormInput)userPrivate);
        detailTab.addUIFormInput((UIFormInput)description);
        permissionTab.addUIFormInput((UIFormInput)moderators);
        permissionTab.addUIFormInput((UIFormInput)topicable);
        permissionTab.addUIFormInput((UIFormInput)postable);
        permissionTab.addUIFormInput((UIFormInput)viewer);
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        int i = 0;
        for (String string : strings) {
            ad = new UIFormInputWithActions.ActionData();
            if (i == 0) {
                ad.setActionListener("AddValuesUser");
            } else {
                ad.setActionListener("AddPrivate");
            }
            ad.setActionParameter(String.valueOf(i) + ForumUtils.COMMA + "UserPrivate");
            ad.setCssIconClass(string + "Icon");
            ad.setActionName(string);
            actions.add(ad);
            ++i;
        }
        detailTab.setActionField("UserPrivate", actions);
        for (int j = 0; j < this.getChildIds().length; ++j) {
            String field = this.getChildIds()[j];
            actions = new ArrayList();
            i = 0;
            for (String string : strings) {
                ad = new UIFormInputWithActions.ActionData();
                if (i == 0) {
                    ad.setActionListener("AddValuesUser");
                } else {
                    ad.setActionListener("AddPrivate");
                }
                ad.setActionParameter(String.valueOf(i) + ForumUtils.COMMA + field);
                ad.setCssIconClass(string + "Icon");
                ad.setActionName(string);
                actions.add(ad);
                ++i;
            }
            permissionTab.setActionField(field, actions);
        }
        this.addUIFormInput((UIFormInputSet)detailTab);
        this.addUIFormInput((UIFormInputSet)permissionTab);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    private String[] getChildIds() {
        return new String[]{"moderators", "Topicable", "Postable", "Viewer"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setCategoryValue(Category category, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.categoryId = category.getId();
            this.getUIStringInput("CategoryTitle").setValue((Object)CommonUtils.decodeSpecialCharToHTMLnumber((String)category.getCategoryName()));
            this.getUIStringInput("CategoryOrder").setValue((Object)Long.toString(category.getCategoryOrder()));
            this.getUIFormTextAreaInput("Description").setDefaultValue((Object)CommonUtils.decodeSpecialCharToHTMLnumber((String)category.getDescription()));
            String userPrivate = ForumUtils.unSplitForForum((String[])category.getUserPrivate());
            String moderator = ForumUtils.unSplitForForum((String[])category.getModerators());
            String topicAble = ForumUtils.unSplitForForum((String[])category.getCreateTopicRole());
            String poster = ForumUtils.unSplitForForum((String[])category.getPoster());
            String viewer = ForumUtils.unSplitForForum((String[])category.getViewer());
            this.getUIFormTextAreaInput("UserPrivate").setValue((Object)userPrivate);
            this.getUIFormTextAreaInput("moderators").setValue((Object)moderator);
            this.getUIFormTextAreaInput("Topicable").setValue((Object)topicAble);
            this.getUIFormTextAreaInput("Postable").setValue((Object)poster);
            this.getUIFormTextAreaInput("Viewer").setValue((Object)viewer);
        }
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormTextAreaInput fieldInput = this.getUIFormTextAreaInput(selectField);
        String values = (String)fieldInput.getValue();
        fieldInput.setValue((Object)ForumUtils.updateMultiValues((String)value, (String)values));
    }

    public static String listToString(List<String> list) {
        if (list == null) {
            return ForumUtils.EMPTY_STR;
        }
        String s = list.toString().substring(1);
        return s.substring(0, s.length() - 1).replaceAll(Utils.SPACE, ForumUtils.EMPTY_STR);
    }

    private void setValueField(UIFormInputWithActions withActions, String field, String values) throws Exception {
        try {
            UIFormTextAreaInput textArea = withActions.getUIFormTextAreaInput(field);
            String vls = (String)textArea.getValue();
            if (!ForumUtils.isEmpty((String)vls)) {
                values = values + ForumUtils.COMMA + vls;
                values = ForumUtils.removeStringResemble((String)values.replaceAll(",,", ForumUtils.COMMA));
            }
            textArea.setValue((Object)values);
        }
        catch (Exception e) {
            this.log.debug((Object)("Set Value into field " + field + " is fall."), (Throwable)e);
        }
    }

    static /* synthetic */ boolean access$000(UICategoryForm x0) {
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ String access$100(UICategoryForm x0) {
        return x0.categoryId;
    }

    static /* synthetic */ ForumService access$200(UICategoryForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$300(UICategoryForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ boolean access$002(UICategoryForm x0, boolean x1) {
        x0.isDoubleClickSubmit = x1;
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ int access$402(UICategoryForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }

    static /* synthetic */ int access$400(UICategoryForm x0) {
        return x0.id;
    }

    static /* synthetic */ void access$500(UIPopupWindow x0) {
        UICategoryForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$600(UIPopupWindow x0) {
        UICategoryForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$700(UIPopupWindow x0) {
        UICategoryForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$800(UICategoryForm x0, UIFormInputWithActions x1, String x2, String x3) throws Exception {
        x0.setValueField(x1, x2, x3);
    }

    static /* synthetic */ String[] access$900(UICategoryForm x0) {
        return x0.getChildIds();
    }

    static /* synthetic */ void access$1000(UIPopupWindow x0) {
        UICategoryForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$1100(UICategoryForm x0, UIPopupContainer x1, String x2, String x3) throws Exception {
        x0.showUIUserSelect(x1, x2, x3);
    }
}

