/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIForumInputWithActions;
import org.exoplatform.forum.webui.popup.UITopicForm;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.ks.common.webui.UISelector;
import org.exoplatform.ks.common.webui.WebUIUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UITopicForm.gtmpl", events={@EventConfig(listeners={PreviewThreadActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SubmitThreadActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectIconActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddTypeTopicActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UITopicUserPopupWindow", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UITopicForm
extends BaseForumForm
implements UISelector {
    public static final String FIELD_THREADCONTEN_TAB = "ThreadContent";
    public static final String FIELD_THREADICON_TAB = "ThreadIcon";
    public static final String FIELD_THREADOPTION_TAB = "ThreadOption";
    public static final String FIELD_THREADPERMISSION_TAB = "ThreadPermission";
    public static final String FIELD_TOPICTITLE_INPUT = "ThreadTitle";
    public static final String FIELD_EDITREASON_INPUT = "editReason";
    public static final String FIELD_MESSAGE_TEXTAREA = "Message";
    public static final String FIELD_MESSAGECONTENT = "messageContent";
    public static final String FIELD_TOPICSTATUS_SELECTBOX = "TopicStatus";
    public static final String FIELD_TOPICTYPE_SELECTBOX = "TopicType";
    public static final String FIELD_TOPICSTATE_SELECTBOX = "TopicState";
    public static final String FIELD_APPROVED_CHECKBOX = "Approved";
    public static final String FIELD_MODERATEPOST_CHECKBOX = "ModeratePost";
    public static final String FIELD_NOTIFYWHENADDPOST_CHECKBOX = "NotifyWhenAddPost";
    public static final String FIELD_STICKY_CHECKBOX = "Sticky";
    public static final String FIELD_CANVIEW_INPUT = "CanView";
    public static final String FIELD_CANPOST_INPUT = "CanPost";
    public static final String ACT_REMOVE = "remove";
    public static final String FIELD_ATTACHMENTS = "attachments";
    public static final String USER_SELECTOR_POPUPWINDOW = "UITopicUserPopupWindow";
    private List<ForumAttachment> attachments_ = new ArrayList();
    private String categoryId;
    private String forumId;
    private String topicId;
    private Forum forum;
    private boolean isMod = false;
    private boolean isDetail = false;
    private int id = 0;
    private Topic topic = new Topic();
    private List<TopicType> listTT = new ArrayList();
    private boolean isDoubleClickSubmit = false;

    public UITopicForm() throws Exception {
        if (this.getId() == null) {
            this.setId("UITopicForm");
        }
        this.isDoubleClickSubmit = false;
        UIFormStringInput topicTitle = new UIFormStringInput("ThreadTitle", "ThreadTitle", null);
        topicTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput editReason = new UIFormStringInput("editReason", "editReason", null);
        editReason.setRendered(false);
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("Open"), (Object)"open"));
        ls.add(new SelectItemOption(this.getLabel("Closed"), (Object)"closed"));
        UIFormSelectBox topicState = new UIFormSelectBox("TopicState", "TopicState", ls);
        topicState.setDefaultValue((Object)"open");
        ArrayList<SelectItemOption> ls1 = new ArrayList<SelectItemOption>();
        ls1.add(new SelectItemOption(this.getLabel("UnLock"), (Object)"unlock"));
        ls1.add(new SelectItemOption(this.getLabel("Locked"), (Object)"locked"));
        UIFormSelectBox topicStatus = new UIFormSelectBox("TopicStatus", "TopicStatus", ls1);
        topicStatus.setDefaultValue((Object)"unlock");
        this.setTopicType();
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("None"), (Object)"none"));
        for (TopicType topicType : this.listTT) {
            ls.add(new SelectItemOption(topicType.getName(), (Object)topicType.getId()));
        }
        UIFormSelectBox topicType = new UIFormSelectBox("TopicType", "TopicType", ls);
        topicType.setDefaultValue((Object)TopicType.DEFAULT_ID);
        UICheckBoxInput moderatePost = new UICheckBoxInput("ModeratePost", "ModeratePost", Boolean.valueOf(false));
        UICheckBoxInput checkWhenAddPost = new UICheckBoxInput("NotifyWhenAddPost", "NotifyWhenAddPost", Boolean.valueOf(false));
        UICheckBoxInput sticky = new UICheckBoxInput("Sticky", "Sticky", Boolean.valueOf(false));
        UIFormTextAreaInput canView = new UIFormTextAreaInput("CanView", "CanView", null);
        UIFormTextAreaInput canPost = new UIFormTextAreaInput("CanPost", "CanPost", null);
        UIFormWYSIWYGInput formWYSIWYGInput = new UIFormWYSIWYGInput("messageContent", "messageContent", ForumUtils.EMPTY_STR);
        formWYSIWYGInput.addValidator(MandatoryValidator.class, new Object[0]);
        formWYSIWYGInput.setFCKConfig(WebUIUtils.getFCKConfig());
        formWYSIWYGInput.setToolBarName("Basic");
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("ThreadIcon", "ThreadIcon");
        uiIconSelector.setSelectedIcon("IconsView");
        UIForumInputWithActions threadContent = new UIForumInputWithActions("ThreadContent");
        threadContent.addUIFormInput((UIFormInput)topicTitle);
        threadContent.addUIFormInput((UIFormInput)editReason);
        threadContent.addUIFormInput((UIFormInput)formWYSIWYGInput);
        threadContent.addUIFormInput((UIFormInput)new UIFormInputInfo("attachments", "attachments", null));
        threadContent.setActionField("ThreadContent", this.getUploadFileList());
        threadContent.setActionIdAddItem("attachments");
        threadContent.setActionAddItem("Attachment");
        threadContent.setLabelActionAddItem(this.getLabel("Attachment"));
        UIForumInputWithActions threadOption = new UIForumInputWithActions("ThreadOption");
        threadOption.addUIFormInput((UIFormInput)topicType);
        threadOption.addUIFormInput((UIFormInput)topicState);
        threadOption.addUIFormInput((UIFormInput)topicStatus);
        threadOption.addUIFormInput((UIFormInput)moderatePost);
        threadOption.addUIFormInput((UIFormInput)checkWhenAddPost);
        threadOption.addUIFormInput((UIFormInput)sticky);
        UIForumInputWithActions threadPermission = new UIForumInputWithActions("ThreadPermission");
        threadPermission.addUIFormInput((UIFormInput)canPost);
        threadPermission.addUIFormInput((UIFormInput)canView);
        String[] fieldPermissions = new String[]{"CanView", "CanPost"};
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        for (String fieldPermission : fieldPermissions) {
            ArrayList<UIForumInputWithActions.ActionData> actions = new ArrayList<UIForumInputWithActions.ActionData>();
            int i = 0;
            for (String string : strings) {
                UIForumInputWithActions.ActionData ad = new UIForumInputWithActions.ActionData();
                if (i == 0) {
                    ad.setActionListener("AddUser");
                } else {
                    ad.setActionListener("AddValuesUser");
                }
                ad.setActionParameter(fieldPermission + ForumUtils.SLASH + String.valueOf(i));
                ad.setCssIconClass(string + "Icon");
                ad.setActionName(string);
                actions.add(ad);
                ++i;
            }
            threadPermission.setActionField(fieldPermission, actions);
        }
        this.addUIFormInput((UIFormInputSet)threadContent);
        this.addUIFormInput((UIFormInput)uiIconSelector);
        this.addUIFormInput((UIFormInputSet)threadOption);
        this.addUIFormInput((UIFormInputSet)threadPermission);
        this.setActions(new String[]{"PreviewThread", "SubmitThread", "Cancel"});
    }

    private void addActionAddTopicType() throws Exception {
        ArrayList<UIForumInputWithActions.ActionData> actions = new ArrayList<UIForumInputWithActions.ActionData>();
        UIForumInputWithActions.ActionData ad = new UIForumInputWithActions.ActionData();
        ad.setActionListener("AddTypeTopic");
        ad.setCssIconClass("AddIcon16x16");
        ad.setActionName("AddTypeTopic");
        actions.add(ad);
        UIForumInputWithActions threadOption = (UIForumInputWithActions)this.getChildById("ThreadOption");
        threadOption.setActionField("TopicType", actions);
    }

    public void setIsDetail(boolean isDetail) {
        this.isDetail = isDetail;
    }

    public void setTopicIds(String categoryId, String forumId, Forum forum) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topic = new Topic();
        this.forum = forum;
        UIForumInputWithActions threadContent = (UIForumInputWithActions)this.getChildById("ThreadContent");
        threadContent.getUIStringInput("editReason").setRendered(false);
        if (this.getUserProfile().getUserRole() == 0L) {
            this.addActionAddTopicType();
        }
        this.setShowInfo();
    }

    private void setShowInfo() throws Exception {
        String info = this.getLabel("CanViewInfo");
        String[] canV = this.forum.getViewer();
        UIForumInputWithActions threadPermission = (UIForumInputWithActions)this.getChildById("ThreadPermission");
        if (!ForumUtils.isArrayEmpty((String[])canV)) {
            info = this.getLabel("CanViewParentInfo");
        } else {
            canV = this.getForumService().getPermissionTopicByCategory(this.categoryId, "exo:viewer");
            if (!ForumUtils.isArrayEmpty((String[])canV)) {
                info = this.getLabel("CanViewParentInfo");
            }
        }
        threadPermission.setMapLabelInfo("CanView", info);
        info = this.getLabel("CanPostInfo");
        canV = this.forum.getPoster();
        if (!ForumUtils.isArrayEmpty((String[])canV)) {
            info = this.getLabel("CanPostParentInfo");
        } else {
            canV = this.getForumService().getPermissionTopicByCategory(this.categoryId, "exo:poster");
            if (!ForumUtils.isArrayEmpty((String[])canV)) {
                info = this.getLabel("CanPostParentInfo");
            }
        }
        threadPermission.setMapLabelInfo("CanPost", info);
    }

    private void setTopicType() throws Exception {
        this.listTT.clear();
        this.listTT.addAll(this.getForumService().getTopicTypes());
    }

    public void addNewTopicType() throws Exception {
        this.setTopicType();
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("None"), (Object)"none"));
        for (TopicType topicType : this.listTT) {
            ls.add(new SelectItemOption(topicType.getName(), (Object)topicType.getId()));
        }
        UIForumInputWithActions threadOption = (UIForumInputWithActions)this.getChildById("ThreadOption");
        threadOption.getUIFormSelectBox("TopicType").setOptions(ls);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    public List<UIForumInputWithActions.ActionData> getUploadFileList() {
        ArrayList<UIForumInputWithActions.ActionData> uploadedFiles = new ArrayList<UIForumInputWithActions.ActionData>();
        for (ForumAttachment attachdata : this.attachments_) {
            UIForumInputWithActions.ActionData fileUpload = new UIForumInputWithActions.ActionData();
            fileUpload.setActionListener(ForumUtils.EMPTY_STR);
            fileUpload.setActionType(2);
            fileUpload.setCssIconClass("AttachmentIcon ZipFileIcon");
            String fileName = ForumUtils.getSizeFile((long)attachdata.getSize());
            fileName = attachdata.getName() + "(" + fileName + ")";
            fileUpload.setActionName(fileName);
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIForumInputWithActions.ActionData removeAction = new UIForumInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName("remove");
            removeAction.setActionParameter(attachdata.getId());
            removeAction.setActionType(0);
            removeAction.setCssIconClass("DustBin");
            removeAction.setBreakLine(true);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void refreshUploadFileList() throws Exception {
        UIForumInputWithActions inputSet = (UIForumInputWithActions)this.getChildById("ThreadContent");
        inputSet.setActionField("attachments", this.getUploadFileList());
    }

    public void addToUploadFileList(ForumAttachment attachfile) {
        this.attachments_.add(attachfile);
    }

    public void removeFromUploadFileList(ForumAttachment attachfile) {
        this.attachments_.remove(attachfile);
    }

    public void removeUploadFileList() {
        this.attachments_.clear();
    }

    public List<ForumAttachment> getAttachFileList() {
        return this.attachments_;
    }

    public boolean isMod() {
        return this.isMod;
    }

    public void setMod(boolean isMod) {
        this.isMod = isMod;
    }

    public void setUpdateTopic(Topic topic, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.topicId = topic.getId();
            this.topic = this.getForumService().getTopic(this.categoryId, this.forumId, this.topicId, ForumUtils.EMPTY_STR);
            UIForumInputWithActions threadContent = (UIForumInputWithActions)this.getChildById("ThreadContent");
            threadContent.getUIStringInput("editReason").setRendered(true);
            threadContent.getUIStringInput("ThreadTitle").setValue((Object)CommonUtils.decodeSpecialCharToHTMLnumber((String)topic.getTopicName()));
            ((UIFormWYSIWYGInput)threadContent.getChild(UIFormWYSIWYGInput.class)).setValue((Object)this.topic.getDescription());
            UIForumInputWithActions threadOption = (UIForumInputWithActions)this.getChildById("ThreadOption");
            String stat = "open";
            if (this.topic.getIsClosed()) {
                stat = "closed";
            }
            threadOption.getUIFormSelectBox("TopicState").setValue(stat);
            stat = this.topic.getIsLock() ? "locked" : "unlock";
            threadOption.getUIFormSelectBox("TopicStatus").setValue(stat);
            threadOption.getUICheckBoxInput("ModeratePost").setChecked(this.topic.getIsModeratePost());
            if (this.topic.getIsNotifyWhenAddPost() != null && this.topic.getIsNotifyWhenAddPost().trim().length() > 0) {
                threadOption.getUICheckBoxInput("NotifyWhenAddPost").setChecked(true);
            }
            threadOption.getUIFormSelectBox("TopicType").setValue(this.topic.getTopicType());
            threadOption.getUICheckBoxInput("Sticky").setChecked(this.topic.getIsSticky());
            UIForumInputWithActions threadPermission = (UIForumInputWithActions)this.getChildById("ThreadPermission");
            threadPermission.getUIFormTextAreaInput("CanView").setValue((Object)ForumUtils.unSplitForForum((String[])this.topic.getCanView()));
            threadPermission.getUIFormTextAreaInput("CanPost").setValue((Object)ForumUtils.unSplitForForum((String[])this.topic.getCanPost()));
            String postId = this.topicId.replaceFirst(Utils.TOPIC, Utils.POST);
            Post post = this.getForumService().getPost(this.categoryId, this.forumId, this.topicId, postId);
            if (post != null && post.getAttachments() != null && post.getAttachments().size() > 0) {
                this.attachments_ = post.getAttachments();
                this.refreshUploadFileList();
            }
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(topic.getIcon());
        }
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormTextAreaInput fieldInput = this.getUIFormTextAreaInput(selectField);
        String values = (String)fieldInput.getValue();
        fieldInput.setValue((Object)ForumUtils.updateMultiValues((String)value, (String)values));
    }

    private void setValueField(UIForumInputWithActions withActions, String field, String values) throws Exception {
        try {
            UIFormTextAreaInput textArea = withActions.getUIFormTextAreaInput(field);
            String vls = (String)textArea.getValue();
            if (!ForumUtils.isEmpty((String)vls)) {
                values = values + ForumUtils.COMMA + vls;
                values = ForumUtils.removeStringResemble((String)values.replaceAll(",,", ForumUtils.COMMA));
            }
            textArea.setValue((Object)values);
        }
        catch (Exception e) {
            this.log.warn((Object)("Declare " + values + " for " + field + "fail: " + e.getMessage() + "\n" + e.getCause()));
        }
    }

    static /* synthetic */ String access$000(UITopicForm x0) {
        return x0.topicId;
    }

    static /* synthetic */ Topic access$100(UITopicForm x0) {
        return x0.topic;
    }

    static /* synthetic */ List access$200(UITopicForm x0) {
        return x0.attachments_;
    }

    static /* synthetic */ boolean access$300(UITopicForm x0) {
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ boolean access$302(UITopicForm x0, boolean x1) {
        x0.isDoubleClickSubmit = x1;
        return x0.isDoubleClickSubmit;
    }

    static /* synthetic */ String access$400(UITopicForm x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$500(UITopicForm x0) {
        return x0.forumId;
    }

    static /* synthetic */ ForumService access$600(UITopicForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Forum access$700(UITopicForm x0) {
        return x0.forum;
    }

    static /* synthetic */ ForumService access$800(UITopicForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ boolean access$900(UITopicForm x0) {
        return x0.isDetail;
    }

    static /* synthetic */ boolean access$902(UITopicForm x0, boolean x1) {
        x0.isDetail = x1;
        return x0.isDetail;
    }

    static /* synthetic */ ForumService access$1000(UITopicForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$1100(UITopicForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Topic access$102(UITopicForm x0, Topic x1) {
        x0.topic = x1;
        return x0.topic;
    }

    static /* synthetic */ UIComponent access$1200(UITopicForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ UIComponent access$1300(UITopicForm x0, UIContainer x1, Class x2, String x3, int x4, int x5) throws Exception {
        return x0.openPopup(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ int access$1402(UITopicForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }

    static /* synthetic */ void access$1500(UIPopupWindow x0) {
        UITopicForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$1600(UIPopupWindow x0) {
        UITopicForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$1700(UIPopupWindow x0) {
        UITopicForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$1800(UITopicForm x0, UIForumInputWithActions x1, String x2, String x3) throws Exception {
        x0.setValueField(x1, x2, x3);
    }

    static /* synthetic */ void access$1900(UIPopupWindow x0) {
        UITopicForm.closePopupWindow((UIPopupWindow)x0);
    }

    static /* synthetic */ void access$2000(UITopicForm x0, UIPopupContainer x1, String x2, String x3) throws Exception {
        x0.showUIUserSelect(x1, x2, x3);
    }
}

