/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIViewUserProfile;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewMemberProfile.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewUserProfile
extends BaseForumForm
implements UIPopupComponent {
    private UserProfile userProfileViewer;

    public CommonContact getContact(String userId) throws Exception {
        return ForumSessionUtils.getPersonalContact((String)userId);
    }

    private boolean isAdmin(String userId) throws Exception {
        return this.getForumService().isAdminRole(userId);
    }

    private boolean isOnline(String userId) throws Exception {
        return this.getForumService().isOnline(userId);
    }

    public void setUserProfileViewer(UserProfile userProfileViewer) {
        this.userProfileViewer = userProfileViewer;
    }

    public UserProfile getUserProfileViewer() {
        return this.userProfileViewer;
    }

    private String getAvatarUrl() throws Exception {
        return ForumSessionUtils.getUserAvatarURL((String)this.userProfileViewer.getUserId(), (ForumService)this.getForumService());
    }

    private String[] getLabelProfile() {
        return new String[]{this.getLabel("userName"), this.getLabel("firstName"), this.getLabel("lastName"), this.getLabel("birthDay"), this.getLabel("gender"), this.getLabel("email"), this.getLabel("jobTitle"), this.getLabel("location"), this.getLabel("homePhone"), this.getLabel("workPhone"), this.getLabel("website")};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

