/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIWatchToolsForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIWatchToolsForm.gtmpl", events={@EventConfig(listeners={DeleteEmailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditEmailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWatchToolsForm
extends UIForm
implements UIPopupComponent {
    public final String WATCHTOOLS_ITERATOR = "WatchToolsPageIterator";
    private String path = ForumUtils.EMPTY_STR;
    private String[] emails = new String[0];
    private boolean isTopic = false;
    private JCRPageList pageList;
    UIForumPageIterator pageIterator;
    private List<String> listEmail = new ArrayList();
    private Log log = ExoLogger.getLogger(UIWatchToolsForm.class);

    public UIWatchToolsForm() throws Exception {
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "WatchToolsPageIterator");
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean getIsTopic() {
        return this.isTopic;
    }

    public void setIsTopic(boolean isTopic) {
        this.isTopic = isTopic;
    }

    public String[] getEmails() throws Exception {
        this.emails = this.getListEmail().toArray(new String[0]);
        return this.emails;
    }

    public void setEmails(String[] emails) {
        this.listEmail.clear();
        this.listEmail.addAll(Arrays.asList(emails));
        this.pageList = new ForumPageList(6, this.listEmail.size());
        this.pageList.setPageSize(6);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        try {
            if ((Long)this.pageIterator.getInfoPage().get(3) <= 1L) {
                this.pageIterator.setRendered(false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"\nA UIComponent could not rendered: ", (Throwable)e);
        }
    }

    public List<String> getListEmail() throws Exception {
        int pageSelect = this.pageIterator.getPageSelected();
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.addAll(this.pageList.getPageList((long)pageSelect, this.listEmail));
            if (list.isEmpty()) {
                while (list.isEmpty() && pageSelect > 1) {
                    list.addAll(this.pageList.getPageList((long)(--pageSelect), this.listEmail));
                    this.pageIterator.setSelectPage((long)pageSelect);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void setUnWatchEmail(String[] emails, String unwatchEmail) {
        if (emails.length == 1) {
            this.setEmails(emails);
        } else if (emails.length > 1) {
            ArrayList<String> temp = new ArrayList<String>();
            for (String em : emails) {
                if (em.equals(unwatchEmail)) continue;
                temp.add(em);
            }
            String[] tempEmails = temp.toArray(new String[0]);
            this.setEmails(tempEmails);
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ String access$000(UIWatchToolsForm x0) {
        return x0.path;
    }

    static /* synthetic */ List access$100(UIWatchToolsForm x0) {
        return x0.listEmail;
    }

    static /* synthetic */ boolean access$202(UIWatchToolsForm x0, boolean x1) {
        x0.isTopic = x1;
        return x0.isTopic;
    }
}

