/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.SettingPortletPreference;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIForumInputWithActions;
import org.exoplatform.forum.webui.popup.UISettingEditModeForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISettingEditModeForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectTabActionListener.class})})
public class UISettingEditModeForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_SCOPED_TAB = "Scoped";
    public static final String FIELD_SHOW_HIDDEN_TAB = "EnabledPanel";
    public static final String FIELD_FORUM_PREFERENCE_TAB = "ForumPreference";
    public static final String FIELD_ISFORUMJUMP_CHECKBOX = "isShowForumJump";
    public static final String FIELD_ISPOLL_CHECKBOX = "IsShowPoll";
    public static final String FIELD_ISMODERATOR_CHECKBOX = "isShowModerator";
    public static final String FIELD_ISQUICKREPLY_CHECKBOX = "isShowQuickReply";
    public static final String FIELD_ISICONSLEGEND_CHECKBOX = "isShowIconsLegend";
    public static final String FIELD_ISRULES_CHECKBOX = "isShowRules";
    public static final String FIELD_ISSTATISTIC_CHECKBOX = "isShowStatistic";
    public static final String FIELD_ISUSEAJAX_CHECKBOX = "isUseAjax";
    private boolean isSave = false;
    private int tabId = 0;
    private static List<String> listCategoryinv = new ArrayList();
    private static List<String> listforuminv = new ArrayList();
    private SettingPortletPreference portletPreference;

    public UISettingEditModeForm() {
        UIForumInputWithActions Scoped = new UIForumInputWithActions(FIELD_SCOPED_TAB);
        UIForumInputWithActions EnabledPanel = new UIForumInputWithActions(FIELD_SHOW_HIDDEN_TAB);
        UIForumInputWithActions ForumPreference = new UIForumInputWithActions(FIELD_FORUM_PREFERENCE_TAB);
        UICheckBoxInput isShowForumJump = new UICheckBoxInput(FIELD_ISFORUMJUMP_CHECKBOX, FIELD_ISFORUMJUMP_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput IsShowPoll = new UICheckBoxInput(FIELD_ISPOLL_CHECKBOX, FIELD_ISPOLL_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput isShowModerator = new UICheckBoxInput(FIELD_ISMODERATOR_CHECKBOX, FIELD_ISMODERATOR_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput isShowQuickReply = new UICheckBoxInput(FIELD_ISQUICKREPLY_CHECKBOX, FIELD_ISQUICKREPLY_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput isShowIconsLegend = new UICheckBoxInput(FIELD_ISICONSLEGEND_CHECKBOX, FIELD_ISICONSLEGEND_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput isShowRules = new UICheckBoxInput(FIELD_ISRULES_CHECKBOX, FIELD_ISRULES_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput isShowStatistic = new UICheckBoxInput(FIELD_ISSTATISTIC_CHECKBOX, FIELD_ISSTATISTIC_CHECKBOX, Boolean.valueOf(true));
        UICheckBoxInput isUseAjax = new UICheckBoxInput(FIELD_ISUSEAJAX_CHECKBOX, FIELD_ISUSEAJAX_CHECKBOX, Boolean.valueOf(true));
        EnabledPanel.addUIFormInput((UIFormInput)isShowForumJump);
        EnabledPanel.addUIFormInput((UIFormInput)IsShowPoll);
        EnabledPanel.addUIFormInput((UIFormInput)isShowModerator);
        EnabledPanel.addUIFormInput((UIFormInput)isShowQuickReply);
        EnabledPanel.addUIFormInput((UIFormInput)isShowIconsLegend);
        EnabledPanel.addUIFormInput((UIFormInput)isShowRules);
        EnabledPanel.addUIFormInput((UIFormInput)isShowStatistic);
        ForumPreference.addUIFormInput((UIFormInput)isUseAjax);
        this.addUIFormInput((UIFormInputSet)Scoped);
        this.addUIFormInput((UIFormInputSet)EnabledPanel);
        this.addUIFormInput((UIFormInputSet)ForumPreference);
    }

    public void setInitComponent() throws Exception {
        UIForumInputWithActions EnabledPanel = (UIForumInputWithActions)this.getChildById(FIELD_SHOW_HIDDEN_TAB);
        UIForumInputWithActions ForumPreference = (UIForumInputWithActions)this.getChildById(FIELD_FORUM_PREFERENCE_TAB);
        this.portletPreference = ForumUtils.getPorletPreference();
        EnabledPanel.getUICheckBoxInput(FIELD_ISFORUMJUMP_CHECKBOX).setChecked(this.portletPreference.isShowForumJump());
        EnabledPanel.getUICheckBoxInput(FIELD_ISPOLL_CHECKBOX).setChecked(this.portletPreference.isShowPoll());
        EnabledPanel.getUICheckBoxInput(FIELD_ISQUICKREPLY_CHECKBOX).setChecked(this.portletPreference.isShowQuickReply());
        EnabledPanel.getUICheckBoxInput(FIELD_ISICONSLEGEND_CHECKBOX).setChecked(this.portletPreference.isShowIconsLegend());
        EnabledPanel.getUICheckBoxInput(FIELD_ISRULES_CHECKBOX).setChecked(this.portletPreference.isShowRules());
        EnabledPanel.getUICheckBoxInput(FIELD_ISSTATISTIC_CHECKBOX).setChecked(this.portletPreference.isShowStatistics());
        EnabledPanel.getUICheckBoxInput(FIELD_ISMODERATOR_CHECKBOX).setChecked(this.portletPreference.isShowModerators());
        ForumPreference.getUICheckBoxInput(FIELD_ISUSEAJAX_CHECKBOX).setChecked(this.portletPreference.isUseAjax());
        this.isSave = false;
    }

    protected boolean tabIsSelected(int tabId) {
        return this.tabId == tabId;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    protected List<Category> getCategoryList() throws Exception {
        ArrayList<Category> categoryList = new ArrayList<Category>();
        try {
            String userId = this.getUserProfile().getUserId();
            if (this.userProfile.getUserRole() > 0L) {
                for (Category category : this.getForumService().getCategories()) {
                    String[] uesrs = category.getUserPrivate();
                    if (uesrs != null && uesrs.length > 0 && !uesrs[0].equals(" ")) {
                        if (!ForumServiceUtils.hasPermission((String[])uesrs, (String)userId)) continue;
                        categoryList.add(category);
                        continue;
                    }
                    categoryList.add(category);
                }
            } else {
                categoryList.addAll(this.getForumService().getCategories());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.isSave) {
            listCategoryinv = ((UIForumPortlet)this.getParent()).getInvisibleCategories();
        }
        for (Category category : categoryList) {
            String categoryId = category.getId();
            boolean isCheck = false;
            if (listCategoryinv.contains(categoryId) || listCategoryinv.isEmpty()) {
                isCheck = true;
            }
            if (this.getUICheckBoxInput(categoryId) != null) {
                this.getUICheckBoxInput(categoryId).setChecked(isCheck);
                continue;
            }
            UICheckBoxInput boxInput = new UICheckBoxInput(categoryId, categoryId, Boolean.valueOf(isCheck));
            boxInput.setChecked(isCheck);
            this.addUIFormInput((UIFormInput)boxInput);
        }
        return categoryList;
    }

    protected List<Forum> getForumList(String categoryId) throws Exception {
        List<Forum> forumList = null;
        StringBuilder strQuery = new StringBuilder();
        if (this.getUserProfile().getUserRole() > 0L) {
            strQuery.append("(@").append("exo:isClosed").append("='false') or (@").append("exo:moderators").append("='").append(this.userProfile.getUserId()).append("')");
        }
        try {
            forumList = this.getForumService().getForums(categoryId, strQuery.toString());
        }
        catch (Exception e) {
            forumList = new ArrayList();
        }
        if (!this.isSave) {
            listforuminv = ((UIForumPortlet)this.getParent()).getInvisibleForums();
        }
        for (Forum forum : forumList) {
            String forumId = forum.getId();
            boolean isCheck = false;
            if (listforuminv.contains(forumId) || listCategoryinv.isEmpty()) {
                isCheck = true;
            }
            if (this.getUICheckBoxInput(forumId) != null) {
                this.getUICheckBoxInput(forumId).setChecked(isCheck);
                continue;
            }
            UICheckBoxInput boxInput = new UICheckBoxInput(forumId, forumId, Boolean.valueOf(isCheck));
            boxInput.setChecked(isCheck);
            this.addUIFormInput((UIFormInput)boxInput);
        }
        return forumList;
    }

    private void setNewListActive() throws Exception {
        HashSet<String> categoryIds = new HashSet<String>();
        HashSet<String> forumIds = new HashSet<String>();
        List children = this.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UICheckBoxInput) || !((UICheckBoxInput)child).isChecked()) continue;
            if (child.getId().indexOf(Utils.CATEGORY) >= 0) {
                categoryIds.add(child.getId());
                continue;
            }
            forumIds.add(child.getId());
        }
        listforuminv = new ArrayList(forumIds);
        listCategoryinv = new ArrayList(categoryIds);
    }

    static /* synthetic */ SettingPortletPreference access$000(UISettingEditModeForm x0) {
        return x0.portletPreference;
    }

    static /* synthetic */ boolean access$102(UISettingEditModeForm x0, boolean x1) {
        x0.isSave = x1;
        return x0.isSave;
    }

    static /* synthetic */ void access$200(UISettingEditModeForm x0) throws Exception {
        x0.setNewListActive();
    }

    static /* synthetic */ List access$300() {
        return listCategoryinv;
    }

    static /* synthetic */ List access$400() {
        return listforuminv;
    }

    static /* synthetic */ int access$500(UISettingEditModeForm x0) {
        return x0.tabId;
    }

    static /* synthetic */ int access$502(UISettingEditModeForm x0, int x1) {
        x0.tabId = x1;
        return x0.tabId;
    }
}

