/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.xml.namespace.QName;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumInfos;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicContainer;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.TransformHTML;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.webui.WebUIUtils;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicContainer.gtmpl", events={@EventConfig(listeners={SearchFormActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class}), @EventConfig(listeners={AddTopicActionListener.class}), @EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={OpenTopicsTagActionListener.class}), @EventConfig(listeners={EditForumActionListener.class}), @EventConfig(listeners={SetLockedForumActionListener.class}), @EventConfig(listeners={SetUnLockForumActionListener.class}), @EventConfig(listeners={SetOpenForumActionListener.class}), @EventConfig(listeners={SetCloseForumActionListener.class}), @EventConfig(listeners={MoveForumActionListener.class}), @EventConfig(listeners={RemoveForumActionListener.class}), @EventConfig(listeners={WatchOptionActionListener.class}), @EventConfig(listeners={EditTopicActionListener.class}), @EventConfig(listeners={SetOpenTopicActionListener.class}), @EventConfig(listeners={SetCloseTopicActionListener.class}), @EventConfig(listeners={SetLockedTopicActionListener.class}), @EventConfig(listeners={SetUnLockTopicActionListener.class}), @EventConfig(listeners={SetStickTopicActionListener.class}), @EventConfig(listeners={SetUnStickTopicActionListener.class}), @EventConfig(listeners={SetMoveTopicActionListener.class}), @EventConfig(listeners={MergeTopicActionListener.class}), @EventConfig(listeners={SetDeleteTopicActionListener.class}), @EventConfig(listeners={SetUnWaitingActionListener.class}), @EventConfig(listeners={ApproveTopicsActionListener.class}), @EventConfig(listeners={ActivateTopicsActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={ExportForumActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class}), @EventConfig(listeners={BanIpForumToolsActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UITopicContainer
extends UIForumKeepStickPageIterator {
    private String forumId = ForumUtils.EMPTY_STR;
    private String categoryId = ForumUtils.EMPTY_STR;
    private Forum forum;
    private List<Topic> topicList;
    private List<String> moderators;
    private boolean isUpdate = false;
    private boolean isModerator = false;
    private boolean canAddNewThread = true;
    private String strOrderBy = ForumUtils.EMPTY_STR;
    private boolean isLogin = false;
    private boolean isNull = false;
    private boolean enableIPLogging = true;
    private boolean isReload = true;
    private boolean isShowActive = false;
    protected String DEFAULT_ID = TopicType.DEFAULT_ID;
    private Map<String, TopicType> topicTypeM = new HashMap();
    private Map<String, Integer> pageTopicRemember = new HashMap();
    private Map<String, String> cssClassMap = new HashMap();

    public UITopicContainer() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_T, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.GOPAGE_ID_B, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null));
        if (!UserHelper.isAnonim()) {
            this.isLogin = true;
        }
        this.isLink = true;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public String getRSSLink(String cateId) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return CommonUtils.getRSSLink((String)"forum", (String)pcontainer.getPortalContainerInfo().getContainerName(), (String)cateId);
    }

    public String getLastPostIdReadOfTopic(String topicId) throws Exception {
        return this.getUserProfile().getLastPostIdReadOfTopic(topicId);
    }

    private int getPageTopicRemember(String forumId) {
        if (this.pageTopicRemember.containsKey(forumId)) {
            return (Integer)this.pageTopicRemember.get(forumId);
        }
        return 1;
    }

    public void setUpdateForum(String categoryId, Forum forum, int page) throws Exception {
        this.forum = forum;
        this.forumId = forum.getId();
        this.categoryId = categoryId;
        this.pageSelect = page;
        this.isUpdate = false;
        this.isReload = false;
        if (page == 0) {
            this.pageSelect = this.getPageTopicRemember(this.forumId);
        }
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + ForumUtils.SLASH + this.forumId);
        forumPortlet.updateAccessForum(this.forumId);
        this.cleanCheckedList();
        this.setForum(true);
    }

    public boolean getIsAutoPrune() throws Exception {
        return this.isShowActive;
    }

    public void setTopicType(String typeId) throws Exception {
        block5: {
            try {
                TopicType topicType = this.getForumService().getTopicType(typeId);
                if (topicType.getId().equals(TopicType.DEFAULT_ID)) {
                    if (this.topicTypeM.containsKey(typeId)) {
                        this.topicTypeM.remove(typeId);
                    }
                } else {
                    this.topicTypeM.put(typeId, topicType);
                }
            }
            catch (Exception e) {
                if (!this.topicTypeM.containsKey(typeId)) break block5;
                this.topicTypeM.remove(typeId);
            }
        }
    }

    public String[] getIconTopicType(String typeId) throws Exception {
        try {
            TopicType topicType = (TopicType)this.topicTypeM.get(typeId);
            if (topicType != null) {
                return new String[]{topicType.getIcon(), topicType.getName()};
            }
            topicType = this.getForumService().getTopicType(typeId);
            if (!topicType.getId().equals(TopicType.DEFAULT_ID)) {
                this.topicTypeM.put(typeId, topicType);
                return new String[]{topicType.getIcon(), topicType.getName()};
            }
            return new String[]{" "};
        }
        catch (Exception e) {
            this.log.warn((Object)("\nThere is no icon for " + typeId + " type\n" + e.getCause()));
            return new String[]{" "};
        }
    }

    public String getTitleInHTMLCode(String s) {
        return TransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    public void setIdUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public void updateByBreadcumbs(String categoryId, String forumId, boolean isBreadcumbs, int page) throws Exception {
        this.forumId = forumId;
        this.categoryId = categoryId;
        this.isUpdate = true;
        this.pageSelect = page;
        this.isReload = false;
        if (page == 0) {
            this.pageSelect = this.getPageTopicRemember(forumId);
        }
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.isUseAjax = forumPortlet.isUseAjax();
        this.enableIPLogging = forumPortlet.isEnableIPLogging();
        forumPortlet.updateAccessForum(forumId);
        if (!isBreadcumbs) {
            ((UIBreadcumbs)forumPortlet.getChild(UIBreadcumbs.class)).setUpdataPath(categoryId + ForumUtils.SLASH + forumId);
        }
        this.cleanCheckedList();
        this.setForum(true);
    }

    protected String getActionViewInfoUser(String linkType, String userName) {
        return ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getPortletLink(linkType, userName);
    }

    public boolean getCanAddNewThread() {
        return this.canAddNewThread;
    }

    private void setForumModeratorPortlet() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletSession portletSession = pcontext.getRequest().getPortletSession();
        ActionResponse actionRes = null;
        if (pcontext.getResponse() instanceof ActionResponse) {
            actionRes = (ActionResponse)pcontext.getResponse();
        }
        ForumParameter param = new ForumParameter();
        param.setRenderModerator(true);
        param.setModerators(this.moderators);
        param.setRenderRule(true);
        List list = param.getInfoRules();
        boolean isLock = this.forum.getIsClosed();
        if (!isLock) {
            isLock = this.forum.getIsLock();
        }
        if (!isLock) {
            isLock = !this.canAddNewThread;
        }
        list.set(0, String.valueOf(isLock));
        param.setInfoRules(list);
        if (actionRes != null) {
            actionRes.setEvent(new QName("ForumModerateEvent"), (Serializable)param);
            actionRes.setEvent(new QName("ForumRuleEvent"), (Serializable)param);
        } else {
            portletSession.setAttribute(UIForumPortlet.FORUM_MODERATE_EVENT_PARAMS, (Object)param, 1);
            portletSession.setAttribute(UIForumPortlet.RULE_EVENT_PARAMS, (Object)param, 1);
        }
    }

    public void setForum(boolean isSetModerator) throws Exception {
        this.forum = this.getForum();
        this.canAddNewThread = true;
        this.moderators = ForumServiceUtils.getUserPermission((String[])this.forum.getModerators());
        String userId = this.getUserProfile().getUserId();
        this.isModerator = this.userProfile.getUserRole() == 0L || !this.userProfile.getIsBanned() && !this.moderators.isEmpty() && this.moderators.contains(userId);
        boolean isCheck = true;
        List ipBaneds = this.forum.getBanIP();
        if (ipBaneds != null && ipBaneds.contains(this.getRemoteIP()) || this.userProfile.getIsBanned()) {
            this.canAddNewThread = false;
            isCheck = false;
        }
        if (!this.isModerator && isCheck) {
            String[] strings = this.forum.getCreateTopicRole();
            boolean isEmpty = false;
            if (!ForumUtils.isArrayEmpty((String[])strings)) {
                this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
            } else {
                isEmpty = true;
            }
            if (!(!isEmpty && this.canAddNewThread || ForumUtils.isArrayEmpty((String[])(strings = this.getForumService().getPermissionTopicByCategory(this.categoryId, "exo:createTopicRole"))))) {
                this.canAddNewThread = ForumServiceUtils.hasPermission((String[])strings, (String)userId);
            }
        }
        if (isSetModerator) {
            this.setForumModeratorPortlet();
        }
        UIForumContainer forumContainer = (UIForumContainer)this.getParent();
        if (this.forum != null) {
            ((UIForumInfos)forumContainer.findFirstComponentOfType(UIForumInfos.class)).setForum(this.forum);
        }
    }

    public String getCssClassForSorting(String path) {
        if (this.cssClassMap.get(path) == null) {
            return "DownArrow1Icon";
        }
        return (String)this.cssClassMap.get(path);
    }

    private void setCssClassForSorting(String path, String orderOption) {
        String[] properties = new String[]{"exo:name", "exo:lastPostDate", "exo:voteRating", "exo:postCount", "exo:viewCount"};
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].equals(path)) {
                if (orderOption.equals(" ascending".trim())) {
                    this.cssClassMap.put(properties[i], "UpArrow1Icon");
                    continue;
                }
                this.cssClassMap.put(properties[i], "DownArrow1Icon");
                continue;
            }
            this.cssClassMap.put(properties[i], "NonArrow1Icon");
        }
    }

    private Forum getForum() throws Exception {
        if (this.isUpdate || this.forum == null) {
            this.forum = this.getForumService().getForum(this.categoryId, this.forumId);
            this.isUpdate = false;
        }
        return this.forum;
    }

    protected void initPage() throws Exception {
        int maxTopic;
        this.setListWatches();
        this.objectId = this.forumId;
        if (this.getUserProfile() == null) {
            this.userProfile = new UserProfile();
        }
        StringBuffer strQuery = new StringBuffer();
        String userId = this.userProfile.getUserId();
        if (this.isReload) {
            this.setForum(false);
        } else {
            this.isReload = true;
        }
        if (!this.isModerator) {
            strQuery.append("@").append("exo:isWaiting").append("='false' and @").append("exo:isActive").append("='true' and @").append("exo:isClosed").append("='false' and (not(@").append("exo:canView").append(") or @").append("exo:canView").append("='' or @").append("exo:canView").append("=' ' or @").append("exo:owner").append("='").append(userId).append("'");
            for (String string : UserHelper.getAllGroupAndMembershipOfUser((String)userId)) {
                strQuery.append(" or @").append("exo:canView").append("='").append(string).append("'");
            }
            strQuery.append(")");
            if (this.forum.getIsModerateTopic()) {
                if (!ForumUtils.isEmpty((String)strQuery.toString())) {
                    strQuery.append(" and ");
                }
                strQuery.append("@").append("exo:isApproved").append("='true'");
            }
            List listUser = new ArrayList();
            listUser = ForumUtils.addArrayToList(listUser, (String[])this.forum.getViewer());
            if (!(listUser = ForumUtils.addArrayToList(listUser, (String[])this.getForumService().getPermissionTopicByCategory(this.categoryId, "exo:viewer"))).isEmpty() && !ForumServiceUtils.hasPermission((String[])listUser.toArray(new String[listUser.size()]), (String)userId)) {
                strQuery.append(" and (@").append("exo:owner").append("='").append(userId).append("' or topicPermission");
            }
        }
        if ((maxTopic = (int)this.userProfile.getMaxTopicInPage()) <= 0) {
            maxTopic = 10;
        }
        this.pageList = this.getForumService().getTopicList(this.categoryId, this.forumId, strQuery.toString(), this.strOrderBy, maxTopic);
    }

    private String getRemoteIP() throws Exception {
        if (this.enableIPLogging) {
            return WebUIUtils.getRemoteIP();
        }
        return ForumUtils.EMPTY_STR;
    }

    public String[] getActionMenuForum() throws Exception {
        Object[] actions = new String[]{"EditForum", "SetUnLockForum", "SetLockedForum", "SetOpenForum", "SetCloseForum", "MoveForum", "RemoveForum", "ExportForum", "WatchOption", "BanIpForumTools"};
        if (this.userProfile.getUserRole() > 0L || this.userProfile.getUserRole() == 0L && !ForumUtils.isEmpty((String)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getForumIdOfSpace())) {
            actions = (String[])ArrayUtils.removeElement((Object[])actions, (Object)"RemoveForum");
            actions = (String[])ArrayUtils.removeElement((Object[])actions, (Object)"MoveForum");
        }
        return actions;
    }

    protected String getConfirm(String action) {
        String confirm = action.equals("MoveForum") ? WebUIUtils.getLabel(null, (String)"UITopicContainer.confirm.MoveForum") : WebUIUtils.getLabel(null, (String)"UITopicContainer.confirm.RemoveForum");
        if (this.forumId.indexOf(Utils.FORUM_SPACE_ID_PREFIX) == 0) {
            confirm = new StringBuffer(confirm).append(WebUIUtils.getLabel(null, (String)"UICategory.confirm.in-space")).toString().replace("?", "") + " ?";
        }
        return confirm.replace("'", "\\47").replace("\"", "\\42");
    }

    public String[] getActionMenuTopic() throws Exception {
        String[] actions = new String[]{"EditTopic", "SetOpenTopic", "SetCloseTopic", "SetLockedTopic", "SetUnLockTopic", "SetStickTopic", "SetUnStickTopic", "SetMoveTopic", "SetDeleteTopic", "MergeTopic", "SetUnWaiting", "ApproveTopics", "ActivateTopics"};
        return actions;
    }

    public List<Topic> getTopicPageList() throws Exception {
        if (this.pageList == null) {
            return new ArrayList<Topic>();
        }
        this.maxPage = this.pageList.getAvailablePage();
        if (this.pageSelect > this.maxPage) {
            this.pageSelect = this.maxPage;
        }
        this.topicList = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        this.pageTopicRemember.put(this.forumId, this.pageSelect);
        if (this.topicList == null) {
            this.topicList = new ArrayList();
        }
        this.isShowActive = false;
        for (Topic topic : this.topicList) {
            if (!topic.getIsActive()) {
                this.isShowActive = true;
            }
            if (this.getUICheckBoxInput(topic.getId()) != null) {
                this.getUICheckBoxInput(topic.getId()).setChecked(false);
                continue;
            }
            this.addChild((UIComponent)new UICheckBoxInput(topic.getId(), topic.getId(), Boolean.valueOf(false)));
        }
        return this.topicList;
    }

    private Topic getTopic(String topicId) throws Exception {
        for (Topic topic : this.topicList) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return this.getForumService().getTopic(this.categoryId, this.forumId, topicId, this.userProfile.getUserId());
    }

    public long getSizePost(Topic topic) throws Exception {
        long maxPost = this.userProfile.getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        if (topic.getPostCount() >= maxPost) {
            long availablePost = 0L;
            if (this.isModerator) {
                availablePost = topic.getPostCount() + 1L;
            } else {
                String isApprove = ForumUtils.EMPTY_STR;
                String userLogin = this.userProfile.getUserId();
                if ((this.forum.getIsModeratePost() || topic.getIsModeratePost()) && !topic.getOwner().equals(userLogin)) {
                    isApprove = "true";
                }
                availablePost = this.getForumService().getAvailablePost(this.categoryId, this.forumId, topic.getId(), isApprove, "false", userLogin);
            }
            long value = availablePost / maxPost;
            if (value * maxPost < availablePost) {
                ++value;
            }
            return value;
        }
        return 1L;
    }

    public String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    public boolean isModerator() {
        return this.isModerator;
    }

    static /* synthetic */ Forum access$000(UITopicContainer x0) {
        return x0.forum;
    }

    static /* synthetic */ boolean access$100(UITopicContainer x0) {
        return x0.isModerator;
    }

    static /* synthetic */ String access$200(UITopicContainer x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$300(UITopicContainer x0) {
        return x0.forumId;
    }

    static /* synthetic */ Topic access$400(UITopicContainer x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ Forum access$002(UITopicContainer x0, Forum x1) {
        x0.forum = x1;
        return x0.forum;
    }

    static /* synthetic */ Log access$500(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Forum access$600(UITopicContainer x0) throws Exception {
        return x0.getForum();
    }

    static /* synthetic */ boolean access$702(UITopicContainer x0, boolean x1) {
        x0.isUpdate = x1;
        return x0.isUpdate;
    }

    static /* synthetic */ boolean access$802(UITopicContainer x0, boolean x1) {
        x0.isReload = x1;
        return x0.isReload;
    }

    static /* synthetic */ Log access$900(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1000(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1100(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1200(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1300(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1400(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1500(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1600(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1700(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1800(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1900(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$2000(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$2100(UITopicContainer x0) {
        return x0.log;
    }

    static /* synthetic */ String access$2202(UITopicContainer x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$2200(UITopicContainer x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ void access$2300(UITopicContainer x0, String x1, String x2) {
        x0.setCssClassForSorting(x1, x2);
    }
}

