/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.webui.popup.UIForumInputWithActions;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UIForumInputWithActions
extends UIFormInputSet {
    public static Log log = ExoLogger.getLogger(UIForumInputWithActions.class);
    Map<String, List<ActionData>> actionField = new HashMap();
    private String actionAddItem;
    private String labelActionAddItem;
    private String actionIdAddItem = ForumUtils.EMPTY_STR;
    private Map<String, String> mapLabelInfo = new HashMap();

    public UIForumInputWithActions(String id) {
        super.setId(id);
    }

    public Map<String, String> getMapLabelInfo() {
        return this.mapLabelInfo;
    }

    public void setMapLabelInfo(String itemId, String valueInfo) {
        this.mapLabelInfo.put(itemId, valueInfo);
    }

    public String getActionAddItem() {
        return this.actionAddItem;
    }

    public void setActionAddItem(String actionAddItem) {
        this.actionAddItem = actionAddItem;
    }

    public String getLabelActionAddItem() {
        return this.labelActionAddItem;
    }

    public void setLabelActionAddItem(String labelActionAddItem) {
        this.labelActionAddItem = labelActionAddItem;
    }

    public String getActionIdAddItem() {
        return this.actionIdAddItem;
    }

    public void setActionIdAddItem(String actionIdAddItem) {
        this.actionIdAddItem = actionIdAddItem;
    }

    public void setActionField(String fieldName, List<ActionData> actions) throws Exception {
        this.actionField.put(fieldName, actions);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getComponentConfig() != null) {
            super.processRender(context);
            return;
        }
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        Writer w = context.getWriter();
        w.write("<div id=\"" + this.getId() + "\" class=\"UIFormInputSet " + this.getId() + "\">");
        w.write("<table class=\"UIFormGrid\">");
        ResourceBundle res = context.getApplicationResourceBundle();
        for (UIComponent inputEntry : this.getChildren()) {
            String label;
            if (!inputEntry.isRendered()) continue;
            try {
                label = uiForm.getLabel(res, inputEntry.getId());
                if (inputEntry instanceof UIFormInputBase) {
                    ((UIFormInputBase)inputEntry).setLabel(label);
                }
            }
            catch (MissingResourceException ex) {
                label = inputEntry.getId();
                log.info((Object)("\n " + uiForm.getId() + ".label." + inputEntry.getId() + " not found value"));
            }
            if (!this.mapLabelInfo.isEmpty() && this.mapLabelInfo.containsKey(inputEntry.getId())) {
                w.write("<tr>");
                w.write("  <td colspan=\"2\">");
                w.write("    <div style=\"height:18px;\"><div class=\"InfoMessageIcon\" id=\"" + inputEntry.getId() + "Info\">" + (String)this.mapLabelInfo.get(inputEntry.getId()) + "</div></div>");
                w.write("  </td>");
                w.write("</tr>");
            }
            w.write("<tr>");
            w.write("<td class=\"FieldLabel\">");
            w.write(label);
            w.write("</td>");
            w.write("<td class=\"FieldComponent\">");
            this.renderUIComponent(inputEntry);
            List actions = (List)this.actionField.get(inputEntry.getName());
            if (actions != null) {
                for (ActionData action : actions) {
                    String actionLabel;
                    try {
                        actionLabel = uiForm.getLabel(res, action.getActionName());
                    }
                    catch (MissingResourceException ex) {
                        actionLabel = action.getActionName();
                    }
                    String actionLink = action.getActionParameter() != null ? this.getParent().event(action.getActionListener(), action.getActionParameter()) : this.getParent().event(action.getActionListener());
                    w.write("<a title=\"" + actionLabel + "\" href=\"" + actionLink + "\">");
                    if (action.getActionType() == 0) {
                        w.write("<img src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" alt=\"" + ForumUtils.getSubString((String)actionLabel, (int)30) + "\" class=\"" + action.getCssIconClass() + "\"/>");
                        if (ActionData.access$000((ActionData)action)) {
                            w.write(ForumUtils.getSubString((String)actionLabel, (int)30));
                        }
                    } else if (action.getActionType() == 1) {
                        w.write(ForumUtils.getSubString((String)actionLabel, (int)30));
                    } else if (action.getActionType() == 2) {
                        String size = ForumUtils.EMPTY_STR;
                        if (actionLabel.lastIndexOf("(") > 0) {
                            size = actionLabel.substring(actionLabel.lastIndexOf("("));
                            actionLabel = actionLabel.substring(0, actionLabel.lastIndexOf("("));
                        }
                        String type = ForumUtils.EMPTY_STR;
                        int dot = actionLabel.lastIndexOf(".");
                        if (dot > 0) {
                            type = actionLabel.substring(dot);
                            actionLabel = actionLabel.substring(0, dot);
                        }
                        String alt = actionLabel;
                        actionLabel = ForumUtils.getSubString((String)actionLabel, (int)30) + type + size;
                        w.write("<img alt=\"" + alt + "\" src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" class=\"" + action.getCssIconClass() + "\"/>");
                        if (ActionData.access$000((ActionData)action)) {
                            w.write(actionLabel);
                        }
                    }
                    w.write("</a>");
                    w.write("&nbsp;");
                    if (!action.isBreakLine()) continue;
                    w.write("<br/>");
                }
            }
            if (inputEntry.getId().equals(this.actionIdAddItem)) {
                w.write("<div class=\"AddActionItem\"><a href=\"" + this.getParent().event(this.actionAddItem) + "\">" + this.labelActionAddItem + "</a></div>");
            }
            w.write("</td>");
            w.write("</tr>");
        }
        w.write("</table>");
        w.write("</div>");
    }

    public UIFormDateTimeInput getUIFormDateTimeInput(String name) {
        return (UIFormDateTimeInput)this.findComponentById(name);
    }

    public UIFormRadioBoxInput getUIFormRadioBoxInput(String name) {
        return (UIFormRadioBoxInput)this.findComponentById(name);
    }

    public UICheckBoxInput getUICheckBoxInput(String name) {
        return (UICheckBoxInput)this.findComponentById(name);
    }
}

