/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xwiki.xwiki20;

import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReferenceParser;
import org.wikimodel.wem.xwiki.xwiki20.XWikiWikiParameters;

public class XWikiReferenceParser
extends WikiReferenceParser {
    protected String getLabel(String[] chunks) {
        return chunks[0];
    }

    protected String getLink(String[] chunks) {
        return chunks[1];
    }

    protected WikiParameters getParameters(String[] chunks) {
        return XWikiWikiParameters.newWikiParameters(chunks[2]);
    }

    protected String[] splitToChunks(String str) {
        String[] chunks = new String[3];
        char[] array = str.toCharArray();
        StringBuffer label = new StringBuffer();
        StringBuffer reference = new StringBuffer();
        StringBuffer parameters = new StringBuffer();
        boolean foundReference = false;
        boolean escaped = false;
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (!escaped) {
                if (array[i] == '~') {
                    escaped = true;
                    continue;
                }
                int nb = this.countFirstChar(array, i, '>');
                if (nb >= 2) {
                    while (nb > 2) {
                        label.append(array[i++]);
                        --nb;
                    }
                    foundReference = true;
                    this.parseReference(array, i += 2, reference, parameters);
                    break;
                }
                nb = this.countFirstChar(array, i, '|');
                if (nb >= 2) {
                    while (nb > 2) {
                        label.append(array[i++]);
                        --nb;
                    }
                    parameters.append(array, i += 2, array.length - i);
                    break;
                }
                if (c == '[' && i + 1 < array.length && array[i + 1] == '[') {
                    int endLink = this.findEndLink(array, i + 2);
                    if (endLink != -1) {
                        label.append(array, i, endLink - i);
                        i = endLink - 1;
                        continue;
                    }
                    label.append("[[");
                    ++i;
                    continue;
                }
                label.append(c);
                continue;
            }
            label.append(c);
            escaped = false;
        }
        if (!foundReference) {
            chunks[1] = label.toString();
        } else {
            chunks[0] = label.toString();
            chunks[1] = reference.toString();
        }
        if (parameters.length() > 0) {
            chunks[2] = parameters.toString();
        }
        return chunks;
    }

    private int findEndLink(char[] array, int i) {
        int linkdepth = 1;
        int endLink = -1;
        boolean escaped = false;
        while (i < array.length) {
            char c = array[i];
            if (!escaped) {
                if (array[i] == '~') {
                    escaped = true;
                } else if (c == '[' && i + 1 < array.length && array[i + 1] == '[') {
                    ++linkdepth;
                    ++i;
                } else if (c == ']' && i + 1 < array.length && array[i + 1] == ']') {
                    endLink = ++i + 1;
                    if (--linkdepth == 0) {
                        break;
                    }
                }
            } else {
                escaped = false;
            }
            ++i;
        }
        return endLink;
    }

    private void parseReference(char[] array, int i, StringBuffer reference, StringBuffer parameters) {
        boolean escaped = false;
        while (i < array.length) {
            char c = array[i];
            if (!escaped) {
                if (array[i] == '~' && !escaped) {
                    escaped = true;
                } else {
                    int nb = this.countFirstChar(array, i, '|');
                    if (nb >= 2) {
                        while (nb > 2) {
                            reference.append(array[i++]);
                            --nb;
                        }
                        parameters.append(array, i += 2, array.length - i);
                        break;
                    }
                    reference.append(c);
                }
            } else {
                reference.append(c);
                escaped = false;
            }
            ++i;
        }
    }

    private int countFirstChar(char[] array, int i, char c) {
        int nb = 0;
        while (i < array.length && array[i] == c) {
            ++nb;
            ++i;
        }
        return nb;
    }
}

