/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.EmptyBlockChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLChainingRenderer
extends AbstractChainingPrintRenderer {
    private XHTMLLinkRenderer linkRenderer;
    private XHTMLImageRenderer imageRenderer;
    private XHTMLWikiPrinter xhtmlWikiPrinter;

    public XHTMLChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        this.setListenerChain(listenerChain);
        this.linkRenderer = linkRenderer;
        this.imageRenderer = imageRenderer;
    }

    protected BlockStateChainingListener getBlockState() {
        return (BlockStateChainingListener)this.getListenerChain().getListener(BlockStateChainingListener.class);
    }

    protected EmptyBlockChainingListener getEmptyBlockState() {
        return (EmptyBlockChainingListener)this.getListenerChain().getListener(EmptyBlockChainingListener.class);
    }

    @Override
    protected void pushPrinter(WikiPrinter wikiPrinter) {
        super.pushPrinter(wikiPrinter);
        this.getXHTMLWikiPrinter().setWikiPrinter(this.getPrinter());
    }

    @Override
    protected void popPrinter() {
        super.popPrinter();
        this.getXHTMLWikiPrinter().setWikiPrinter(this.getPrinter());
    }

    protected XHTMLWikiPrinter getXHTMLWikiPrinter() {
        if (this.xhtmlWikiPrinter == null) {
            this.xhtmlWikiPrinter = new XHTMLWikiPrinter(this.getPrinter());
        }
        return this.xhtmlWikiPrinter;
    }

    @Override
    public void beginGroup(Map<String, String> parameters) {
        LinkedHashMap<String, String> clonedParameters = new LinkedHashMap<String, String>();
        clonedParameters.putAll(parameters);
        this.getXHTMLWikiPrinter().printXMLStartElement("div", clonedParameters);
    }

    @Override
    public void endGroup(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("div");
    }

    @Override
    public void beginFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.getXHTMLWikiPrinter().printXMLStartElement("strong");
                break;
            }
            case ITALIC: {
                this.getXHTMLWikiPrinter().printXMLStartElement("em");
                break;
            }
            case STRIKEDOUT: {
                this.getXHTMLWikiPrinter().printXMLStartElement("del");
                break;
            }
            case UNDERLINED: {
                this.getXHTMLWikiPrinter().printXMLStartElement("ins");
                break;
            }
            case SUPERSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLStartElement("sup");
                break;
            }
            case SUBSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLStartElement("sub");
                break;
            }
            case MONOSPACE: {
                this.getXHTMLWikiPrinter().printXMLStartElement("tt");
            }
        }
        if (!parameters.isEmpty()) {
            this.getXHTMLWikiPrinter().printXMLStartElement("span", parameters);
        }
    }

    @Override
    public void endFormat(Format format, Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            this.getXHTMLWikiPrinter().printXMLEndElement("span");
        }
        switch (format) {
            case BOLD: {
                this.getXHTMLWikiPrinter().printXMLEndElement("strong");
                break;
            }
            case ITALIC: {
                this.getXHTMLWikiPrinter().printXMLEndElement("em");
                break;
            }
            case STRIKEDOUT: {
                this.getXHTMLWikiPrinter().printXMLEndElement("del");
                break;
            }
            case UNDERLINED: {
                this.getXHTMLWikiPrinter().printXMLEndElement("ins");
                break;
            }
            case SUPERSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLEndElement("sup");
                break;
            }
            case SUBSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLEndElement("sub");
                break;
            }
            case MONOSPACE: {
                this.getXHTMLWikiPrinter().printXMLEndElement("tt");
            }
        }
    }

    @Override
    public void beginParagraph(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("p", parameters);
    }

    @Override
    public void endParagraph(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("p");
    }

    @Override
    public void onNewLine() {
        this.getXHTMLWikiPrinter().printXMLElement("br");
    }

    @Override
    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.linkRenderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        this.linkRenderer.beginLink(reference, isFreeStandingURI, parameters);
    }

    @Override
    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.linkRenderer.setHasLabel(!this.getEmptyBlockState().isCurrentContainerBlockEmpty());
        this.linkRenderer.endLink(reference, isFreeStandingURI, parameters);
    }

    @Override
    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("id", id);
        attributes.putAll(parameters);
        if (this.getBlockState().isInMacro()) {
            String classAttributeName = "class";
            String classValue = (String)attributes.get(classAttributeName);
            String newClassValue = "wikigeneratedheader";
            classValue = classValue == null ? newClassValue : classValue.trim() + " " + newClassValue;
            attributes.put(classAttributeName, classValue);
        }
        this.getXHTMLWikiPrinter().printXMLStartElement("h" + level.getAsInt(), attributes);
        this.getXHTMLWikiPrinter().printXMLStartElement("span");
    }

    @Override
    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("span");
        this.getXHTMLWikiPrinter().printXMLEndElement("h" + level.getAsInt());
    }

    @Override
    public void onWord(String word) {
        this.getXHTMLWikiPrinter().printXML(word);
    }

    @Override
    public void onSpace() {
        this.getXHTMLWikiPrinter().printSpace();
    }

    @Override
    public void onSpecialSymbol(char symbol) {
        this.getXHTMLWikiPrinter().printXML("" + symbol);
    }

    @Override
    public void beginList(ListType listType, Map<String, String> parameters) {
        if (listType == ListType.BULLETED) {
            this.getXHTMLWikiPrinter().printXMLStartElement("ul", parameters);
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("ol", parameters);
        }
    }

    @Override
    public void beginListItem() {
        this.getXHTMLWikiPrinter().printXMLStartElement("li");
    }

    @Override
    public void endList(ListType listType, Map<String, String> parameters) {
        if (listType == ListType.BULLETED) {
            this.getXHTMLWikiPrinter().printXMLEndElement("ul");
        } else {
            this.getXHTMLWikiPrinter().printXMLEndElement("ol");
        }
    }

    @Override
    public void endListItem() {
        this.getXHTMLWikiPrinter().printXMLEndElement("li");
    }

    @Override
    public void onId(String name) {
        if (this.getBlockState().isInLine()) {
            this.getXHTMLWikiPrinter().printXMLStartElement("span", new String[][]{{"id", name}});
            this.getXHTMLWikiPrinter().printXMLEndElement("span");
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("div", new String[][]{{"id", name}});
            this.getXHTMLWikiPrinter().printXMLEndElement("div");
        }
    }

    @Override
    public void onHorizontalLine(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLElement("hr", parameters);
    }

    @Override
    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        if (isInline) {
            this.getXHTMLWikiPrinter().printXMLStartElement("tt", new String[][]{{"class", "wikimodel-verbatim"}});
            this.getXHTMLWikiPrinter().printXML(protectedString);
            this.getXHTMLWikiPrinter().printXMLEndElement("tt");
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("pre", parameters);
            this.getXHTMLWikiPrinter().printXML(protectedString);
            this.getXHTMLWikiPrinter().printXMLEndElement("pre");
        }
    }

    @Override
    public void onEmptyLines(int count) {
        for (int i = 0; i < count; ++i) {
            this.getXHTMLWikiPrinter().printXMLStartElement("div", new String[][]{{"class", "wikimodel-emptyline"}});
            this.getXHTMLWikiPrinter().printXMLEndElement("div");
        }
    }

    @Override
    public void beginDefinitionList(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("dl", parameters);
    }

    @Override
    public void endDefinitionList(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("dl");
    }

    @Override
    public void beginDefinitionTerm() {
        this.getXHTMLWikiPrinter().printXMLStartElement("dt");
    }

    @Override
    public void beginDefinitionDescription() {
        this.getXHTMLWikiPrinter().printXMLStartElement("dd");
    }

    @Override
    public void endDefinitionTerm() {
        this.getXHTMLWikiPrinter().printXMLEndElement("dt");
    }

    @Override
    public void endDefinitionDescription() {
        this.getXHTMLWikiPrinter().printXMLEndElement("dd");
    }

    @Override
    public void beginQuotation(Map<String, String> parameters) {
        if (this.getBlockState().isInQuotationLine()) {
            this.getXHTMLWikiPrinter().printXMLEndElement("p");
        }
        this.getXHTMLWikiPrinter().printXMLStartElement("blockquote", parameters);
        this.getXHTMLWikiPrinter().printXMLStartElement("p");
    }

    @Override
    public void endQuotation(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("p");
        this.getXHTMLWikiPrinter().printXMLEndElement("blockquote");
        if (this.getBlockState().isInQuotationLine()) {
            this.getXHTMLWikiPrinter().printXMLStartElement("p");
        }
    }

    @Override
    public void beginQuotationLine() {
        if (this.getBlockState().isInQuotation() && this.getBlockState().getPreviousEvent() == BlockStateChainingListener.Event.QUOTATION_LINE) {
            this.onNewLine();
        }
    }

    @Override
    public void beginTable(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("table", parameters);
    }

    @Override
    public void beginTableRow(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("tr", parameters);
    }

    @Override
    public void beginTableCell(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("td", parameters);
    }

    @Override
    public void beginTableHeadCell(Map<String, String> parameters) {
        Map<String, String> parametersWithScope;
        if (!parameters.containsKey("scope")) {
            parametersWithScope = new LinkedHashMap<String, String>(parameters);
            if (this.getBlockState().getCellRow() == 0 || this.getBlockState().getCellCol() > 0) {
                parametersWithScope.put("scope", "col");
            } else {
                parametersWithScope.put("scope", "row");
            }
        } else {
            parametersWithScope = parameters;
        }
        this.getXHTMLWikiPrinter().printXMLStartElement("th", parametersWithScope);
    }

    @Override
    public void endTable(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("table");
    }

    @Override
    public void endTableRow(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("tr");
    }

    @Override
    public void endTableCell(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("td");
    }

    @Override
    public void endTableHeadCell(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("th");
    }

    @Override
    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.imageRenderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        this.imageRenderer.onImage(reference, isFreeStandingURI, parameters);
    }

    @Override
    public void onRawText(String text, Syntax syntax) {
        if (syntax.getType() == SyntaxType.XHTML || syntax.getType() == SyntaxType.HTML) {
            this.getXHTMLWikiPrinter().printRaw(text);
        }
    }
}

