/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.StringReferenceSeparators;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="local/uid")
@Singleton
public class LocalUidStringEntityReferenceSerializer
implements EntityReferenceSerializer<String> {
    @Override
    public String serialize(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        StringBuilder representation = new StringBuilder();
        List<EntityReference> references = reference.getReversedReferenceChain();
        EntityReference wikiReference = references.get(0);
        if (wikiReference.getType() == EntityType.WIKI) {
            references.remove(0);
        } else {
            wikiReference = null;
        }
        for (EntityReference currentReference : references) {
            this.serializeEntityReference(currentReference, representation, wikiReference, parameters);
        }
        return representation.toString();
    }

    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, EntityReference wikiReference, Object ... parameters) {
        String name = currentReference.getName();
        if (wikiReference != null && currentReference.getType() == EntityType.OBJECT && name.startsWith(wikiReference.getName() + StringReferenceSeparators.WIKISEP)) {
            name = name.substring(wikiReference.getName().length() + 1);
        }
        representation.append(name.length()).append(':').append(name);
    }
}

