/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xml.sax;

import java.util.Map;
import org.wikimodel.wem.WikiPageUtil;
import org.wikimodel.wem.xml.ITagListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WemToSax
implements ITagListener {
    public static final String USER_NS = "http://www.wikimodel.org/ns/user-defined-params#";
    public static final String USER_PREFIX = "u";
    public static final String WEM_NS = "http://www.wikimodel.org/ns/wem#";
    public static final String WEM_PREFIX = "w";
    private int fDepth;
    private ContentHandler fHandler;

    public WemToSax(ContentHandler handler) {
        this.fHandler = handler;
    }

    @Override
    public void beginTag(String tagName, Map<String, String> tagParams, Map<String, String> userParams) {
        try {
            if (this.fDepth == 0) {
                this.fHandler.startDocument();
                this.fHandler.startPrefixMapping(WEM_PREFIX, WEM_NS);
                this.fHandler.startPrefixMapping(USER_PREFIX, USER_NS);
            }
            Attributes atts = this.getAttributes(tagParams, userParams);
            this.fHandler.startElement(WEM_NS, tagName, this.getQualifiedName(WEM_PREFIX, tagName), atts);
            ++this.fDepth;
        }
        catch (Throwable e) {
            throw this.handleError(e);
        }
    }

    @Override
    public void endTag(String tagName, Map<String, String> tagParams, Map<String, String> userParams) {
        try {
            this.fHandler.endElement(WEM_NS, tagName, this.getQualifiedName(WEM_PREFIX, tagName));
            --this.fDepth;
            if (this.fDepth == 0) {
                this.fHandler.endDocument();
            }
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    private Attributes getAttributes(final Map<String, String> tagParams, final Map<String, String> userParams) {
        final Object[] tArray = tagParams.entrySet().toArray();
        final Object[] uArray = userParams.entrySet().toArray();
        return new Attributes(){

            private Map.Entry<String, String> getEntry(int index) {
                if (index < 0 || index > tArray.length + uArray.length) {
                    return null;
                }
                if (index < tArray.length) {
                    return (Map.Entry)tArray[index];
                }
                return (Map.Entry)uArray[index -= tArray.length];
            }

            @Override
            public int getIndex(String qName) {
                int idx = qName.indexOf(58);
                String prefix = idx >= 0 ? qName.substring(0, idx) : "";
                qName = qName.substring(idx + 1);
                return this.getIndex(prefix, qName, WemToSax.WEM_PREFIX, WemToSax.USER_PREFIX);
            }

            @Override
            public int getIndex(String uri, String localName) {
                return this.getIndex(uri, localName, WemToSax.WEM_NS, WemToSax.USER_NS);
            }

            private int getIndex(String uri, String localName, String wemNS, String usrNS) {
                Object[] array = null;
                int base = 0;
                if (wemNS.equals(uri)) {
                    array = tArray;
                } else if (usrNS.equals(uri)) {
                    base = tArray.length;
                    array = uArray;
                }
                if (array == null) {
                    return -1;
                }
                int result = -1;
                int pos = 0;
                for (Object obj : array) {
                    Map.Entry entry = (Map.Entry)obj;
                    if (localName.equals(entry.getKey())) {
                        result = base + pos;
                        break;
                    }
                    ++pos;
                }
                return result;
            }

            @Override
            public int getLength() {
                return tArray.length + uArray.length;
            }

            @Override
            public String getLocalName(int index) {
                Map.Entry<String, String> entry = this.getEntry(index);
                if (entry == null) {
                    return null;
                }
                return entry.getKey();
            }

            @Override
            public String getQName(int index) {
                Map.Entry<String, String> entry = this.getEntry(index);
                if (entry == null) {
                    return null;
                }
                String prefix = null;
                if (this.isUserParam(index)) {
                    prefix = WemToSax.USER_PREFIX;
                } else if (this.isTagParam(index)) {
                    prefix = WemToSax.WEM_PREFIX;
                }
                return WemToSax.this.getQualifiedName(prefix, entry.getKey());
            }

            @Override
            public String getType(int index) {
                return "CDATA";
            }

            @Override
            public String getType(String qName) {
                return "CDATA";
            }

            @Override
            public String getType(String uri, String localName) {
                return "CDATA";
            }

            @Override
            public String getURI(int index) {
                if (this.isTagParam(index)) {
                    return WemToSax.WEM_NS;
                }
                if (this.isUserParam(index)) {
                    return WemToSax.USER_NS;
                }
                return null;
            }

            @Override
            public String getValue(int index) {
                Map.Entry<String, String> entry = this.getEntry(index);
                if (entry != null) {
                    return entry.getValue();
                }
                return null;
            }

            private String getValue(Map<String, String> map, String key) {
                String value = map.get(key);
                value = WikiPageUtil.escapeXmlAttribute(value);
                return value;
            }

            @Override
            public String getValue(String qName) {
                int idx = qName.indexOf(58);
                String prefix = qName.substring(0, idx);
                qName = qName.substring(idx + 1);
                if (WemToSax.WEM_PREFIX.equals(prefix)) {
                    return this.getValue(tagParams, qName);
                }
                if (WemToSax.USER_PREFIX.equals(prefix)) {
                    return this.getValue(userParams, qName);
                }
                return null;
            }

            @Override
            public String getValue(String uri, String localName) {
                if (WemToSax.WEM_NS.equals(uri)) {
                    return this.getValue(tagParams, localName);
                }
                if (WemToSax.USER_NS.equals(uri)) {
                    return this.getValue(userParams, localName);
                }
                return null;
            }

            private boolean isTagParam(int index) {
                return index >= 0 && index < tArray.length;
            }

            private boolean isUserParam(int index) {
                return index >= tArray.length && index < tArray.length + uArray.length;
            }
        };
    }

    private String getQualifiedName(String prefix, String tagName) {
        tagName = WikiPageUtil.escapeXmlAttribute(tagName);
        return prefix != null && !"".equals(prefix) ? prefix + ":" + tagName : tagName;
    }

    private RuntimeException handleError(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new RuntimeException(e);
    }

    @Override
    public void onCDATA(String content) {
        this.onText(content);
    }

    @Override
    public void onTag(String tagName, Map<String, String> tagParams, Map<String, String> userParams) {
        this.beginTag(tagName, tagParams, userParams);
        this.endTag(tagName, tagParams, userParams);
    }

    @Override
    public void onText(String content) {
        try {
            content = WikiPageUtil.escapeXmlString(content, false);
            char[] chars = content.toCharArray();
            this.fHandler.characters(chars, 0, chars.length);
        }
        catch (Throwable e) {
            throw this.handleError(e);
        }
    }
}

