/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.syntax;

import org.xwiki.rendering.syntax.SyntaxType;

public class Syntax {
    public static final Syntax XHTML_1_0 = new Syntax(SyntaxType.XHTML, "1.0");
    public static final Syntax HTML_4_01 = new Syntax(SyntaxType.HTML, "4.01");
    public static final Syntax XWIKI_1_0 = new Syntax(SyntaxType.XWIKI, "1.0");
    public static final Syntax XWIKI_2_0 = new Syntax(SyntaxType.XWIKI, "2.0");
    public static final Syntax XWIKI_2_1 = new Syntax(SyntaxType.XWIKI, "2.1", "experimental");
    public static final Syntax PLAIN_1_0 = new Syntax(SyntaxType.PLAIN, "1.0");
    public static final Syntax EVENT_1_0 = new Syntax(SyntaxType.EVENT, "1.0");
    public static final Syntax TEX_1_0 = new Syntax(SyntaxType.TEX, "1.0");
    public static final Syntax CREOLE_1_0 = new Syntax(SyntaxType.CREOLE, "1.0");
    public static final Syntax JSPWIKI_1_0 = new Syntax(SyntaxType.JSPWIKI, "1.0");
    public static final Syntax MEDIAWIKI_1_0 = new Syntax(SyntaxType.MEDIAWIKI, "1.0");
    public static final Syntax CONFLUENCE_1_0 = new Syntax(SyntaxType.CONFLUENCE, "1.0");
    public static final Syntax TWIKI_1_0 = new Syntax(SyntaxType.TWIKI, "1.0");
    public static final Syntax DOCBOOK_4_4 = new Syntax(SyntaxType.DOCBOOK, "4.4");
    public static final Syntax XDOMXML_CURRENT = new Syntax(SyntaxType.XDOMXML, "current");
    public static final Syntax XDOMXML_1_0 = new Syntax(SyntaxType.XDOMXML, "1.0");
    public static final Syntax ANNOTATED_XHTML_1_0 = new Syntax(SyntaxType.ANNOTATED_XHTML, "1.0");
    private SyntaxType type;
    private String version;
    private String qualifier;

    public Syntax(SyntaxType type, String version) {
        this.type = type;
        this.version = version;
    }

    public Syntax(SyntaxType type, String version, String qualifier) {
        this(type, version);
        this.qualifier = qualifier;
    }

    public SyntaxType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toIdString() {
        return this.getType().getId() + "/" + this.getVersion().toLowerCase();
    }

    public String toString() {
        return this.getType().toString() + " " + this.getVersion() + (this.getQualifier() != null ? " (" + this.getQualifier() + ")" : "");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.getType() ? 0 : this.getType().hashCode());
        hash = 31 * hash + (null == this.getVersion() ? 0 : this.getVersion().hashCode());
        hash = 31 * hash + (null == this.getQualifier() ? 0 : this.getQualifier().hashCode());
        return hash;
    }

    public boolean equals(Object object) {
        boolean result;
        if (this == object) {
            result = true;
        } else if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            Syntax syntax = (Syntax)object;
            result = (this.getType() == syntax.getType() || this.getType() != null && this.getType().equals(syntax.getType())) && (this.getVersion() == syntax.getVersion() || this.getVersion() != null && this.getVersion().equals(syntax.getVersion())) && (this.getQualifier() == syntax.getQualifier() || this.getQualifier() != null && this.getQualifier().equals(syntax.getQualifier()));
        }
        return result;
    }
}

