/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.service.Permission;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.webui.UIPermissionGrid;
import org.exoplatform.wiki.webui.UIWikiPermissionEntry;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPermissionForm.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={DeleteEntryActionListener.class}), @EventConfig(listeners={OpenSelectUserFormActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectGroupFormActionListener.class}), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectMembershipFormActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class})}), @ComponentConfig(type=UIPopupWindow.class, id="UIWikiUserPermissionPopupSelector", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={SelectUserActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseUserPopupActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIWikiPermissionForm
extends UIWikiForm
implements UIPopupComponent {
    private List<PermissionEntry> permissionEntries = new ArrayList();
    private Scope scope;
    public static String ANY = "any";
    public static String ADD_ENTRY = "AddEntry";
    public static String DELETE_ENTRY = "DeleteEntry";
    public static String WIKI_PERMISSION_OWNER = "UIWikiPermissionOwner";
    public static String PERMISSION_OWNER = "PermissionOwner";
    public static String PERMISSION_POPUP_SELECTOR = "UIWikiPermissionPopupSelector";
    public static String USER_PERMISSION_POPUP_SELECTOR = "UIWikiUserPermissionPopupSelector";
    public static String OPEN_SELECT_USER_FORM = "OpenSelectUserForm";
    public static String OPEN_SELECT_GROUP_FORM = "OpenSelectGroupForm";
    public static String OPEN_SELECT_MEMBERSHIP_FORM = "OpenSelectMembershipForm";
    public static String GROUP_ICON = "ActionIcon GroupIcon";
    public static String USER_ICON = "ActionIcon UserIcon";
    public static String MEMBERSHIP_ICON = "ActionIcon MembershipIcon";
    public static String ADD_ICON = "ActionIcon Add";
    public static String SAVE = "Save";
    public static String CLOSE = "Close";

    public UIWikiPermissionForm() throws Exception {
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.addChild(UIPermissionGrid.class, null, null);
        permissionGrid.setPermissionEntries(this.permissionEntries);
        UIFormInputWithActions owner = new UIFormInputWithActions(WIKI_PERMISSION_OWNER);
        owner.addUIFormInput((UIFormInput)new UIFormStringInput(PERMISSION_OWNER, PERMISSION_OWNER, null));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectUser = new UIFormInputWithActions.ActionData();
        selectUser.setActionListener(OPEN_SELECT_USER_FORM);
        selectUser.setActionType(0);
        selectUser.setActionName(OPEN_SELECT_USER_FORM);
        selectUser.setCssIconClass(USER_ICON);
        actions.add(selectUser);
        UIFormInputWithActions.ActionData selectGroup = new UIFormInputWithActions.ActionData();
        selectGroup.setActionListener(OPEN_SELECT_GROUP_FORM);
        selectGroup.setActionType(0);
        selectGroup.setActionName(OPEN_SELECT_GROUP_FORM);
        selectGroup.setCssIconClass(GROUP_ICON);
        actions.add(selectGroup);
        UIFormInputWithActions.ActionData selectMembership = new UIFormInputWithActions.ActionData();
        selectMembership.setActionListener(OPEN_SELECT_MEMBERSHIP_FORM);
        selectMembership.setActionType(0);
        selectMembership.setActionName(OPEN_SELECT_MEMBERSHIP_FORM);
        selectMembership.setCssIconClass(MEMBERSHIP_ICON);
        actions.add(selectMembership);
        UIFormInputWithActions.ActionData addOwner = new UIFormInputWithActions.ActionData();
        addOwner.setActionListener(ADD_ENTRY);
        addOwner.setActionType(0);
        addOwner.setActionName(ADD_ENTRY);
        addOwner.setCssIconClass(ADD_ICON);
        actions.add(addOwner);
        owner.setActionField(PERMISSION_OWNER, actions);
        this.addChild((UIComponent)owner);
        this.addChild(UIPopupWindow.class, USER_PERMISSION_POPUP_SELECTOR, USER_PERMISSION_POPUP_SELECTOR);
        this.addChild(UIPopupWindow.class, null, PERMISSION_POPUP_SELECTOR);
        this.setActions(new String[]{SAVE, CLOSE});
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
        if (Scope.WIKI.equals((Object)this.scope)) {
            this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.EDITPAGE, WikiMode.ADDPAGE, WikiMode.DELETEPAGE, WikiMode.VIEWREVISION, WikiMode.SHOWHISTORY, WikiMode.ADVANCEDSEARCH, WikiMode.SPACESETTING);
            this.setActions(new String[]{SAVE});
        } else if (Scope.PAGE.equals((Object)this.scope)) {
            this.accept_Modes = Arrays.asList(WikiMode.VIEW);
            this.setActions(new String[]{SAVE, CLOSE});
        }
    }

    public void setPermission(List<PermissionEntry> permissionEntries) throws Exception {
        this.permissionEntries = permissionEntries;
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChild(UIPermissionGrid.class);
        permissionGrid.setPermissionEntries(this.permissionEntries);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private void processPostAction() throws Exception {
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChild(UIPermissionGrid.class);
        List permissionEntries = permissionGrid.getChildren();
        ArrayList<PermissionEntry> permEntries = new ArrayList<PermissionEntry>();
        for (UIComponent uiPermissionEntry : permissionEntries) {
            Permission[] permissions;
            PermissionEntry permissionEntry = ((UIWikiPermissionEntry)uiPermissionEntry).getPermissionEntry();
            for (Permission permission : permissions = permissionEntry.getPermissions()) {
                UIFormCheckBoxInput checkboxInput = (UIFormCheckBoxInput)((UIWikiPermissionEntry)uiPermissionEntry).getChildById(permission.getPermissionType().toString() + permissionEntry.getId());
                permission.setAllowed(((Boolean)checkboxInput.getValue()).booleanValue());
            }
            permEntries.add(permissionEntry);
        }
        this.setPermission(permEntries);
    }

    private HashMap<String, String[]> convertToPermissionMap(List<PermissionEntry> permissionEntries) {
        HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
        for (PermissionEntry permissionEntry : permissionEntries) {
            Permission[] permissions = permissionEntry.getPermissions();
            ArrayList<String> permlist = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                if (!permission.isAllowed()) continue;
                if (permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE)) {
                    permlist.add("read");
                    continue;
                }
                if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                permlist.add("add_node");
                permlist.add("remove");
                permlist.add("set_property");
            }
            if (permlist.size() <= 0) continue;
            permissionMap.put(permissionEntry.getId(), permlist.toArray(new String[permlist.size()]));
        }
        return permissionMap;
    }

    private void checkToUpdateByAjax(WebuiRequestContext requestContext, UIComponent forUpateComponent) {
        if (Scope.PAGE.equals((Object)this.scope)) {
            requestContext.addUIComponentToUpdateByAjax(forUpateComponent);
        }
    }

    private static void closePopupAction(UIPopupWindow uiPopupWindow, WebuiRequestContext requestContext) {
        uiPopupWindow.setUIComponent(null);
        uiPopupWindow.setShow(false);
        requestContext.addUIComponentToUpdateByAjax(uiPopupWindow.getParent());
    }

    static /* synthetic */ void access$000(UIWikiPermissionForm x0) throws Exception {
        x0.processPostAction();
    }

    static /* synthetic */ List access$100(UIWikiPermissionForm x0) {
        return x0.permissionEntries;
    }

    static /* synthetic */ void access$200(UIWikiPermissionForm x0, WebuiRequestContext x1, UIComponent x2) {
        x0.checkToUpdateByAjax(x1, x2);
    }

    static /* synthetic */ void access$300(UIPopupWindow x0, WebuiRequestContext x1) {
        UIWikiPermissionForm.closePopupAction((UIPopupWindow)x0, (WebuiRequestContext)x1);
    }

    static /* synthetic */ HashMap access$400(UIWikiPermissionForm x0, List x1) {
        return x0.convertToPermissionMap(x1);
    }
}

