/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import javax.portlet.PortletPreferences;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.wiki.WikiPortletPreference;
import org.exoplatform.wiki.webui.UIWikiPortletPreferencesForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class})})
public class UIWikiPortletPreferencesForm
extends UIForm
implements UIPopupComponent {
    private static String SHOW_BREADCRUMB = "ShowBreadcrumb";
    private static String SHOW_NAVIGATIONTREE = "ShowNavigationTree";
    private static String SAVE = "Save";
    private WikiPortletPreference portletPreference;

    public UIWikiPortletPreferencesForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SHOW_BREADCRUMB, SHOW_BREADCRUMB, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SHOW_NAVIGATIONTREE, SHOW_NAVIGATIONTREE, null));
        this.setActions(new String[]{SAVE});
        this.initComponents();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private WikiPortletPreference getPorletPreferences() {
        WikiPortletPreference preference = new WikiPortletPreference();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        preference.setShowBreadcrumb(Boolean.parseBoolean(portletPref.getValue(WikiPortletPreference.SHOW_BREADCRUMB, "true")));
        preference.setShowNavigationTree(Boolean.parseBoolean(portletPref.getValue(WikiPortletPreference.SHOW_NAVIGATIONTREE, "true")));
        return preference;
    }

    private void savePortletPreferences(WikiPortletPreference preference) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = portletRequestContext.getRequest().getPreferences();
        portletPref.setValue(WikiPortletPreference.SHOW_BREADCRUMB, String.valueOf(preference.isShowBreadcrumb()));
        portletPref.setValue(WikiPortletPreference.SHOW_NAVIGATIONTREE, String.valueOf(preference.isShowNavigationTree()));
        portletPref.store();
    }

    private void initComponents() throws Exception {
        this.portletPreference = this.getPorletPreferences();
        this.getUIFormCheckBoxInput(SHOW_BREADCRUMB).setValue((Object)this.portletPreference.isShowBreadcrumb());
        this.getUIFormCheckBoxInput(SHOW_NAVIGATIONTREE).setValue((Object)this.portletPreference.isShowNavigationTree());
    }

    static /* synthetic */ String access$000() {
        return SHOW_BREADCRUMB;
    }

    static /* synthetic */ WikiPortletPreference access$100(UIWikiPortletPreferencesForm x0) {
        return x0.portletPreference;
    }

    static /* synthetic */ String access$200() {
        return SHOW_NAVIGATIONTREE;
    }

    static /* synthetic */ void access$300(UIWikiPortletPreferencesForm x0, WikiPortletPreference x1) throws Exception {
        x0.savePortletPreferences(x1);
    }
}

