/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.transform;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.converter.Converter;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Named(value="deepconvert")
@Singleton
public class DeepConvertTransformation
extends AbstractTransformation {
    private static Logger LOG = LoggerFactory.getLogger((String)DeepConvertTransformation.class.toString());

    public void transform(Block block, TransformationContext transformationContext) throws TransformationException {
        ArrayList<Block> children = new ArrayList<Block>();
        for (Block child : block.getChildren()) {
            if (child instanceof MacroBlock) {
                String macro;
                MacroBlock macroBlock = (MacroBlock)child;
                String content = macroBlock.getContent();
                if (content.endsWith(macro = "{" + macroBlock.getId() + "}")) {
                    content = content.substring(0, content.length() - macro.length());
                }
                String formattedContent = this.formatContent(macroBlock.getId(), content);
                child = new MacroBlock(macroBlock.getId(), macroBlock.getParameters(), formattedContent, macroBlock.isInline());
                child.setChildren(macroBlock.getChildren());
            }
            children.add(child);
            this.transform(child, transformationContext);
        }
        block.setChildren(children);
    }

    public String formatContent(String macro, String content) {
        if (macro.equals("noformat") || macro.equals("code") || macro.equals("csv") || macro.equals("style")) {
            return content;
        }
        EmbeddableComponentManager ecm = new EmbeddableComponentManager();
        ecm.initialize(Thread.currentThread().getContextClassLoader());
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            Converter converter = (Converter)ecm.lookup(Converter.class);
            converter.convert((Reader)new StringReader(content), Syntax.CONFLUENCE_1_0, Syntax.XWIKI_2_0, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (ComponentLookupException e) {
            LOG.warn("TRANSFORMATION FAILURE: " + e.getMessage());
        }
        catch (ConversionException e) {
            LOG.warn("TRANSFORMATION FAILURE: " + e.getMessage());
        }
        return content;
    }
}

