/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.util;

public final class ExoWikiMacroTransformer {
    private ExoWikiMacroTransformer() {
    }

    public static String transformMacroContent(String macroContent) {
        if (!macroContent.startsWith("{iframe")) {
            return macroContent;
        }
        String[] macros = macroContent.substring(1, macroContent.length() - 1).split(":");
        String head = macros[0];
        StringBuilder result = new StringBuilder("{").append(head);
        if (macros.length > 1) {
            String[] macros2 = macros[1].split("\\|");
            boolean start = true;
            for (String param : macros2) {
                if (start) {
                    result.append(":");
                } else {
                    result.append("|");
                }
                start = false;
                result.append(ExoWikiMacroTransformer.fixParam(head, param));
            }
        }
        result.append("}");
        return result.toString();
    }

    protected static String fixParam(String head, String param) {
        if ("iframe".equals(head) && param.startsWith("src=") && !param.startsWith("src=\"")) {
            return "src=\"" + param.substring(4) + "\"";
        }
        return param;
    }
}

