/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class AnswersSpaceActivityPublisher
extends AnswerEventListener {
    private static Log LOG = ExoLogger.getExoLogger(AnswerEventListener.class);

    public void saveAnswer(String questionId, Answer answer) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            String msg = "@" + answer.getResponseBy() + " has answered: <a href=" + q.getLink() + ">" + q.getQuestion() + "</a>";
            String body = q.getLink();
            Category cal = faqS.getCategoryById(q.getCategoryId());
            String spaceId = cal.getPath().split(Utils.CATE_SPACE_ID_PREFIX)[1].split("/")[0];
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }

    public void saveComment(String questionId, Comment comment) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            String msg = "@" + comment.getCommentBy() + " has commented: <a href=" + q.getLink() + ">" + q.getQuestion() + "</a>";
            String body = q.getLink();
            Category cal = faqS.getCategoryById(q.getCategoryId());
            String spaceId = cal.getPath().split(Utils.CATE_SPACE_ID_PREFIX)[1].split("/")[0];
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when add comment " + e.getMessage()));
        }
    }

    public void saveQuestion(Question question) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String catId = question.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            String msg = "@" + question.getAuthor() + " has asked: <a href=" + question.getLink() + ">" + question.getQuestion() + "</a>";
            String body = question.getLink();
            FAQService faqS = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
            Category cal = faqS.getCategoryById(question.getCategoryId());
            String spaceId = cal.getPath().split(Utils.CATE_SPACE_ID_PREFIX)[1].split("/")[0];
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when add new questin " + e.getMessage()));
        }
    }

    public void saveAnswer(String questionId, Answer[] answers) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            if (answers.length == 1) {
                Answer answer = answers[0];
                String msg = "@" + answer.getResponseBy() + " has answered: <a href=" + q.getLink() + ">" + q.getQuestion() + "</a>";
                String body = q.getLink();
                Category cal = faqS.getCategoryById(q.getCategoryId());
                String spaceId = cal.getPath().split(Utils.CATE_SPACE_ID_PREFIX)[1].split("/")[0];
                IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
                ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
                Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
                activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
            }
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }
}

