/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.migration;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.picocontainer.Startable;

public class DataRepair
implements Startable {
    private ForumService forumService_;
    private FAQService faqService_;

    public DataRepair(FAQService faqService, ForumService forumService) throws Exception {
        this.forumService_ = forumService;
        this.faqService_ = faqService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        long item = 0L;
        long size = 0L;
        try {
            NodeIterator questionIter = this.faqService_.getQuestionsIterator(sysSession);
            size = questionIter.getSize();
            System.out.println("\n ==> Found " + size + " data item(s) to migrate in FAQ ");
            this.faqService_.removeRSSEventListener();
            while (questionIter.hasNext()) {
                Node questionNode = questionIter.nextNode();
                System.out.println(">>>>>> [" + ++item + "/" + size + "] Repairing question: " + questionNode.getProperty("exo:name").getString());
                if (!questionNode.hasProperty("exo:responses")) continue;
                try {
                    Value[] responses = questionNode.getProperty("exo:responses").getValues();
                    Value[] dateOfResponses = questionNode.getProperty("exo:dateResponse").getValues();
                    Value[] responseBy = questionNode.getProperty("exo:responseBy").getValues();
                    if (responses.length > 0) {
                        ArrayList<Answer> answers = new ArrayList<Answer>();
                        for (int i = 0; i < responses.length; ++i) {
                            Answer ans = new Answer(responseBy[i].getString(), true);
                            ans.setResponses(responses[i].getString());
                            ans.setDateResponse(dateOfResponses[i].getDate().getTime());
                            ans.setNew(true);
                            answers.add(ans);
                        }
                        this.faqService_.saveAnswer(questionNode.getName(), answers.toArray(new Answer[0]), sysSession);
                    }
                    questionNode.setProperty("exo:title", questionNode.getProperty("exo:name").getString());
                    questionNode.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (size > 0L) {
                this.faqService_.addRSSEventListener();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
        System.out.println("\n ==> " + item + "/" + size + " data item(s) repaired succesful !!! \n");
    }

    public void stop() {
    }
}

