/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.Digest;
import org.jgroups.protocols.NakAckHeader;
import org.jgroups.stack.AckMcastReceiverWindow;
import org.jgroups.stack.AckMcastSenderWindow;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.List;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class NAKACK
extends Protocol {
    long[] retransmit_timeout = new long[]{2000L, 3000L, 5000L, 8000L};
    NAKer naker = null;
    OutOfBander out_of_bander = null;
    ViewId vid = null;
    View view = null;
    boolean is_server = false;
    Address local_addr = null;
    final List queued_msgs = new List();
    Vector members = null;
    boolean send_next_msg_out_of_band = false;
    boolean send_next_msg_acking = false;
    long rebroadcast_timeout = 0L;
    TimeScheduler timer = null;
    static final String WRAPPED_MSG_KEY = "NAKACK.WRAPPED_HDR";

    public void init() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null && this.log.isErrorEnabled()) {
            this.log.error((Object)"timer is null");
        }
        this.naker = new NAKer();
        this.out_of_bander = new OutOfBander();
    }

    public void stop() {
        this.out_of_bander.stop();
        this.naker.stop();
    }

    public String getName() {
        return "NAKACK";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>(3);
        retval.addElement(new Integer(35));
        retval.addElement(new Integer(31));
        retval.addElement(new Integer(37));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(35));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("received SUSPECT event (suspected member=" + evt.getArg() + ')'));
                }
                this.naker.suspect((Address)evt.getArg());
                this.out_of_bander.suspect((Address)evt.getArg());
                break;
            }
            case 30: {
                this.naker.stable((long[])evt.getArg());
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 35: {
                long[] highest = this.naker.getHighestSeqnosDelivered();
                this.passDown(new Event(36, highest));
                return;
            }
            case 1: {
                NAKACK nAKACK = this;
                synchronized (nAKACK) {
                    NakAckHeader h;
                    Message ack_msg;
                    Message msg = (Message)evt.getArg();
                    NakAckHeader hdr = (NakAckHeader)msg.removeHeader(WRAPPED_MSG_KEY);
                    if (hdr != null && hdr.type == 3) {
                        ack_msg = new Message(hdr.sender, null, null);
                        h = new NakAckHeader(5, hdr.seqno, null);
                        if (hdr.sender == null && this.log.isWarnEnabled()) {
                            this.log.warn((Object)"WRAPPED: header's 'sender' field is null; cannot send ACK !");
                        }
                        ack_msg.putHeader(this.getName(), h);
                        this.passDown(new Event(1, ack_msg));
                    }
                    if ((hdr = (NakAckHeader)msg.removeHeader(this.getName())) == null) {
                        break;
                    }
                    switch (hdr.type) {
                        case 1: 
                        case 2: {
                            if (hdr.type == 2) {
                                ack_msg = new Message(msg.getSrc(), null, null);
                                h = new NakAckHeader(5, hdr.seqno, null);
                                ack_msg.putHeader(this.getName(), h);
                                this.passDown(new Event(1, ack_msg));
                            }
                            if (!this.is_server) {
                                Message msg_copy = msg.copy();
                                msg_copy.putHeader(this.getName(), hdr);
                                this.queued_msgs.add(msg_copy);
                                this.passUp(new Event(1, msg));
                                return;
                            }
                            if (this.vid != null && hdr.vid != null) {
                                Address my_addr = this.vid.getCoordAddress();
                                Address other_addr = hdr.vid.getCoordAddress();
                                if (my_addr == null || other_addr == null) {
                                    if (this.log.isWarnEnabled()) {
                                        this.log.warn((Object)"my vid or message's vid does not contain a coordinator; discarding message !");
                                    }
                                    return;
                                }
                                if (!my_addr.equals(other_addr)) {
                                    if (this.log.isWarnEnabled()) {
                                        this.log.warn((Object)("creator of own vid (" + my_addr + ")is different from " + "creator of message's vid (" + other_addr + "); discarding message !"));
                                    }
                                    return;
                                }
                                int rc = hdr.vid.compareTo(this.vid);
                                if (rc > 0) {
                                    if (this.log.isInfoEnabled()) {
                                        this.log.info((Object)("message's vid (" + hdr.vid + '#' + hdr.seqno + ") is bigger than current vid: (" + this.vid + ") message is queued !"));
                                    }
                                    msg.putHeader(this.getName(), hdr);
                                    this.queued_msgs.add(msg);
                                    return;
                                }
                                if (rc < 0) {
                                    if (this.log.isWarnEnabled()) {
                                        this.log.warn((Object)("message's vid (" + hdr.vid + ") is smaller than " + "current vid (" + this.vid + "): message <" + msg.getSrc() + ":#" + hdr.seqno + "> is discarded ! Hdr is " + hdr));
                                    }
                                    return;
                                }
                            }
                            msg.putHeader(this.getName(), hdr);
                            this.naker.receive(hdr.seqno, msg, null);
                            return;
                        }
                        case 4: {
                            this.naker.retransmit(msg.getSrc(), hdr.seqno, hdr.last_seqno);
                            return;
                        }
                        case 5: {
                            this.naker.receiveAck(hdr.seqno, msg.getSrc());
                            return;
                        }
                        case 6: {
                            this.out_of_bander.receive(hdr.seqno, msg, hdr.stable_msgs);
                            return;
                        }
                        case 7: {
                            this.out_of_bander.receiveAck(hdr.seqno, msg.getSrc());
                            return;
                        }
                    }
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("NakAck header type " + hdr.type + " not known !"));
                    }
                    break;
                }
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("queued_msgs has " + this.queued_msgs.size() + " messages " + "\n\nnaker:\n" + this.naker.dumpContents() + "\n\nout_of_bander: " + this.out_of_bander.dumpContents() + "\n-----------------------------\n"));
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.vid == null || msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                if (this.send_next_msg_out_of_band) {
                    this.out_of_bander.send(msg);
                    this.send_next_msg_out_of_band = false;
                } else if (this.send_next_msg_acking) {
                    this.naker.setAcks(true);
                    this.naker.send(msg);
                    this.naker.setAcks(false);
                    this.send_next_msg_acking = false;
                } else {
                    this.naker.send(msg);
                }
                return;
            }
            case 31: {
                long[] highest_seqnos = (long[])evt.getArg();
                Digest digest = this.naker.computeMessageDigest(highest_seqnos);
                this.passUp(new Event(32, digest));
                return;
            }
            case 37: {
                List lower_seqnos = this.naker.getMessagesInRange((long[][])evt.getArg());
                this.passUp(new Event(38, lower_seqnos));
                return;
            }
            case 33: {
                this.rebroadcastMsgs((Vector)evt.getArg());
                break;
            }
            case 15: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members = mbrs != null ? (Vector)mbrs.clone() : new Vector(11);
                break;
            }
            case 6: {
                NAKACK nAKACK = this;
                synchronized (nAKACK) {
                    this.view = (View)((View)evt.getArg()).clone();
                    this.vid = this.view.getVid();
                    this.members = (Vector)this.view.getMembers().clone();
                    this.naker.reset();
                    this.out_of_bander.reset();
                    this.is_server = true;
                    if (this.queued_msgs.size() > 0) {
                        this.deliverQueuedMessages();
                    }
                    break;
                }
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 24: {
                this.naker.setAcks(false);
                return;
            }
            case 25: {
                this.send_next_msg_acking = true;
                return;
            }
            case 26: {
                this.send_next_msg_out_of_band = true;
                return;
            }
            case 35: {
                long[] h = this.naker.getHighestSeqnosDelivered();
                this.passUp(new Event(36, h));
            }
        }
        this.passDown(evt);
    }

    boolean coordinator() {
        if (this.members == null || this.members.size() < 1 || this.local_addr == null) {
            return false;
        }
        return this.local_addr.equals(this.members.elementAt(0));
    }

    void rebroadcastMsgs(Vector v) {
        Message m1;
        int i;
        if (v == null) {
            return;
        }
        Vector<Message> final_v = new Vector<Message>(v.size());
        for (i = 0; i < v.size(); ++i) {
            NakAckHeader h1;
            boolean present = false;
            m1 = (Message)v.elementAt(i);
            NakAckHeader nakAckHeader = h1 = m1 != null ? (NakAckHeader)m1.getHeader(this.getName()) : null;
            if (m1 == null || h1 == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"message is null");
                continue;
            }
            for (int j = 0; j < final_v.size(); ++j) {
                NakAckHeader h2;
                Message m2 = (Message)final_v.elementAt(j);
                NakAckHeader nakAckHeader2 = h2 = m2 != null ? (NakAckHeader)m2.getHeader(this.getName()) : null;
                if (m2 == null || h2 == null) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error((Object)"message m2 is null");
                    continue;
                }
                if (h1.seqno != h2.seqno || m1.getSrc() == null || m2.getSrc() == null || !m1.getSrc().equals(m2.getSrc())) continue;
                present = true;
            }
            if (present) continue;
            final_v.addElement(m1);
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("rebroadcasting " + final_v.size() + " messages"));
        }
        for (i = 0; i < final_v.size(); ++i) {
            m1 = (Message)final_v.elementAt(i);
            this.naker.resend(m1);
        }
        this.naker.waitUntilAllAcksReceived(this.rebroadcast_timeout);
        this.passUp(new Event(34));
    }

    void deliverQueuedMessages() {
        while (this.queued_msgs.size() > 0) {
            Message tmpmsg = (Message)this.queued_msgs.removeFromHead();
            NakAckHeader hdr = (NakAckHeader)tmpmsg.getHeader(this.getName());
            int rc = hdr.vid.compareTo(this.vid);
            if (rc == 0) {
                this.up(new Event(1, tmpmsg));
                continue;
            }
            if (rc <= 0) continue;
        }
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("rebroadcast_timeout")) != null) {
            this.rebroadcast_timeout = Long.parseLong(str);
            props.remove("rebroadcast_timeout");
        }
        if (props.size() > 0) {
            this.log.error((Object)("NAKACK.setProperties(): these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    class OutOfBander
    implements AckMcastSenderWindow.RetransmitCommand {
        final AckMcastSenderWindow sender_win;
        final AckMcastReceiverWindow receiver_win;
        long seqno;

        OutOfBander() {
            this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, NAKACK.this.timer);
            this.receiver_win = new AckMcastReceiverWindow();
            this.seqno = 0L;
        }

        void send(Message msg) {
            long id = this.seqno++;
            Vector stable_msgs = this.sender_win.getStableMessages();
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("sending msg #=" + id));
            }
            NakAckHeader hdr = new NakAckHeader(6, id, null);
            hdr.stable_msgs = stable_msgs;
            msg.putHeader(NAKACK.this.getName(), hdr);
            this.sender_win.add(id, msg.copy(), (Vector)NAKACK.this.members.clone());
            NAKACK.this.passDown(new Event(1, msg));
        }

        void receive(long id, Message msg, Vector stable_msgs) {
            Address sender = msg.getSrc();
            Message ack_msg = new Message(msg.getSrc(), null, null);
            NakAckHeader hdr = new NakAckHeader(7, id, null);
            ack_msg.putHeader(NAKACK.this.getName(), hdr);
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("received <" + sender + '#' + id + ">\n"));
            }
            if (this.receiver_win.add(sender, id)) {
                NAKACK.this.passUp(new Event(1, msg));
            }
            NAKACK.this.passDown(new Event(1, ack_msg));
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("sending ack <" + sender + '#' + id + ">\n"));
            }
            if (stable_msgs != null) {
                this.receiver_win.remove(sender, stable_msgs);
            }
        }

        void receiveAck(long id, Address sender) {
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("received ack <" + sender + '#' + id + '>'));
            }
            this.sender_win.ack(id, sender);
        }

        public void retransmit(long seqno, Message msg, Address dest) {
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("dest=" + dest + ", msg #" + seqno));
            }
            msg.setDest(dest);
            NAKACK.this.passDown(new Event(1, msg));
        }

        void reset() {
            this.sender_win.reset();
            this.receiver_win.reset();
        }

        void suspect(Address mbr) {
            this.sender_win.suspect(mbr);
            this.receiver_win.suspect(mbr);
        }

        void start() {
            this.sender_win.start();
        }

        void stop() {
            if (this.sender_win != null) {
                this.sender_win.stop();
            }
        }

        String dumpContents() {
            StringBuffer ret = new StringBuffer();
            ret.append("\nsender_win:\n" + this.sender_win.toString() + "\nreceiver_win:\n" + this.receiver_win.toString());
            return ret.toString();
        }
    }

    class NAKer
    implements Retransmitter.RetransmitCommand,
    AckMcastSenderWindow.RetransmitCommand {
        long seqno = 0L;
        final Hashtable received_msgs = new Hashtable();
        final Hashtable sent_msgs = new Hashtable();
        final AckMcastSenderWindow sender_win;
        boolean acking;
        long deleted_up_to;
        final LastMessageRetransmitter last_msg_xmitter;

        NAKer() {
            this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, NAKACK.this.timer);
            this.acking = false;
            this.deleted_up_to = 0L;
            this.last_msg_xmitter = new LastMessageRetransmitter();
            if (NAKACK.this.timer != null) {
                NAKACK.this.timer.add(this.last_msg_xmitter, true);
            } else if (NAKACK.this.log.isErrorEnabled()) {
                NAKACK.this.log.error((Object)"timer is null");
            }
        }

        long getNextSeqno() {
            return this.seqno++;
        }

        long getHighestSeqnoSent() {
            long highest_sent = -1L;
            Enumeration e = this.sent_msgs.keys();
            while (e.hasMoreElements()) {
                highest_sent = Math.max(highest_sent, (Long)e.nextElement());
            }
            return highest_sent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long[] getHighestSeqnosDelivered() {
            long[] highest_deliv;
            long[] lArray = highest_deliv = NAKACK.this.members != null ? new long[NAKACK.this.members.size()] : null;
            if (highest_deliv == null) {
                return null;
            }
            for (int i = 0; i < highest_deliv.length; ++i) {
                highest_deliv[i] = -1L;
            }
            Vector vector = NAKACK.this.members;
            synchronized (vector) {
                for (int i = 0; i < NAKACK.this.members.size(); ++i) {
                    Address mbr = (Address)NAKACK.this.members.elementAt(i);
                    NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(mbr);
                    if (win == null) continue;
                    highest_deliv[i] = win.getHighestDelivered();
                }
            }
            return highest_deliv;
        }

        List getSentMessagesHigherThan(long seqno) {
            List retval = new List();
            Enumeration e = this.sent_msgs.keys();
            while (e.hasMoreElements()) {
                Long key = (Long)e.nextElement();
                if (key <= seqno) continue;
                retval.add(this.sent_msgs.get(key));
            }
            return retval;
        }

        Digest computeMessageDigest(long[] highest_seqnos) {
            List unstable_msgs;
            Digest digest = highest_seqnos != null ? new Digest(highest_seqnos.length) : null;
            long highest_seqno_sent = -1L;
            long highest_seqno_received = -1L;
            if (digest == null) {
                if (NAKACK.this.log.isWarnEnabled()) {
                    NAKACK.this.log.warn((Object)"highest_seqnos is null, cannot compute digest !");
                }
                return null;
            }
            if (highest_seqnos.length != NAKACK.this.members.size()) {
                if (NAKACK.this.log.isWarnEnabled()) {
                    NAKACK.this.log.warn((Object)"the mbrship size and the size of the highest_seqnos array are not equal, cannot compute digest !");
                }
                return null;
            }
            System.arraycopy(highest_seqnos, 0, digest.highest_seqnos, 0, digest.highest_seqnos.length);
            for (int i = 0; i < highest_seqnos.length; ++i) {
                NakReceiverWindow win;
                Address sender = (Address)NAKACK.this.members.elementAt(i);
                if (sender == null || (win = (NakReceiverWindow)this.received_msgs.get(sender)) == null) continue;
                digest.highest_seqnos[i] = win.getHighestReceived();
                unstable_msgs = win.getMessagesHigherThan(highest_seqnos[i]);
                Enumeration e = unstable_msgs.elements();
                while (e.hasMoreElements()) {
                    digest.msgs.add(e.nextElement());
                }
            }
            int own_index = NAKACK.this.members.indexOf(NAKACK.this.local_addr);
            if (own_index == -1) {
                if (NAKACK.this.log.isWarnEnabled()) {
                    NAKACK.this.log.warn((Object)"no own address in highest_seqnos");
                }
                return digest;
            }
            highest_seqno_received = digest.highest_seqnos[own_index];
            highest_seqno_sent = this.getHighestSeqnoSent();
            if (highest_seqno_sent > highest_seqno_received) {
                digest.highest_seqnos[own_index] = highest_seqno_sent;
                unstable_msgs = this.getSentMessagesHigherThan(highest_seqno_received);
                Enumeration e = unstable_msgs.elements();
                while (e.hasMoreElements()) {
                    digest.msgs.add(e.nextElement());
                }
            }
            return digest;
        }

        List getMessagesInRange(long[][] range) {
            List retval = new List();
            for (int i = 0; i < range.length; ++i) {
                List tmp;
                NakReceiverWindow win;
                Address sender;
                if (range[i] == null || (sender = (Address)NAKACK.this.members.elementAt(i)) == null || (win = (NakReceiverWindow)this.received_msgs.get(sender)) == null || (tmp = win.getMessagesInRange(range[i][0], range[i][1])) == null || tmp.size() < 1) continue;
                Enumeration e = tmp.elements();
                while (e.hasMoreElements()) {
                    retval.add(e.nextElement());
                }
            }
            return retval;
        }

        void setAcks(boolean f) {
            this.acking = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stable(long[] seqnos) {
            if (NAKACK.this.members == null || NAKACK.this.local_addr == null) {
                if (NAKACK.this.log.isWarnEnabled()) {
                    NAKACK.this.log.warn((Object)"members or local_addr are null !");
                }
                return;
            }
            int index = NAKACK.this.members.indexOf(NAKACK.this.local_addr);
            if (index < 0) {
                if (NAKACK.this.log.isWarnEnabled()) {
                    NAKACK.this.log.warn((Object)("member " + NAKACK.this.local_addr + " not found in " + NAKACK.this.members));
                }
                return;
            }
            long seqno = seqnos[index];
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("deleting stable messages [" + this.deleted_up_to + " - " + seqno + ']'));
            }
            Hashtable hashtable = this.sent_msgs;
            synchronized (hashtable) {
                for (long i = this.deleted_up_to; i <= seqno; ++i) {
                    this.sent_msgs.remove(new Long(i));
                }
                this.deleted_up_to = seqno;
            }
            for (int i = 0; i < NAKACK.this.members.size(); ++i) {
                Address sender = (Address)NAKACK.this.members.elementAt(i);
                NakReceiverWindow recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (recv_win == null) continue;
                recv_win.stable(seqnos[i]);
            }
        }

        void send(Message msg) {
            long id = this.getNextSeqno();
            if (NAKACK.this.vid == null) {
                return;
            }
            ViewId vid_copy = (ViewId)NAKACK.this.vid.clone();
            if (this.acking) {
                msg.putHeader(NAKACK.this.getName(), new NakAckHeader(2, id, vid_copy));
                this.sender_win.add(id, msg.copy(), (Vector)NAKACK.this.members.clone());
            } else {
                msg.putHeader(NAKACK.this.getName(), new NakAckHeader(1, id, vid_copy));
            }
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("sending msg #" + id));
            }
            this.sent_msgs.put(new Long(id), msg.copy());
            NAKACK.this.passDown(new Event(1, msg));
        }

        void resend(Message msg) {
            Message copy = msg.copy();
            NakAckHeader hdr = (NakAckHeader)copy.getHeader(NAKACK.this.getName());
            long id = hdr.seqno;
            if (NAKACK.this.vid == null) {
                return;
            }
            copy.setDest(null);
            NakAckHeader wrapped_hdr = new NakAckHeader(3, hdr.seqno, hdr.vid);
            wrapped_hdr.sender = NAKACK.this.local_addr;
            copy.putHeader(NAKACK.WRAPPED_MSG_KEY, wrapped_hdr);
            this.sender_win.add(id, copy.copy(), (Vector)NAKACK.this.members.clone());
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("resending " + copy.getHeader(NAKACK.this.getName())));
            }
            NAKACK.this.passDown(new Event(1, copy));
        }

        void waitUntilAllAcksReceived(long timeout) {
            this.sender_win.waitUntilAllAcksReceived(timeout);
        }

        void receive(long id, Message msg, Vector stable_msgs) {
            Message msg_to_deliver;
            Address sender = msg.getSrc();
            NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
            if (win == null) {
                win = new NakReceiverWindow(sender, this, 0L);
                win.setRetransmitTimeouts(NAKACK.this.retransmit_timeout);
                this.received_msgs.put(sender, win);
            }
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("received <" + sender + '#' + id + '>'));
            }
            win.add(id, msg);
            while ((msg_to_deliver = win.remove()) != null) {
                if (msg_to_deliver.getHeader(NAKACK.this.getName()) instanceof NakAckHeader) {
                    msg_to_deliver.removeHeader(NAKACK.this.getName());
                }
                NAKACK.this.passUp(new Event(1, msg_to_deliver));
            }
        }

        void receiveAck(long id, Address sender) {
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("received ack <-- ACK <" + sender + '#' + id + '>'));
            }
            this.sender_win.ack(id, sender);
        }

        public void retransmit(long seqno, Message msg, Address dest) {
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("retransmitting message " + seqno + " to " + dest + ", header is " + msg.getHeader(NAKACK.this.getName())));
            }
            if (NAKACK.this.members != null && !NAKACK.this.members.contains(dest)) {
                if (NAKACK.this.log.isInfoEnabled()) {
                    NAKACK.this.log.info((Object)("retransmitting " + seqno + ") to " + dest + ": " + dest + " is not a member; discarding retransmission and removing " + dest + " from sender_win"));
                }
                this.sender_win.remove(dest);
                return;
            }
            msg.setDest(dest);
            NAKACK.this.passDown(new Event(1, msg));
        }

        public void retransmit(long first_seqno, long last_seqno, Address sender) {
            if (NAKACK.this.log.isInfoEnabled()) {
                NAKACK.this.log.info((Object)("retransmit([" + first_seqno + ", " + last_seqno + "]) to " + sender + ", vid=" + NAKACK.this.vid));
            }
            NakAckHeader hdr = new NakAckHeader(4, first_seqno, (ViewId)NAKACK.this.vid.clone());
            Message retransmit_msg = new Message(sender, null, null);
            hdr.last_seqno = last_seqno;
            retransmit_msg.putHeader(NAKACK.this.getName(), hdr);
            NAKACK.this.passDown(new Event(1, retransmit_msg));
        }

        void retransmit(Address dest, long first_seqno, long last_seqno) {
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message m = (Message)this.sent_msgs.get(new Long(i));
                if (m == null) {
                    if (!NAKACK.this.log.isWarnEnabled()) continue;
                    NAKACK.this.log.warn((Object)("(to " + dest + "): message with " + "seqno=" + i + " not found !"));
                    continue;
                }
                Message retr_msg = m.copy();
                retr_msg.setDest(dest);
                try {
                    NAKACK.this.passDown(new Event(1, retr_msg));
                    continue;
                }
                catch (Exception e) {
                    if (!NAKACK.this.log.isDebugEnabled()) continue;
                    NAKACK.this.log.debug((Object)("exception is " + e));
                }
            }
        }

        void stop() {
            if (this.sender_win != null) {
                this.sender_win.stop();
            }
        }

        void reset() {
            if (!NAKACK.this.coordinator()) {
                this.sender_win.reset();
            }
            this.sent_msgs.clear();
            Enumeration e = this.received_msgs.elements();
            while (e.hasMoreElements()) {
                NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
                win.reset();
            }
            this.received_msgs.clear();
            this.seqno = 0L;
            this.deleted_up_to = 0L;
        }

        public void suspect(Address mbr) {
            NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(mbr);
            if (w != null) {
                w.reset();
                this.received_msgs.remove(mbr);
            }
            this.sender_win.suspect(mbr);
        }

        String dumpContents() {
            StringBuffer ret = new StringBuffer();
            ret.append("\nsent_msgs: " + this.sent_msgs.size());
            ret.append("\nreceived_msgs: ");
            Enumeration e = this.received_msgs.keys();
            while (e.hasMoreElements()) {
                Address key = (Address)e.nextElement();
                NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(key);
                ret.append('\n' + w.toString());
            }
            ret.append("\nsender_win: " + this.sender_win.toString());
            return ret.toString();
        }

        private class LastMessageRetransmitter
        implements TimeScheduler.Task {
            boolean stopped = false;
            int num_times = 2;
            long last_xmitted_seqno = 0L;

            private LastMessageRetransmitter() {
            }

            public void stop() {
                this.stopped = true;
            }

            public boolean cancelled() {
                return this.stopped;
            }

            public long nextInterval() {
                return ((NAKer)NAKer.this).NAKACK.this.retransmit_timeout[0];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Hashtable hashtable = NAKer.this.sent_msgs;
                synchronized (hashtable) {
                    long prevSeqno = NAKer.this.seqno - 1L;
                    if (prevSeqno == this.last_xmitted_seqno) {
                        if (NAKACK.this.log.isInfoEnabled()) {
                            NAKACK.this.log.info((Object)("prevSeqno=" + prevSeqno + ", last_xmitted_seqno=" + this.last_xmitted_seqno + ", num_times=" + this.num_times));
                        }
                        if (--this.num_times <= 0) {
                            return;
                        }
                    } else {
                        this.num_times = 3;
                        this.last_xmitted_seqno = prevSeqno;
                    }
                    if (prevSeqno >= 0L && prevSeqno > NAKer.this.deleted_up_to) {
                        if (NAKACK.this.log.isInfoEnabled()) {
                            NAKACK.this.log.info((Object)("retransmitting last message " + prevSeqno));
                        }
                        NAKer.this.retransmit(null, prevSeqno, prevSeqno);
                    }
                }
            }
        }
    }
}

