/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.util.Util;

public class TestPoolExecutor
extends TestCase {
    static int count;
    private final Object poolLock = new Object();

    public void testPool() throws InterruptedException {
        long keepAlive = 30000L;
        PooledExecutor executor = new PooledExecutor(5);
        executor.setMinimumPoolSize(1);
        executor.waitWhenBlocked();
        executor.setKeepAliveTime(keepAlive);
        executor.setThreadFactory(new ThreadFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Thread newThread(Runnable command) {
                Object object = TestPoolExecutor.this.poolLock;
                synchronized (object) {
                }
                return new Thread(this, "poolid=" + ++count, command){
                    private final /* synthetic */ Runnable val$command;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$command = val$command;
                        super(x0);
                    }

                    public void run() {
                        System.out.println("Thread " + Thread.currentThread() + " started");
                        this.val$command.run();
                        System.out.println("Thread " + Thread.currentThread() + " stopped");
                    }
                };
            }
        });
        int i = 0;
        while (i < 30) {
            final int count = i++;
            executor.execute(new Runnable(){

                public void run() {
                    System.out.println("Runnable " + count + " running");
                    Util.sleep(3000L);
                }
            });
            Util.sleep(1000L);
        }
        executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        Util.sleep(keepAlive);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(TestPoolExecutor.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{TestPoolExecutor.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

