/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.GossipRouter;
import org.jgroups.stack.IpAddress;

public class Utilities {
    static Log log = LogFactory.getLog((Class)Utilities.class);
    private static GossipRouter gossipRouter = null;

    public static int startGossipRouter() throws Exception {
        return Utilities.startGossipRouter(30000L, "localhost", 1000L, 120000L);
    }

    public static int startGossipRouter(String bind_addr) throws Exception {
        return Utilities.startGossipRouter(30000L, bind_addr, 1000L, 120000L);
    }

    public static int startGossipRouter(long expiryTime) throws Exception {
        return Utilities.startGossipRouter(expiryTime, "localhost", 1000L, 120000L);
    }

    public static int startGossipRouter(long expiryTime, String bind_addr) throws Exception {
        return Utilities.startGossipRouter(expiryTime, bind_addr, 1000L, 120000L);
    }

    public static int startGossipRouter(long expiryTime, String bind_addr, long gossipRequestTimeout, long routingClientReplyTimeout) throws Exception {
        if (gossipRouter != null) {
            throw new Exception("GossipRouter already started");
        }
        int routerPort = Utilities.getFreePort();
        try {
            gossipRouter = new GossipRouter(routerPort, bind_addr, expiryTime, gossipRequestTimeout, routingClientReplyTimeout);
            gossipRouter.start();
        }
        catch (Exception e) {
            log.error((Object)("Failed to start the router on port " + routerPort));
            gossipRouter = null;
            throw e;
        }
        GossipClient client = null;
        long startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        long crtms = startms;
        while (crtms - startms < 10000L) {
            try {
                client = new GossipClient(new IpAddress(bind_addr, routerPort), 10000L);
                client.getMembers("Utilities:startGossipRouterConnectionTest");
                lastConnectException = null;
                break;
            }
            catch (Exception e) {
                if (client != null) {
                    client.stop();
                }
                lastConnectException = e;
                Thread.sleep(1000L);
                crtms = System.currentTimeMillis();
            }
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            throw new Exception("Cannot connect to the router");
        }
        return routerPort;
    }

    public static void stopGossipRouter() throws Exception {
        if (gossipRouter == null) {
            throw new Exception("There's no GossipRouter running");
        }
        gossipRouter.stop();
        System.out.println("router stopped");
        gossipRouter = null;
    }

    public static int getFreePort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }
}

